/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PercentHaveTheyNeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PercentHaveTheyNeedItem(String table_id) {
        super("havetheyneed", 2, -1, 55, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean[] peer_has;
        BitFlags bf;
        PEPeerManager pm;
        PEPeer peer = (PEPeer)cell.getDataSource();
        int value = -1;
        if (peer != null && !peer.isSeed() && !peer.isMyPeer() && (pm = peer.getManager()) != null && (bf = peer.getAvailable()) != null && (peer_has = bf.flags) != null) {
            int we_have = 0;
            int we_have_they_want = 0;
            DiskManagerPiece[] dm_pieces = pm.getDiskManager().getPieces();
            int i = 0;
            while (i < dm_pieces.length) {
                DiskManagerPiece piece = dm_pieces[i];
                if (piece.isDone()) {
                    ++we_have;
                    if (!peer_has[i]) {
                        ++we_have_they_want;
                    }
                }
                ++i;
            }
            value = we_have_they_want > 0 ? 1000 * we_have_they_want / we_have : 0;
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value < 0 ? "" : DisplayFormatters.formatPercentFromThousands(value));
    }
}

