/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class TimeUntilCompleteItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public TimeUntilCompleteItem(String table_id) {
        super("timetocomplete", 2, -1, 65, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = value = peer == null ? Long.MAX_VALUE : peer.getStats().getEstimatedSecondsToCompletion();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value > 604800L) {
            value = Long.MAX_VALUE;
        }
        cell.setText(DisplayFormatters.formatETA(value));
    }
}

