/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class UpSpeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public UpSpeedItem(String table_id) {
        super("uploadspeed", 2, -2, 65, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    @Override
    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getDataSendRate();
            prot_value = peer.getStats().getProtocolSendRate();
        }
        if (!cell.setSortValue(sort_value = (data_value << 32) + prot_value) && cell.isValid()) {
            return;
        }
        cell.setNumeric(data_value);
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(data_value, prot_value));
    }
}

