/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class UpSpeedLimitItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "maxupspeed";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
    }

    public UpSpeedLimitItem(String table_id) {
        super(COLUMN_ID, 2, -1, 35, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        long value = peer == null ? 0 : peer.getUploadRateLimitBytesPerSecond();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value == -1L) {
            cell.setText(MessageText.getString("MyTorrents.items.UpSpeedLimit.disabled"));
        } else if (value == 0L) {
            cell.setText("\u221e");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
        }
    }
}

