/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.pieces;

import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FilesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FilesItem(String table_id) {
        super("Files", 1, -1, 200, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerPiece dmp;
        PEPiece pePiece = (PEPiece)cell.getDataSource();
        String value = "";
        if (pePiece != null && (dmp = pePiece.getDMPiece()) != null) {
            DMPieceList l = dmp.getManager().getPieceList(pePiece.getPieceNumber());
            int i = 0;
            while (i < l.size()) {
                DMPieceMapEntry entry = l.get(i);
                String name = entry.getFile().getTorrentFile().getRelativePath();
                value = String.valueOf(value) + (value.isEmpty() ? "" : "; ") + name;
                ++i;
            }
        }
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

