/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.tracker;

import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ReportedDownItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public ReportedDownItem(String tableID) {
        super("reported_down", 2, -1, 75, tableID);
        this.setRefreshInterval(-1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String str;
        long sort;
        long[] stats2;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        long[] lArray = stats2 = ps == null ? null : ps.getReportedStats();
        if (stats2 != null) {
            long gu = stats2[1];
            long uu = stats2[3];
            long su = stats2[5];
            long l = gu != 0L ? gu : (sort = uu != 0L ? uu : su);
            if (sort == 0L) {
                str = "";
            } else {
                str = uu > 0L ? DisplayFormatters.formatByteCountToKiBEtc(uu) : "";
                if (gu != 0L && gu != uu) {
                    str = String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(gu)) + (str.isEmpty() ? "" : "/" + str);
                }
                if (su > 0L) {
                    str = String.valueOf(str) + " (" + DisplayFormatters.formatByteCountToKiBEtc(su) + ")";
                }
            }
        } else {
            sort = -1L;
            str = "";
        }
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

