/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.Core;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.utils.LocationProvider;
import com.biglybt.pif.utils.LocationProviderListener;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class LocProvUtils
implements LocationProviderListener {
    private static LocProvUtils singleton;
    private Core core;
    private LocationProvider active_provider;
    private boolean cl_installed;
    private List<TableColumn> columns = new ArrayList<TableColumn>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(Core core) {
        Class<LocProvUtils> clazz = LocProvUtils.class;
        synchronized (LocProvUtils.class) {
            if (singleton == null) {
                singleton = new LocProvUtils(core);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private LocProvUtils(Core _core) {
        this.core = _core;
        PluginManager pm = this.core.getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        pi.getUtilities().addLocationProviderListener(this);
        PluginInterface cl_pi = pm.getPluginInterfaceByID("CountryLocator");
        if (cl_pi != null && cl_pi.getPluginState().isOperational()) {
            this.cl_installed = true;
        }
        pi.addEventListener(new PluginEventListener(){

            @Override
            public void handleEvent(PluginEvent ev) {
                String id;
                if (ev.getType() == 10) {
                    String id2 = (String)ev.getValue();
                    if (id2.equals("CountryLocator")) {
                        LocProvUtils.this.cl_installed = true;
                        LocProvUtils.this.removeColumns();
                    }
                } else if (ev.getType() == 12 && (id = (String)ev.getValue()).equals("CountryLocator")) {
                    LocProvUtils.this.cl_installed = false;
                    LocProvUtils.this.addColumns();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationProviderAdded(LocationProvider lp) {
        LocProvUtils locProvUtils = this;
        synchronized (locProvUtils) {
            if (this.active_provider == null && lp.hasCapabilities(7L)) {
                this.active_provider = lp;
                this.addColumns();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationProviderRemoved(LocationProvider lp) {
        LocProvUtils locProvUtils = this;
        synchronized (locProvUtils) {
            if (lp == this.active_provider) {
                this.active_provider = null;
                this.removeColumns();
            }
        }
    }

    private String getCountryCode(Peer peer) {
        String[] details = PeerUtils.getCountryDetails(peer);
        return details == null || details.length < 1 ? "" : details[0];
    }

    private String getCountryName(Peer peer) {
        String[] details = PeerUtils.getCountryDetails(peer);
        return details == null || details.length < 1 ? "" : details[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumns() {
        LocProvUtils locProvUtils = this;
        synchronized (locProvUtils) {
            if (this.cl_installed || this.active_provider == null) {
                return;
            }
            TableManager tm = this.core.getPluginManager().getDefaultPluginInterface().getUIManager().getTableManager();
            String[] peer_tables = new String[]{"Peers", "AllPeers"};
            int i = 0;
            while (i < peer_tables.length) {
                TableColumn iso3166Column = tm.createColumn(peer_tables[i], "CountryCode");
                iso3166Column.initialize(1, -2, 30, -3);
                iso3166Column.addCellRefreshListener(new TableCellRefreshListener(){

                    @Override
                    public void refresh(TableCell cell) {
                        Peer peer = (Peer)cell.getDataSource();
                        String s = LocProvUtils.this.getCountryCode(peer);
                        if (!cell.setSortValue((Comparable)((Object)s)) && cell.isValid()) {
                            return;
                        }
                        cell.setText(s);
                    }
                });
                tm.addColumn(iso3166Column);
                this.columns.add(iso3166Column);
                TableColumn countryColumn = tm.createColumn(peer_tables[i], "Country");
                countryColumn.initialize(1, -1, 80, -3);
                countryColumn.addCellRefreshListener(new TableCellRefreshListener(){

                    @Override
                    public void refresh(TableCell cell) {
                        Peer peer = (Peer)cell.getDataSource();
                        String s = LocProvUtils.this.getCountryName(peer);
                        if (!cell.setSortValue((Comparable)((Object)s)) && cell.isValid()) {
                            return;
                        }
                        cell.setText(s);
                    }
                });
                tm.addColumn(countryColumn);
                this.columns.add(countryColumn);
                TableColumn flagsColumn = tm.createColumn(peer_tables[i], "CountryFlagSmall");
                flagsColumn.initialize(1, -1, 25, -3);
                flagsColumn.setType(2);
                FlagListener flagListener = new FlagListener(true);
                flagsColumn.addCellRefreshListener(flagListener);
                flagsColumn.addCellToolTipListener(flagListener);
                tm.addColumn(flagsColumn);
                this.columns.add(flagsColumn);
                flagsColumn = tm.createColumn(peer_tables[i], "CountryFlag");
                flagsColumn.initialize(1, -2, 25, -3);
                flagsColumn.setType(2);
                flagListener = new FlagListener(false);
                flagsColumn.addCellRefreshListener(flagListener);
                flagsColumn.addCellToolTipListener(flagListener);
                tm.addColumn(flagsColumn);
                this.columns.add(flagsColumn);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColumns() {
        LocProvUtils locProvUtils = this;
        synchronized (locProvUtils) {
            for (TableColumn c : this.columns) {
                c.remove();
            }
        }
    }

    private class FlagListener
    implements TableCellRefreshListener,
    TableCellToolTipListener {
        private final boolean small;

        public FlagListener(boolean _small) {
            this.small = _small;
        }

        @Override
        public void refresh(TableCell cell) {
            Peer peer = (Peer)cell.getDataSource();
            Image image = ImageRepository.getCountryFlag(peer, this.small);
            String cc = LocProvUtils.this.getCountryCode(peer);
            if (!cell.setSortValue((Comparable)((Object)cc)) && cell.isValid()) {
                return;
            }
            cell.setGraphic(new UISWTGraphicImpl(image));
        }

        @Override
        public void cellHover(TableCell cell) {
            Peer peer = (Peer)cell.getDataSource();
            String[] details = PeerUtils.getCountryDetails(peer);
            if (details == null || details.length < 2) {
                cell.setToolTip("");
            } else {
                cell.setToolTip(String.valueOf(details[0]) + " - " + details[1]);
            }
        }

        @Override
        public void cellHoverComplete(TableCell cell) {
            cell.setToolTip(null);
        }
    }
}

