/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.ui.swt.widgets.TagCanvas;
import com.biglybt.ui.swt.widgets.TagPainter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class TagButtonsUI {
    private final List<TagCanvas> tagWidgets = new ArrayList<TagCanvas>();
    private Composite cMainComposite;
    private boolean enableWhenNoTaggables;
    private boolean disableAuto = true;
    private int layoutStyle = COConfigurationManager.getIntParameter("TagButtons.style", 256);
    public static final int UPDATETAG_REQUIRES_REBUILD = 1;
    public static final int UPDATETAG_SUCCESS = 0;
    public static final int UPDATETAG_NOCHANGE = -1;

    public Composite buildTagGroup(List<Tag> tags, Composite parent, boolean allowContextMenu, TagCanvas.TagButtonTrigger trigger) {
        this.cMainComposite = new Composite(parent, 0);
        RowLayout mainLayout = Utils.getSimpleRowLayout(false);
        mainLayout.type = 512;
        this.cMainComposite.setLayout((Layout)mainLayout);
        this.tagWidgets.clear();
        Listener menuDetectListener = allowContextMenu ? event2 -> {
            TagCanvas tagCanvas = (TagCanvas)event2.widget;
            Menu menu = new Menu((Control)tagCanvas);
            tagCanvas.setMenu(menu);
            MenuBuildUtils.addMaintenanceListenerForMenu(menu, (menu1, menuEvent) -> TagUIUtils.createSideBarMenuItems(menu1, tagCanvas.getTagPainter().getTag()));
        } : null;
        tags = TagUtils.sortTags(tags);
        Composite g = null;
        String group = null;
        for (Tag tag : tags) {
            String newGroup = tag.getGroup();
            if (g == null || group != null && !group.equals(newGroup) || group == null && newGroup != null) {
                group = newGroup;
                Object object = g = group == null ? new Composite(this.cMainComposite, 0x20000000) : Utils.createSkinnedGroup(this.cMainComposite, 0x20000000);
                if (group != null) {
                    final Group groupControl = (Group)g;
                    groupControl.setText(group);
                    Menu menu = new Menu((Control)g);
                    g.setMenu(menu);
                    MenuBuildUtils.addMaintenanceListenerForMenu(menu, (root_menu, menuEvent) -> TagUIUtils.createSideBarMenuItems(root_menu, tag.getGroupContainer()));
                    g.addMenuDetectListener(e -> {
                        Group thisGroup = (Group)e.widget;
                        Point point = thisGroup.toControl(e.x, e.y);
                        Rectangle clientArea = thisGroup.getClientArea();
                        if (point.y > clientArea.y) {
                            e.doit = false;
                        }
                    });
                    DropTarget dropTarget = new DropTarget((Control)groupControl, 2);
                    dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                    dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                        public void dragEnter(DropTargetEvent event2) {
                            Object data = event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data;
                            List<Tag> droppedTags = DragDropUtils.getTagsFromDroppedData(data);
                            if (droppedTags.isEmpty()) {
                                event2.detail = 0;
                            }
                        }

                        public void drop(DropTargetEvent event2) {
                            Object data = event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data;
                            List<Tag> droppedTags = DragDropUtils.getTagsFromDroppedData(data);
                            if (droppedTags.isEmpty()) {
                                event2.detail = 0;
                                return;
                            }
                            for (Tag droppedTag : droppedTags) {
                                droppedTag.setGroup(groupControl.getText());
                            }
                        }
                    });
                }
                RowLayout rowLayout = new RowLayout(256);
                rowLayout.pack = true;
                rowLayout.spacing = 5;
                g.setLayout((Layout)rowLayout);
            }
            TagCanvas p = new TagCanvas(g, tag, this.disableAuto, this.enableWhenNoTaggables);
            p.setTrigger(trigger);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 3;
            if (Constants.isWindows) {
                layout.marginWidth = 0;
                layout.marginLeft = 4;
                layout.marginRight = 7;
                layout.marginTop = 1;
            } else {
                layout.marginWidth = 0;
                layout.marginLeft = 3;
                layout.marginRight = 11;
            }
            p.setLayout((Layout)layout);
            if (allowContextMenu) {
                p.addListener(35, menuDetectListener);
            }
            p.addDisposeListener(e -> {
                boolean bl = this.tagWidgets.remove((Object)((TagCanvas)e.widget));
            });
            this.tagWidgets.add(p);
        }
        this.setLayoutStyle(this.layoutStyle);
        return this.cMainComposite;
    }

    public void setSelectedTags(List<Tag> tags) {
        HashSet<Tag> tag_set = new HashSet<Tag>(tags);
        for (TagCanvas widget : this.tagWidgets) {
            TagPainter painter = widget.getTagPainter();
            Tag tag = painter.getTag();
            if (tag == null) continue;
            boolean select = tag_set.contains(tag);
            painter.setSelected(select);
        }
    }

    public List<Tag> getSelectedTags() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        if (this.tagWidgets.isEmpty()) {
            return result;
        }
        for (TagCanvas tagCanvas : this.tagWidgets) {
            TagPainter painter = tagCanvas.getTagPainter();
            if (!painter.isSelected()) continue;
            result.add(painter.getTag());
        }
        return result;
    }

    public boolean updateFields(List<Taggable> taggables) {
        if (this.cMainComposite.isDisposed()) {
            return false;
        }
        for (TagCanvas tagWidget : new ArrayList<TagCanvas>(this.tagWidgets)) {
            tagWidget.getTagPainter().updateState(taggables);
        }
        return false;
    }

    public void setDisableAuto(boolean b) {
        this.disableAuto = b;
        Utils.execSWTThread(() -> {
            for (TagCanvas tagWidget : this.tagWidgets) {
                tagWidget.getTagPainter().setDisableAuto(this.disableAuto);
            }
        });
    }

    public void setEnableWhenNoTaggables(boolean enableWhenNoTaggables) {
        this.enableWhenNoTaggables = enableWhenNoTaggables;
        Utils.execSWTThread(() -> {
            for (TagCanvas widget : this.tagWidgets) {
                widget.getTagPainter().setEnableWhenNoTaggables(enableWhenNoTaggables);
            }
        });
    }

    public void setLayoutStyle(int layoutStyle) {
        RowLayout rowLayout;
        Control child;
        int n;
        int n2;
        Control[] controlArray;
        RowLayout mainLayout;
        this.layoutStyle = layoutStyle;
        COConfigurationManager.setParameter("TagButtons.style", layoutStyle);
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        Control[] children = this.cMainComposite.getChildren();
        int style = this.layoutStyle & 0x300;
        boolean compact = style == 512 || (layoutStyle & 4) > 0;
        this.cMainComposite.setLayoutDeferred(true);
        if (compact) {
            mainLayout = Utils.getSimpleRowLayout(false);
            mainLayout.type = 256;
            mainLayout.wrap = true;
            this.cMainComposite.setLayout((Layout)mainLayout);
            controlArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                child = controlArray[n];
                child.setLayoutData((Object)new RowData());
                if (child instanceof Composite) {
                    rowLayout = new RowLayout(style);
                    rowLayout.pack = true;
                    rowLayout.spacing = 5;
                    ((Composite)child).setLayout((Layout)rowLayout);
                }
                ++n;
            }
        } else {
            mainLayout = new GridLayout();
            this.cMainComposite.setLayout((Layout)mainLayout);
            controlArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                child = controlArray[n];
                child.setLayoutData((Object)new GridData(4, 4, true, true));
                if (child instanceof Composite) {
                    rowLayout = new RowLayout(style);
                    rowLayout.pack = true;
                    rowLayout.spacing = 5;
                    ((Composite)child).setLayout((Layout)rowLayout);
                }
                ++n;
            }
        }
        this.cMainComposite.setLayoutDeferred(false);
        try {
            this.cMainComposite.requestLayout();
        }
        catch (Throwable mainLayout2) {
            // empty catch block
        }
        Composite c = this.cMainComposite;
        while (c != null) {
            if (c instanceof ScrolledComposite) {
                Rectangle r = c.getClientArea();
                Point size = ((ScrolledComposite)c).getContent().computeSize(r.width, -1);
                ((ScrolledComposite)c).setMinSize(size);
            }
            c = c.getParent();
        }
    }

    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    public int updateTag(Tag tag, List<Taggable> taggables) {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return -1;
        }
        for (TagCanvas tagWidget : this.tagWidgets) {
            TagPainter painter = tagWidget.getTagPainter();
            if (!tag.equals(painter.getTag())) continue;
            Composite parent = tagWidget.getParent();
            String oldGroup = parent instanceof Group ? ((Group)parent).getText() : "";
            String newGroup = painter.getTag().getGroup();
            if (newGroup == null) {
                newGroup = "";
            }
            if (!oldGroup.equals(newGroup)) {
                return 1;
            }
            painter.updateState(taggables);
            return 0;
        }
        return 0;
    }
}

