/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureExecOnAssign;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureNotifications;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRSSFeed;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagFeatureRunState;
import com.biglybt.core.tag.TagFeatureTranscode;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.TrackersUtil;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.ListenerDMTask;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.maketorrent.MultiTrackerEditor;
import com.biglybt.ui.swt.maketorrent.TrackerEditorListener;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.stats.StatsView;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.TrancodeUIUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TagUIUtils {
    public static final int MAX_TOP_LEVEL_TAGS_IN_MENU = 20;
    private static final AsyncDispatcher move_dispatcher = new AsyncDispatcher("tag:applytocurrent");

    public static String getChatKey(Tag tag) {
        return "Tag: " + tag.getTagName(true);
    }

    public static void setupSideBarMenus(final MenuManager menuManager) {
        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.header.transfers", "ConfigView.section.style.TagInSidebar");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.TagInSideBar");
                COConfigurationManager.setParameter("Library.TagInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter("Library.TagInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "!    " + MessageText.getString("ConfigView.section.style.TagGroupsInSidebar") + "!");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.TagGroupsInSideBar");
                COConfigurationManager.setParameter("Library.TagGroupsInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter("Library.TagGroupsInSideBar"));
                menu.setEnabled(COConfigurationManager.getBooleanParameter("Library.TagInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "label.tags");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.removeAllChildItems();
                final TagType manual_tt = TagManagerFactory.getTagManager().getTagType(3);
                com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, manual_tt.getTagTypeName(false));
                menuItem.setStyle(5);
                menuItem.addFillListener(new MenuItemFillListener(){

                    @Override
                    public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                        menu.removeAllChildItems();
                        final List<Tag> all_tags = manual_tt.getTags();
                        ArrayList<String> menu_names = new ArrayList<String>();
                        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
                        boolean all_visible = true;
                        boolean all_invisible = true;
                        boolean has_ut = false;
                        for (Tag t : all_tags) {
                            Boolean b;
                            String name = t.getTagName(true);
                            menu_names.add(name);
                            menu_name_map.put(name, t);
                            if (t.isVisible()) {
                                all_invisible = false;
                            } else {
                                all_visible = false;
                            }
                            TagFeatureProperties props = (TagFeatureProperties)((Object)t);
                            TagFeatureProperties.TagProperty prop = props.getProperty("untagged");
                            if (prop == null || (b = prop.getBoolean()) == null || !b.booleanValue()) continue;
                            has_ut = true;
                        }
                        com.biglybt.pif.ui.menus.MenuItem showAllItem = menuManager.addMenuItem(menu, "label.show.all");
                        showAllItem.setStyle(1);
                        showAllItem.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                for (Tag t : all_tags) {
                                    t.setVisible(true);
                                }
                            }
                        });
                        com.biglybt.pif.ui.menus.MenuItem hideAllItem = menuManager.addMenuItem(menu, "popup.error.hideall");
                        hideAllItem.setStyle(1);
                        hideAllItem.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                for (Tag t : all_tags) {
                                    t.setVisible(false);
                                }
                            }
                        });
                        com.biglybt.pif.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sepm");
                        sepItem.setStyle(4);
                        showAllItem.setEnabled(!all_visible);
                        hideAllItem.setEnabled(!all_invisible);
                        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
                        for (Object obj : menu_structure) {
                            com.biglybt.pif.ui.menus.MenuItem parent_menu;
                            ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
                            if (obj instanceof String) {
                                parent_menu = menu;
                                bucket_tags.add((Tag)menu_name_map.get((String)obj));
                            } else {
                                Object[] entry = (Object[])obj;
                                List tag_names = (List)entry[1];
                                boolean sub_all_visible = true;
                                boolean sub_some_visible = false;
                                for (String name : tag_names) {
                                    Tag tag = (Tag)menu_name_map.get(name);
                                    if (tag.isVisible()) {
                                        sub_some_visible = true;
                                    } else {
                                        sub_all_visible = false;
                                    }
                                    bucket_tags.add(tag);
                                }
                                String mod = sub_all_visible ? " (*)" : (sub_some_visible ? " (+)" : "");
                                parent_menu = menuManager.addMenuItem(menu, "!" + (String)entry[0] + mod + "!");
                                parent_menu.setStyle(5);
                            }
                            for (final Tag tag : bucket_tags) {
                                com.biglybt.pif.ui.menus.MenuItem m = menuManager.addMenuItem(parent_menu, tag.getTagName(false));
                                m.setStyle(2);
                                m.setData(tag.isVisible());
                                TagUIUtils.setMenuIcon(m, tag);
                                m.addListener(new MenuItemListener(){

                                    @Override
                                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                        tag.setVisible(!tag.isVisible());
                                    }
                                });
                            }
                        }
                        if (!has_ut) {
                            sepItem = menuManager.addMenuItem(menu, "sepu");
                            sepItem.setStyle(4);
                            com.biglybt.pif.ui.menus.MenuItem m = menuManager.addMenuItem(menu, "label.untagged");
                            m.setStyle(1);
                            m.addListener(new MenuItemListener(){

                                @Override
                                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                    try {
                                        String tag_name = MessageText.getString("label.untagged");
                                        Tag ut_tag = manual_tt.getTag(tag_name, true);
                                        if (ut_tag == null) {
                                            ut_tag = manual_tt.createTag(tag_name, true);
                                        }
                                        TagFeatureProperties tp2 = (TagFeatureProperties)((Object)ut_tag);
                                        tp2.getProperty("untagged").setBoolean(true);
                                    }
                                    catch (TagException e) {
                                        Debug.out(e);
                                    }
                                }
                            });
                        }
                    }
                });
                menuItem = menuManager.addMenuItem(menu, "label.add.tag");
                menuItem.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        TagUIUtils.createManualTag(null);
                    }
                });
                com.biglybt.pif.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sep1");
                sepItem.setStyle(4);
                menuItem = menuManager.addMenuItem(menu, "wizard.maketorrent.auto");
                menuItem.setStyle(5);
                menuItem.addFillListener(new MenuItemFillListener(){

                    @Override
                    public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                        menu.removeAllChildItems();
                        List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
                        for (final TagType tag_type : tag_types) {
                            if (tag_type.getTagType() == 1 || !tag_type.isTagTypeAuto() || tag_type.getTags().size() == 0) continue;
                            com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, tag_type.getTagTypeName(false));
                            menuItem.setStyle(5);
                            menuItem.addFillListener(new MenuItemFillListener(){

                                @Override
                                public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                                    menu.removeAllChildItems();
                                    final List<Tag> tags = tag_type.getTags();
                                    com.biglybt.pif.ui.menus.MenuItem showAllItem = menuManager.addMenuItem(menu, "label.show.all");
                                    showAllItem.setStyle(1);
                                    showAllItem.addListener(new MenuItemListener(){

                                        @Override
                                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                            for (Tag t : tags) {
                                                t.setVisible(true);
                                            }
                                        }
                                    });
                                    com.biglybt.pif.ui.menus.MenuItem hideAllItem = menuManager.addMenuItem(menu, "popup.error.hideall");
                                    hideAllItem.setStyle(1);
                                    hideAllItem.addListener(new MenuItemListener(){

                                        @Override
                                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                            for (Tag t : tags) {
                                                t.setVisible(false);
                                            }
                                        }
                                    });
                                    boolean all_visible = true;
                                    boolean all_invisible = true;
                                    for (Tag t : tags) {
                                        if (t.isVisible()) {
                                            all_invisible = false;
                                            continue;
                                        }
                                        all_visible = false;
                                    }
                                    showAllItem.setEnabled(!all_visible);
                                    hideAllItem.setEnabled(!all_invisible);
                                    com.biglybt.pif.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sep2");
                                    sepItem.setStyle(4);
                                    for (final Tag t : tags) {
                                        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, t.getTagName(false));
                                        menuItem.setStyle(2);
                                        menuItem.addListener(new MenuItemListener(){

                                            @Override
                                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                                t.setVisible(menu.isSelected());
                                            }
                                        });
                                        menuItem.addFillListener(new MenuItemFillListener(){

                                            @Override
                                            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                                                menu.setData(t.isVisible());
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
                sepItem = menuManager.addMenuItem(menu, "sep3");
                sepItem.setStyle(4);
                menuItem = menuManager.addMenuItem(menu, "tag.show.stats");
                menuItem.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        uiFunctions.getMDI().showEntryByID(StatsView.VIEW_ID, "TagStatsView");
                    }
                });
                menuItem = menuManager.addMenuItem(menu, "tag.show.overview");
                menuItem.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        uiFunctions.getMDI().showEntryByID("TagsOverview");
                    }
                });
            }
        });
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                TagUIUtils.checkTagSharing(true);
            }
        });
    }

    public static void setMenuIcon(final com.biglybt.pif.ui.menus.MenuItem m, Tag tag) {
        String image_file = tag.getImageFile();
        if (image_file != null) {
            try {
                ImageLoader.getInstance().getFileImage(new File(image_file), new Point(16, 16), new ImageLoader.ImageDownloaderListener(){

                    @Override
                    public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                        if (image != null && returnedImmediately) {
                            m.setGraphic(new UISWTGraphicImpl(image));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setMenuIcon(final MenuItem m, Tag tag) {
        String image_file = tag.getImageFile();
        if (image_file != null) {
            try {
                ImageLoader.getInstance().getFileImage(new File(image_file), new Point(16, 16), new ImageLoader.ImageDownloaderListener(){

                    @Override
                    public void imageDownloaded(Image image, final String key, boolean returnedImmediately) {
                        if (image != null && returnedImmediately) {
                            m.setImage(image);
                            m.addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent e) {
                                    ImageLoader.getInstance().releaseImage(key);
                                }
                            });
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void checkTagSharing(boolean start_of_day) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            TagManager tm = TagManagerFactory.getTagManager();
            if (start_of_day) {
                if (COConfigurationManager.getBooleanParameter("tag.sharing.default.checked", false)) {
                    return;
                }
                COConfigurationManager.setParameter("tag.sharing.default.checked", true);
                List<TagType> tag_types = tm.getTagTypes();
                boolean prompt_required = false;
                for (TagType tag_type : tag_types) {
                    List<Tag> tags = tag_type.getTags();
                    for (Tag tag : tags) {
                        if (!tag.isPublic()) continue;
                        prompt_required = true;
                    }
                }
                if (!prompt_required) {
                    return;
                }
            }
            String title = MessageText.getString("tag.sharing.enable.title");
            String text = MessageText.getString("tag.sharing.enable.text");
            UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            prompter.setRemember("tag.share.default", true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean share = prompter.waitUntilClosed() == 0;
            tm.setTagPublicDefault(share);
        }
    }

    public static void createManualTag(UIFunctions.TagReturner tagReturner) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.showCreateTagDialog(tagReturner);
        }
    }

    public static void createSideBarMenuItemsDelayed(final Menu menu, final Tag tag, final Predicate<Taggable> filter2) {
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menu.getItems());
                TagUIUtils.createSideBarMenuItems(menu, tag, filter2);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    public static void createSideBarMenuItems(Menu menu, TagGroup tag_group) {
        if (tag_group == null || tag_group.getName() == null) {
            return;
        }
        if (TagUIUtils.addTagGroupMenu(menu, tag_group)) {
            new MenuItem(menu, 2);
        }
        boolean can_clear = false;
        for (Tag tag : tag_group.getTags()) {
            if (tag.isColorDefault()) continue;
            can_clear = true;
        }
        TagUIUtils.addColourChooser(menu, "label.color", can_clear, tag_group, (RGB selected) -> {
            for (Tag tag : tag_group.getTags()) {
                int[] nArray;
                if (selected == null) {
                    nArray = null;
                } else {
                    int[] nArray2 = new int[3];
                    nArray2[0] = selected.red;
                    nArray2[1] = selected.green;
                    nArray = nArray2;
                    nArray2[2] = selected.blue;
                }
                tag.setColor(nArray);
            }
        });
    }

    public static void addColourChooser(Menu menu, String item_resource, boolean can_clear, Tag tag, Consumer<RGB> receiver) {
        ArrayList<RGB> existing = new ArrayList<RGB>();
        int[] color = tag.getColor();
        if (color != null) {
            RGB rgb = new RGB(color[0], color[1], color[2]);
            existing.add(rgb);
        }
        MenuBuildUtils.addColourChooser(menu, item_resource, can_clear, existing, receiver);
    }

    public static void addColourChooser(Menu menu, String item_resource, boolean can_clear, TagGroup tag_group, Consumer<RGB> receiver) {
        ArrayList<RGB> existing = new ArrayList<RGB>();
        for (Tag tag : tag_group.getTags()) {
            int[] color = tag.getColor();
            if (color == null) continue;
            RGB rgb = new RGB(color[0], color[1], color[2]);
            existing.add(rgb);
        }
        MenuBuildUtils.addColourChooser(menu, item_resource, can_clear, existing, receiver);
    }

    public static void createSideBarMenuItems(Menu menu, Tag tag) {
        TagUIUtils.createSideBarMenuItems(menu, tag, t -> true);
    }

    public static void createSideBarMenuItems(Menu menu, final Tag tag, Predicate<Taggable> filter2) {
        boolean auto;
        int tt;
        TagFeatureExecOnAssign tf_eoa;
        int supported_actions;
        if (tag instanceof Category) {
            CategoryUIUtils.createMenuItems(menu, (Category)tag, filter2);
            return;
        }
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        TagType tag_type = tag.getTagType();
        boolean needs_separator_next = false;
        int countBefore = menu.getItemCount();
        if (tag_type.hasTagTypeFeature(1L)) {
            TagUIUtils.createTF_RateLimitMenuItems(menu, tag, tag_type, userMode);
        }
        if (tag_type.hasTagTypeFeature(4L)) {
            TagUIUtils.createTF_RunState(menu, tag, filter2, userMode);
        }
        if (tag_type.hasTagTypeFeature(16L)) {
            TagUIUtils.createTF_FileLocationMenuItems(menu, tag, filter2);
        }
        if (tag_type.hasTagTypeFeature(64L) && (supported_actions = (tf_eoa = (TagFeatureExecOnAssign)((Object)tag)).getSupportedActions()) != 0) {
            Menu eoa_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem eoa_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)eoa_item, "label.exec.on.assign");
            eoa_item.setMenu(eoa_menu);
            boolean is_peer_set = tag.getTagType().getTagType() == 4;
            int[] action_ids = new int[]{256, 1, 2, 8, 16, 4, 32768, 64, 128, 32, 512, 1024, 2048, 16384, 4096, 8192};
            String[] action_keys = new String[]{"label.apply.options.template", is_peer_set ? "azbuddy.ui.menu.disconnect" : "v3.MainWindow.button.delete", "v3.MainWindow.button.start", "v3.MainWindow.button.forcestart", "v3.MainWindow.button.notforcestart", "v3.MainWindow.button.stop", "ConfigView.section.queue", "v3.MainWindow.button.pause", "v3.MainWindow.button.resume", "label.script", "label.post.magnet.to.chat", "label.init.save.loc.move", "label.assign.tags", "label.remove.tags", "menu.host.on.tracker", "menu.publish.on.tracker"};
            int i = 0;
            while (i < action_ids.length) {
                final int action_id = action_ids[i];
                if (tf_eoa.supportsAction(action_id)) {
                    if (action_id == 256) {
                        MenuItem opts_item = new MenuItem(eoa_menu, 32);
                        opts_item.setText(String.valueOf(MessageText.getString(action_keys[i])) + "...");
                        opts_item.setSelection(tf_eoa.getOptionsTemplateHandler().isActive());
                        opts_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                                if (uiFunctions != null) {
                                    uiFunctions.getMDI().showEntryByID("TorrentOptionsView", tf_eoa.getOptionsTemplateHandler());
                                }
                            }
                        });
                        new MenuItem(eoa_menu, 2);
                    } else if (action_id == 32) {
                        new MenuItem(eoa_menu, 2);
                        MenuItem action_item = new MenuItem(eoa_menu, 8);
                        String script = tf_eoa.getActionScript();
                        if (script.length() > 30) {
                            script = script.substring(0, 30);
                        }
                        String msg = MessageText.getString(action_keys[i]);
                        if (script.length() > 0) {
                            msg = String.valueOf(msg) + ": " + script;
                        }
                        msg = String.valueOf(msg) + "...";
                        action_item.setText(msg);
                        action_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                String msg = MessageText.getString("UpdateScript.message");
                                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateScript.title", "!" + msg + "!");
                                entryWindow.setPreenteredText(tf_eoa.getActionScript(), false);
                                entryWindow.selectPreenteredText(true);
                                entryWindow.prompt(new UIInputReceiverListener(){

                                    @Override
                                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                        if (entryWindow.hasSubmittedInput()) {
                                            String text = entryWindow.getSubmittedInput().trim();
                                            tf_eoa.setActionScript(text);
                                        }
                                    }
                                });
                            }
                        });
                    } else if (action_id == 512) {
                        String chat_str = tf_eoa.getPostMessageChannel();
                        MenuBuildUtils.addChatSelectionMenu(eoa_menu, "label.post.magnet.to.chat", chat_str, new MenuBuildUtils.ChatSelectionListener(){

                            @Override
                            public void chatSelected(Object target, String chat) {
                                tf_eoa.setPostMessageChannel(chat);
                            }

                            @Override
                            public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                            }
                        });
                    } else if (action_id == 2048 || action_id == 16384) {
                        final boolean is_assign = action_id == 2048;
                        MenuItem action_item = new MenuItem(eoa_menu, 8);
                        final List<Tag> tags = is_assign ? tf_eoa.getTagAssigns() : tf_eoa.getTagRemoves();
                        String msg = MessageText.getString(action_keys[i]);
                        String tag_str = "";
                        for (Tag t : tags) {
                            tag_str = String.valueOf(tag_str) + (tag_str == "" ? "" : ",") + t.getTagName(true);
                        }
                        if (!tag_str.isEmpty()) {
                            msg = String.valueOf(msg) + ": " + tag_str;
                        }
                        msg = String.valueOf(msg) + "...";
                        action_item.setText(msg);
                        action_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                TagManager tagManager = TagManagerFactory.getTagManager();
                                TagType tt = tagManager.getTagType(1);
                                ArrayList<Tag> all_tags = new ArrayList<Tag>(tt.getTags());
                                tt = tagManager.getTagType(3);
                                all_tags.addAll(tt.getTags());
                                all_tags.remove(tag);
                                TagUIUtilsV3.showTagSelectionDialog(all_tags, tags, new TagUIUtilsV3.TagSelectionListener(){

                                    @Override
                                    public void selected(List<Tag> tags) {
                                        if (is_assign) {
                                            tf_eoa.setTagAssigns(tags);
                                        } else {
                                            tf_eoa.setTagRemoves(tags);
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        if (action_id == 4096) {
                            new MenuItem(eoa_menu, 2);
                        }
                        final MenuItem action_item = new MenuItem(eoa_menu, 32);
                        Messages.setLanguageText((Widget)action_item, action_keys[i]);
                        action_item.setSelection(tf_eoa.isActionEnabled(action_id));
                        action_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                tf_eoa.setActionEnabled(action_id, action_item.getSelection());
                            }
                        });
                        if (action_id == 1024) {
                            TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
                            boolean enable = false;
                            if (fl.supportsTagInitialSaveFolder()) {
                                File f = fl.getTagInitialSaveFolder();
                                enable = f != null;
                            }
                            action_item.setEnabled(enable);
                        }
                    }
                }
                ++i;
            }
        }
        if (tag instanceof TagDownload) {
            needs_separator_next = true;
            MenuItem itemOptions = new MenuItem(menu, 8);
            Set<DownloadManager> all_dms = ((TagDownload)tag).getTaggedDownloads();
            final List dms = all_dms.stream().filter(filter2).collect(Collectors.toList());
            Messages.setLanguageText((Widget)itemOptions, "cat.options");
            itemOptions.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("TorrentOptionsView", dms.toArray(new DownloadManager[dms.size()]));
                    }
                }
            });
            if (dms.size() == 0) {
                itemOptions.setEnabled(false);
            }
        }
        if (userMode > 0) {
            TagUIUtils.createTFProperitesMenuItems(menu, tag);
        }
        if (menu.getItemCount() > countBefore) {
            needs_separator_next = true;
        }
        if (needs_separator_next) {
            new MenuItem(menu, 2);
            needs_separator_next = false;
        }
        if ((tt = tag_type.getTagType()) == 3 || tt == 7) {
            needs_separator_next = true;
            MenuItem search = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)search, "tag.search");
            search.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctionsManager.getUIFunctions().doSearch("tag:" + tag.getTagName(true).replace(' ', '+'));
                }
            });
        }
        TagUIUtils.addShareWithFriendsMenuItems(menu, tag, tag_type);
        if (tag_type.hasTagTypeFeature(2L)) {
            final TagFeatureRSSFeed tfrss = (TagFeatureRSSFeed)((Object)tag);
            final MenuItem rssOption = new MenuItem(menu, 32);
            rssOption.setSelection(tfrss.isTagRSSFeedEnabled());
            Messages.setLanguageText((Widget)rssOption, "cat.rss.gen");
            rssOption.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    boolean set = rssOption.getSelection();
                    tfrss.setTagRSSFeedEnabled(set);
                }
            });
        }
        if (tag_type.hasTagTypeFeature(8L)) {
            TagUIUtils.createXCodeMenuItems(menu, tag);
        }
        if (tag_type.hasTagTypeFeature(256L)) {
            final TagFeatureNotifications tfn = (TagFeatureNotifications)((Object)tag);
            String chat_str = tfn.getNotifyMessageChannel();
            MenuBuildUtils.addChatSelectionMenu(menu, "label.notify.magnets.to.chat", chat_str, new MenuBuildUtils.ChatSelectionListener(){

                @Override
                public void chatSelected(Object target, String chat) {
                    tfn.setNotifyMessageChannel(chat);
                }

                @Override
                public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                }
            });
        }
        needs_separator_next = true;
        if (tag_type.getTagType() == 3) {
            MenuBuildUtils.addChatMenu(menu, "menu.discuss.tag", TagUIUtils.getChatKey(tag));
        }
        MenuItem itemShowStats = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemShowStats, "tag.show.stats");
        itemShowStats.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TagStatsView");
            }
        });
        if (tag.getTaggableTypes() == 2) {
            MenuItem itemShowFiles = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemShowFiles, "menu.show.files");
            itemShowFiles.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TagUIUtils.showFilesView((TagDownload)tag);
                }
            });
        }
        if (needs_separator_next) {
            new MenuItem(menu, 2);
            needs_separator_next = false;
        }
        boolean closable = auto = tag_type.isTagTypeAuto();
        if (tag.getTaggableTypes() == 2) {
            closable = true;
        }
        Menu[] menuShowHide = new Menu[1];
        if (closable) {
            TagUIUtils.createCloseableMenuItems(menu, tag, tag_type, menuShowHide, needs_separator_next);
        }
        if (!auto) {
            TagUIUtils.createNonAutoMenuItems(menu, tag, tag_type, menuShowHide);
        }
        if (tag_type.getTagType() == 3) {
            MenuItem itemDuplicate = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDuplicate, "Subscription.menu.duplicate");
            itemDuplicate.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TagUIUtils.duplicate(Collections.singletonList(tag));
                }
            });
            MenuItem itemExport = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemExport, "Subscription.menu.export");
            itemExport.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TagUIUtils.export(Collections.singletonList(tag));
                }
            });
        }
        MenuItem menuSettings = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)menuSettings, "TagSettingsView.title");
        menuSettings.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                tag.setTransientProperty("Settings Requested", true);
                uiFunctions.getMDI().showEntryByID("TagsOverview", tag);
            }
        });
        com.biglybt.pif.ui.menus.MenuItem[] items = MenuItemManager.getInstance().getAllAsArray("tag_content");
        if (items.length > 0) {
            MenuFactory.addSeparatorMenuItem(menu);
            MenuBuildUtils.addPluginMenuItems(items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Tag[]{tag}));
        }
    }

    private static void createTF_RunState(Menu menu, Tag tag, final Predicate<Taggable> filter2, int userMode) {
        MenuItem itemOp;
        final TagFeatureRunState tf_run_state = (TagFeatureRunState)((Object)tag);
        int caps = tf_run_state.getRunStateCapabilities();
        int[] op_set = new int[]{8, 128, 1, 2, 4};
        boolean[] can_ops_set = tf_run_state.getPerformableOperations(op_set, filter2);
        if ((caps & 8) != 0) {
            itemOp = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOp, "MyTorrentsView.menu.queue");
            Utils.setMenuItemImage(itemOp, "start");
            itemOp.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tf_run_state.performOperation(8, filter2);
                }
            });
            itemOp.setEnabled(can_ops_set[0]);
        }
        if (userMode > 0 && (caps & 0x80) != 0) {
            itemOp = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOp, "MyTorrentsView.menu.forceStart");
            Utils.setMenuItemImage(itemOp, "forcestart");
            itemOp.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tf_run_state.performOperation(128, filter2);
                }
            });
            itemOp.setEnabled(can_ops_set[1]);
        }
        if ((caps & 1) != 0) {
            itemOp = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOp, "MyTorrentsView.menu.stop");
            Utils.setMenuItemImage(itemOp, "stop");
            itemOp.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tf_run_state.performOperation(1, filter2);
                }
            });
            itemOp.setEnabled(can_ops_set[2]);
        }
        if ((caps & 2) != 0) {
            itemOp = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOp, "v3.MainWindow.button.pause");
            Utils.setMenuItemImage(itemOp, "pause");
            itemOp.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tf_run_state.performOperation(2, filter2);
                }
            });
            itemOp.setEnabled(can_ops_set[3]);
        }
        if ((caps & 4) != 0) {
            itemOp = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOp, "v3.MainWindow.button.resume");
            Utils.setMenuItemImage(itemOp, "start");
            itemOp.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tf_run_state.performOperation(4, filter2);
                }
            });
            itemOp.setEnabled(can_ops_set[4]);
        }
    }

    private static void createTF_RateLimitMenuItems(Menu menu, Tag tag, TagType tag_type, int userMode) {
        final TagFeatureRateLimit tf_rate_limit = (TagFeatureRateLimit)((Object)tag);
        boolean has_up = tf_rate_limit.supportsTagUploadLimit();
        boolean has_down = tf_rate_limit.supportsTagDownloadLimit();
        if (has_up || has_down) {
            long kInB = DisplayFormatters.getKinB();
            long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * kInB;
            long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * kInB;
            int down_speed = tf_rate_limit.getTagDownloadLimit();
            int up_speed = tf_rate_limit.getTagUploadLimit();
            HashMap<String, Object> menu_properties = new HashMap<String, Object>();
            if (tag_type.getTagType() == 4 || tag_type.getTagType() == 3) {
                if (has_up) {
                    menu_properties.put("enable_upload_disable", true);
                }
                if (has_down) {
                    menu_properties.put("enable_download_disable", true);
                }
            }
            ViewUtils.addSpeedMenu(menu.getShell(), menu, has_up, has_down, true, true, down_speed == -1, down_speed == 0, down_speed, down_speed, maxDownload, up_speed == -1, up_speed == 0, up_speed, up_speed, maxUpload, 1, menu_properties, new ViewUtils.SpeedAdapter(){

                @Override
                public void setDownSpeed(int val) {
                    tf_rate_limit.setTagDownloadLimit(val);
                }

                @Override
                public void setUpSpeed(int val) {
                    tf_rate_limit.setTagUploadLimit(val);
                }
            });
        }
        if (userMode > 0) {
            DecimalFormat df;
            if (tf_rate_limit.getTagUploadPriority() >= 0) {
                final MenuItem upPriority = new MenuItem(menu, 32);
                upPriority.setSelection(tf_rate_limit.getTagUploadPriority() > 0);
                Messages.setLanguageText((Widget)upPriority, "cat.upload.priority");
                upPriority.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        boolean set = upPriority.getSelection();
                        tf_rate_limit.setTagUploadPriority(set ? 1 : 0);
                    }
                });
            }
            if (tf_rate_limit.getTagMinShareRatio() >= 0) {
                MenuItem itemSR = new MenuItem(menu, 8);
                df = new DecimalFormat("0.000");
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(3);
                final String existing = df.format((float)tf_rate_limit.getTagMinShareRatio() / 1000.0f);
                Messages.setLanguageText((Widget)itemSR, "menu.min.share.ratio", existing);
                itemSR.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("min.sr.window.title", "min.sr.window.message");
                        entryWindow.setPreenteredText(existing, false);
                        entryWindow.selectPreenteredText(true);
                        entryWindow.prompt(new UIInputReceiverListener(){

                            @Override
                            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                                if (!receiver.hasSubmittedInput()) {
                                    return;
                                }
                                String text = receiver.getSubmittedInput().trim();
                                int sr = 0;
                                if (text.length() > 0) {
                                    try {
                                        float f = DisplayFormatters.parseFloat(df, text);
                                        sr = (int)(f * 1000.0f);
                                        if (sr < 0) {
                                            sr = 0;
                                        } else if (sr == 0 && f > 0.0f) {
                                            sr = 1;
                                        }
                                        tf_rate_limit.setTagMinShareRatio(sr);
                                    }
                                    catch (Throwable e) {
                                        MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                                        mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                                        mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                                        mb.open();
                                        Debug.out(e);
                                    }
                                }
                            }
                        });
                    }
                });
            }
            if (tf_rate_limit.getTagMaxShareRatio() >= 0) {
                MenuItem itemSR = new MenuItem(menu, 8);
                df = new DecimalFormat("0.000");
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(3);
                final String existing = df.format((float)tf_rate_limit.getTagMaxShareRatio() / 1000.0f);
                Messages.setLanguageText((Widget)itemSR, "menu.max.share.ratio", existing);
                itemSR.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("max.sr.window.title", "max.sr.window.message");
                        entryWindow.setPreenteredText(existing, false);
                        entryWindow.selectPreenteredText(true);
                        entryWindow.prompt(new UIInputReceiverListener(){

                            @Override
                            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                                if (!receiver.hasSubmittedInput()) {
                                    return;
                                }
                                String text = receiver.getSubmittedInput().trim();
                                int sr = 0;
                                if (text.length() > 0) {
                                    try {
                                        float f = DisplayFormatters.parseFloat(df, text);
                                        sr = (int)(f * 1000.0f);
                                        if (sr < 0) {
                                            sr = 0;
                                        } else if (sr == 0 && f > 0.0f) {
                                            sr = 1;
                                        }
                                        tf_rate_limit.setTagMaxShareRatio(sr);
                                    }
                                    catch (Throwable e) {
                                        MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                                        mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                                        mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                                        mb.open();
                                        Debug.out(e);
                                    }
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static void createTF_FileLocationMenuItems(final Menu menu, final Tag tag, final Predicate<Taggable> filter2) {
        final TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
        if (fl.supportsTagInitialSaveFolder() || fl.supportsTagMoveOnComplete() || fl.supportsTagCopyOnComplete() || fl.supportsTagMoveOnRemove() || fl.supportsTagMoveOnAssign()) {
            int userMode;
            MenuItem mor_item;
            Menu mor_menu;
            MenuItem set_item;
            MenuItem current_item;
            MenuItem moc_item;
            MenuItem set_item2;
            MenuItem current_item2;
            MenuItem apply_item;
            File existing;
            MenuItem clear_item;
            Menu moc_menu;
            Menu files_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem files_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)files_item, "ConfigView.section.files");
            files_item.setMenu(files_menu);
            if (fl.supportsTagInitialSaveFolder()) {
                moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                MenuItem isl_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)isl_item, "label.init.save.loc");
                isl_item.setMenu(moc_menu);
                clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagInitialSaveFolder(null);
                    }
                });
                existing = fl.getTagInitialSaveFolder();
                apply_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)apply_item, "apply.to.current");
                apply_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TagUIUtils.applyLocationToCurrent(tag, existing, fl.getTagInitialSaveOptions(), 1, filter2);
                    }
                });
                new MenuItem(moc_menu, 2);
                if (existing != null) {
                    current_item2 = new MenuItem(moc_menu, 16);
                    current_item2.setSelection(true);
                    current_item2.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    apply_item.setEnabled(false);
                    clear_item.setEnabled(false);
                }
                set_item2 = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item2, "label.set");
                set_item2.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagInitialSaveFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagMoveOnComplete()) {
                moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                moc_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)moc_item, "label.move.on.comp");
                moc_item.setMenu(moc_menu);
                clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagMoveOnCompleteFolder(null);
                    }
                });
                existing = fl.getTagMoveOnCompleteFolder();
                apply_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)apply_item, "apply.to.current");
                apply_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TagUIUtils.applyLocationToCurrent(tag, existing, fl.getTagMoveOnCompleteOptions(), 2, filter2);
                    }
                });
                new MenuItem(moc_menu, 2);
                if (existing != null) {
                    current_item2 = new MenuItem(moc_menu, 16);
                    current_item2.setSelection(true);
                    current_item2.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    apply_item.setEnabled(false);
                    clear_item.setEnabled(false);
                }
                set_item2 = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item2, "label.set");
                set_item2.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagMoveOnCompleteFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagCopyOnComplete()) {
                moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                moc_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)moc_item, "label.copy.on.comp");
                moc_item.setMenu(moc_menu);
                clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagCopyOnCompleteFolder(null);
                    }
                });
                new MenuItem(moc_menu, 2);
                existing = fl.getTagCopyOnCompleteFolder();
                if (existing != null) {
                    current_item = new MenuItem(moc_menu, 16);
                    current_item.setSelection(true);
                    current_item.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    clear_item.setEnabled(false);
                }
                set_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item, "label.set");
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagCopyOnCompleteFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagMoveOnRemove()) {
                mor_menu = new Menu((Decorations)files_menu.getShell(), 4);
                mor_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)mor_item, "label.move.on.rem");
                mor_item.setMenu(mor_menu);
                clear_item = new MenuItem(mor_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagMoveOnRemoveFolder(null);
                    }
                });
                new MenuItem(mor_menu, 2);
                existing = fl.getTagMoveOnRemoveFolder();
                if (existing != null) {
                    current_item = new MenuItem(mor_menu, 16);
                    current_item.setSelection(true);
                    current_item.setText(existing.getAbsolutePath());
                    new MenuItem(mor_menu, 2);
                } else {
                    clear_item.setEnabled(false);
                }
                set_item = new MenuItem(mor_menu, 64);
                Messages.setLanguageText((Widget)set_item, "label.set");
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(mor_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagMoveOnRemoveFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagMoveOnAssign()) {
                mor_menu = new Menu((Decorations)files_menu.getShell(), 4);
                mor_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)mor_item, "label.move.on.assign");
                mor_item.setMenu(mor_menu);
                clear_item = new MenuItem(mor_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagMoveOnAssignFolder(null);
                    }
                });
                existing = fl.getTagMoveOnAssignFolder();
                apply_item = new MenuItem(mor_menu, 64);
                Messages.setLanguageText((Widget)apply_item, "apply.to.current");
                apply_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TagUIUtils.applyLocationToCurrent(tag, existing, fl.getTagMoveOnAssignOptions(), 3, filter2);
                    }
                });
                new MenuItem(mor_menu, 2);
                if (existing != null) {
                    current_item2 = new MenuItem(mor_menu, 16);
                    current_item2.setSelection(true);
                    current_item2.setText(existing.getAbsolutePath());
                    new MenuItem(mor_menu, 2);
                } else {
                    clear_item.setEnabled(false);
                    apply_item.setEnabled(false);
                }
                set_item2 = new MenuItem(mor_menu, 64);
                Messages.setLanguageText((Widget)set_item2, "label.set");
                set_item2.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(mor_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagMoveOnAssignFolder(new File(path));
                        }
                    }
                });
            }
            if ((userMode = COConfigurationManager.getIntParameter("User Mode")) > 0 && tag instanceof TagDownload) {
                Set<DownloadManager> downloads = ((TagDownload)tag).getTaggedDownloads();
                DownloadManager[] dms = downloads.stream().filter(filter2).collect(Collectors.toList()).toArray(new DownloadManager[0]);
                Comparator<String> comp2 = new FormattersImpl().getAlphanumericComparator(true);
                Arrays.sort(dms, (d1, d2) -> comp2.compare(d1.getDisplayName(), d2.getDisplayName()));
                MenuItem itemFileMoveDataBatch = new MenuItem(files_menu, 8);
                Messages.setLanguageText((Widget)itemFileMoveDataBatch, "MyTorrentsView.menu.movedata.batch");
                itemFileMoveDataBatch.addListener(13, (Listener)new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager[] dms) {
                        TorrentUtil.moveDataFiles(menu.getShell(), dms, true);
                    }
                });
                itemFileMoveDataBatch.setEnabled(dms.length > 0);
            }
        }
    }

    private static void createTFProperitesMenuItems(Menu menu, Tag tag) {
        TagFeatureProperties.TagProperty[] tps;
        final Menu props_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem props_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)props_item, "label.properties");
        props_item.setMenu(props_menu);
        TagUIUtils.addColourChooser(props_menu, "label.color", !tag.isColorDefault(), tag, (RGB selected) -> {
            int[] nArray;
            if (selected == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[3];
                nArray2[0] = selected.red;
                nArray2[1] = selected.green;
                nArray = nArray2;
                nArray2[2] = selected.blue;
            }
            tag.setColor(nArray);
        });
        if (!tag.getTagType().hasTagTypeFeature(32L)) {
            return;
        }
        TagFeatureProperties props = (TagFeatureProperties)((Object)tag);
        TagFeatureProperties.TagProperty[] tagPropertyArray = tps = props.getSupportedProperties();
        int n = tps.length;
        int n2 = 0;
        while (n2 < n) {
            Object val;
            final TagFeatureProperties.TagProperty tp2 = tagPropertyArray[n2];
            if (tp2.getType() == 1) {
                String tp_name = tp2.getName(false);
                if (tp_name.equals("constraint")) {
                    MenuItem const_item = new MenuItem(props_menu, 8);
                    Messages.setLanguageText((Widget)const_item, "label.contraints");
                    const_item.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            final String[] old_value = tp2.getStringList();
                            String def_val = old_value != null && old_value.length > 0 ? old_value[0] : "";
                            String msg = MessageText.getString("UpdateConstraint.message");
                            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateConstraint.title", "!" + msg + "!");
                            entryWindow.setPreenteredText(def_val, false);
                            entryWindow.selectPreenteredText(true);
                            entryWindow.prompt(new UIInputReceiverListener(){

                                @Override
                                public void UIInputReceiverClosed(UIInputReceiver receiver) {
                                    if (!receiver.hasSubmittedInput()) {
                                        return;
                                    }
                                    try {
                                        String text = receiver.getSubmittedInput().trim();
                                        if (text.length() == 0) {
                                            tp2.setStringList(null);
                                        } else {
                                            String old_options = old_value.length > 1 ? old_value[1] : "";
                                            tp2.setStringList(new String[]{text, old_options});
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            });
                        }
                    });
                } else if (tp_name.equals("tracker_templates")) {
                    String def_str;
                    final TrackersUtil tut = TrackersUtil.getInstance();
                    ArrayList<String> templates = new ArrayList<String>(tut.getMultiTrackers().keySet());
                    String str_merge = MessageText.getString("label.merge");
                    String str_replace = MessageText.getString("label.replace");
                    String str_remove = MessageText.getString("Button.remove");
                    String[] val2 = tp2.getStringList();
                    final ArrayList<String> selected2 = new ArrayList<String>();
                    if (val2 == null || val2.length == 0) {
                        def_str = "";
                    } else {
                        def_str = "";
                        String[] stringArray = val2;
                        int n3 = val2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String tn;
                            String v = stringArray[n4];
                            String[] bits = v.split(":");
                            if (bits.length == 2 && templates.contains(tn = bits[1])) {
                                String type = bits[0];
                                tn = type.equals("m") ? String.valueOf(tn) + ": " + str_merge : (type.equals("r") ? String.valueOf(tn) + ": " + str_replace : String.valueOf(tn) + ": " + str_remove);
                                selected2.add(v);
                                def_str = String.valueOf(def_str) + (def_str.length() == 0 ? "" : ", ") + tn;
                            }
                            ++n4;
                        }
                    }
                    Collections.sort(templates);
                    Menu ttemp_menu = new Menu((Decorations)menu.getShell(), 4);
                    MenuItem ttemp_item = new MenuItem(menu, 64);
                    ttemp_item.setText(String.valueOf(MessageText.getString("label.tracker.templates")) + (def_str.length() == 0 ? "" : " (" + def_str + ")  "));
                    ttemp_item.setMenu(ttemp_menu);
                    MenuItem new_item = new MenuItem(ttemp_menu, 8);
                    Messages.setLanguageText((Widget)new_item, "wizard.multitracker.new");
                    new_item.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            ArrayList<List<String>> group = new ArrayList<List<String>>();
                            ArrayList tracker = new ArrayList();
                            group.add(tracker);
                            new MultiTrackerEditor(props_menu.getShell(), null, group, new TrackerEditorListener(){

                                @Override
                                public void trackersChanged(String oldName, String newName, List<List<String>> trackers) {
                                    if (trackers != null) {
                                        tut.addMultiTracker(newName, trackers);
                                    }
                                }
                            });
                        }
                    });
                    MenuItem reapply_item = new MenuItem(ttemp_menu, 8);
                    Messages.setLanguageText((Widget)reapply_item, "label.reapply");
                    reapply_item.addListener(13, event2 -> tp2.syncListeners());
                    reapply_item.setEnabled(def_str.length() > 0);
                    if (templates.size() > 0) {
                        new MenuItem(ttemp_menu, 2);
                        for (final String template_name : templates) {
                            Menu t_menu = new Menu((Decorations)ttemp_menu.getShell(), 4);
                            MenuItem t_item = new MenuItem(ttemp_menu, 64);
                            t_item.setText(template_name);
                            t_item.setMenu(t_menu);
                            boolean r_selected = false;
                            int i = 0;
                            while (i < 3) {
                                final MenuItem sel_item = new MenuItem(t_menu, 32);
                                final String key = String.valueOf(i == 0 ? "m" : (i == 1 ? "r" : "x")) + ":" + template_name;
                                sel_item.setText(i == 0 ? str_merge : (i == 1 ? str_replace : str_remove));
                                boolean is_sel = selected2.contains(key);
                                r_selected |= is_sel;
                                sel_item.setSelection(is_sel);
                                sel_item.addListener(13, new Listener(){

                                    public void handleEvent(Event event2) {
                                        if (sel_item.getSelection()) {
                                            selected2.add(key);
                                        } else {
                                            selected2.remove(key);
                                        }
                                        Utils.getOffOfSWTThread(new AERunnable(){

                                            @Override
                                            public void runSupport() {
                                                tp2.setStringList(selected2.toArray(new String[selected2.size()]));
                                            }
                                        });
                                    }
                                });
                                ++i;
                            }
                            if (r_selected) {
                                Utils.setMenuItemImage(t_item, "graytick");
                            }
                            new MenuItem(t_menu, 2);
                            MenuItem edit_item = new MenuItem(t_menu, 8);
                            Messages.setLanguageText((Widget)edit_item, "wizard.multitracker.edit");
                            edit_item.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    new MultiTrackerEditor(props_menu.getShell(), template_name, tut.getMultiTrackers().get(template_name), new TrackerEditorListener(){

                                        @Override
                                        public void trackersChanged(String oldName, String newName, List<List<String>> trackers) {
                                            if (oldName != null && !oldName.equals(newName)) {
                                                tut.removeMultiTracker(oldName);
                                            }
                                            tut.addMultiTracker(newName, trackers);
                                        }
                                    });
                                }
                            });
                            MenuItem del_item = new MenuItem(t_menu, 8);
                            Messages.setLanguageText((Widget)del_item, "FileItem.delete");
                            Utils.setMenuItemImage(del_item, "delete");
                            del_item.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{template_name}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                                    mb.open(new UserPrompterResultListener(){

                                        @Override
                                        public void prompterClosed(int result) {
                                            if (result == 0) {
                                                tut.removeMultiTracker(template_name);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    }
                } else {
                    String def_str;
                    val = tp2.getStringList();
                    String msg_str = null;
                    if (val == null || ((String[])val).length == 0) {
                        def_str = "";
                    } else {
                        def_str = "";
                        Object object = val;
                        int n5 = ((Object)object).length;
                        int str_remove = 0;
                        while (str_remove < n5) {
                            Object v = object[str_remove];
                            if (def_str.length() > 100 && msg_str == null) {
                                msg_str = String.valueOf(def_str) + "...";
                            }
                            def_str = String.valueOf(def_str) + (def_str.length() == 0 ? "" : ", ") + (String)v;
                            ++str_remove;
                        }
                    }
                    if (msg_str == null) {
                        msg_str = def_str;
                    }
                    MenuItem set_item = new MenuItem(props_menu, 8);
                    set_item.setText(String.valueOf(tp2.getName(true)) + (msg_str.length() == 0 ? "" : " (" + msg_str + ") ") + "...");
                    final String f_def_str = def_str;
                    set_item.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            String msg = MessageText.getString("UpdateProperty.list.message", new String[]{tp2.getName(true)});
                            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateProperty.title", "!" + msg + "!");
                            entryWindow.setPreenteredText(f_def_str, false);
                            entryWindow.selectPreenteredText(true);
                            entryWindow.prompt(new UIInputReceiverListener(){

                                @Override
                                public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                    if (!entryWindow.hasSubmittedInput()) {
                                        return;
                                    }
                                    try {
                                        String text = entryWindow.getSubmittedInput().trim();
                                        if (text.length() == 0) {
                                            tp2.setStringList(null);
                                        } else {
                                            text = text.replace(';', ',');
                                            text = text.replace(' ', ',');
                                            text = text.replaceAll("[,]+", ",");
                                            String[] bits = text.split(",");
                                            ArrayList<String> vals = new ArrayList<String>();
                                            String[] stringArray = bits;
                                            int n = bits.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String bit = stringArray[n2];
                                                if ((bit = bit.trim()).length() > 0) {
                                                    vals.add(bit);
                                                }
                                                ++n2;
                                            }
                                            if (vals.size() == 0) {
                                                tp2.setStringList(null);
                                            } else {
                                                tp2.setStringList(vals.toArray(new String[vals.size()]));
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            });
                        }
                    });
                }
            } else if (tp2.getType() == 2) {
                final MenuItem set_item = new MenuItem(props_menu, 32);
                set_item.setText(tp2.getName(true));
                val = tp2.getBoolean();
                set_item.setSelection(val != null && ((Boolean)val).booleanValue());
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        tp2.setBoolean(set_item.getSelection());
                    }
                });
            } else {
                Debug.out("Unknown property");
            }
            ++n2;
        }
    }

    private static void addShareWithFriendsMenuItems(Menu menu, Tag tag, TagType tag_type) {
        PluginInterface bpi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(BuddyPlugin.class);
        if (tag_type.getTagType() == 3 && bpi != null) {
            BuddyPlugin buddy_plugin;
            Boolean is_ut;
            TagFeatureProperties props = (TagFeatureProperties)((Object)tag);
            TagFeatureProperties.TagProperty tp2 = props.getProperty("untagged");
            Boolean bl = is_ut = tp2 == null ? null : tp2.getBoolean();
            if ((is_ut == null || !is_ut.booleanValue()) && (buddy_plugin = (BuddyPlugin)bpi.getPlugin()).isClassicEnabled()) {
                Menu share_menu = new Menu((Decorations)menu.getShell(), 4);
                MenuItem share_item = new MenuItem(menu, 64);
                Messages.setLanguageText((Widget)share_item, "azbuddy.ui.menu.cat.share");
                share_item.setText(String.valueOf(share_item.getText()) + "  ");
                share_item.setMenu(share_menu);
                List<BuddyPluginBuddy> buddies = buddy_plugin.getBuddies();
                if (buddies.size() == 0) {
                    MenuItem item = new MenuItem(share_menu, 32);
                    item.setText(MessageText.getString("general.add.friends"));
                    item.setEnabled(false);
                } else {
                    final String tag_name = tag.getTagName(true);
                    final boolean is_public = buddy_plugin.isPublicTagOrCategory(tag_name);
                    MenuItem itemPubCat = new MenuItem(share_menu, 32);
                    Messages.setLanguageText((Widget)itemPubCat, "general.all.friends");
                    itemPubCat.setSelection(is_public);
                    itemPubCat.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            if (is_public) {
                                buddy_plugin.removePublicTagOrCategory(tag_name);
                            } else {
                                buddy_plugin.addPublicTagOrCategory(tag_name);
                            }
                        }
                    });
                    new MenuItem(share_menu, 2);
                    for (final BuddyPluginBuddy buddy : buddies) {
                        if (buddy.getNickName() == null) continue;
                        final boolean auth = buddy.isLocalRSSTagOrCategoryAuthorised(tag_name);
                        MenuItem itemShare = new MenuItem(share_menu, 32);
                        itemShare.setText(String.valueOf(buddy.getName()) + (buddy.isPublicNetwork() ? "" : " (" + MessageText.getString("label.anon.medium") + ")"));
                        itemShare.setSelection(auth || is_public);
                        if (is_public) {
                            itemShare.setEnabled(false);
                        }
                        itemShare.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                if (auth) {
                                    buddy.removeLocalAuthorisedRSSTagOrCategory(tag_name);
                                } else {
                                    buddy.addLocalAuthorisedRSSTagOrCategory(tag_name);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private static void createXCodeMenuItems(Menu menu, Tag tag) {
        TrancodeUIUtils.TranscodeTarget[] tts;
        final TagFeatureTranscode tf_xcode = (TagFeatureTranscode)((Object)tag);
        if (tf_xcode.supportsTagTranscode() && (tts = TrancodeUIUtils.getTranscodeTargets()).length > 0) {
            final Menu t_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem t_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)t_item, "cat.autoxcode");
            t_item.setMenu(t_menu);
            t_menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    MenuItem[] menuItemArray = t_menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi = menuItemArray[n2];
                        mi.dispose();
                        ++n2;
                    }
                    String[] existing = tf_xcode.getTagTranscodeTarget();
                    TrancodeUIUtils.TranscodeTarget[] transcodeTargetArray = tts;
                    int n3 = tts.length;
                    n = 0;
                    while (n < n3) {
                        final TrancodeUIUtils.TranscodeTarget tt = transcodeTargetArray[n];
                        TrancodeUIUtils.TranscodeProfile[] profiles = tt.getProfiles();
                        if (profiles.length > 0) {
                            boolean selected;
                            Menu tt_menu = new Menu((Decorations)t_menu.getShell(), 4);
                            MenuItem tt_item = new MenuItem(t_menu, 64);
                            tt_item.setText(tt.getName());
                            tt_item.setMenu(tt_menu);
                            TrancodeUIUtils.TranscodeProfile[] transcodeProfileArray = profiles;
                            int n4 = profiles.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                boolean selected2;
                                final TrancodeUIUtils.TranscodeProfile tp2 = transcodeProfileArray[n5];
                                final MenuItem p_item = new MenuItem(tt_menu, 32);
                                p_item.setText(tp2.getName());
                                boolean bl = selected2 = existing != null && existing[0].equals(tp2.getUID());
                                if (selected2) {
                                    Utils.setMenuItemImage(tt_item, "graytick");
                                }
                                p_item.setSelection(selected2);
                                p_item.addListener(13, new Listener(){

                                    public void handleEvent(Event event2) {
                                        String name = String.valueOf(tt.getName()) + " - " + tp2.getName();
                                        if (p_item.getSelection()) {
                                            tf_xcode.setTagTranscodeTarget(tp2.getUID(), name);
                                        } else {
                                            tf_xcode.setTagTranscodeTarget(null, null);
                                        }
                                    }
                                });
                                ++n5;
                            }
                            new MenuItem(tt_menu, 2);
                            final MenuItem no_xcode_item = new MenuItem(tt_menu, 32);
                            final String never_str = MessageText.getString("v3.menu.device.defaultprofile.never");
                            no_xcode_item.setText(never_str);
                            final String never_uid = String.valueOf(tt.getID()) + "/blank";
                            boolean bl = selected = existing != null && existing[0].equals(never_uid);
                            if (selected) {
                                Utils.setMenuItemImage(tt_item, "graytick");
                            }
                            no_xcode_item.setSelection(selected);
                            no_xcode_item.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    String name = String.valueOf(tt.getName()) + " - " + never_str;
                                    if (no_xcode_item.getSelection()) {
                                        tf_xcode.setTagTranscodeTarget(never_uid, name);
                                    } else {
                                        tf_xcode.setTagTranscodeTarget(null, null);
                                    }
                                }
                            });
                        }
                        ++n;
                    }
                }

                public void menuHidden(MenuEvent e) {
                    final MenuItem[] items = t_menu.getItems();
                    Utils.execSWTThreadLater(1, new Runnable(){

                        @Override
                        public void run() {
                            MenuItem[] menuItemArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem mi = menuItemArray[n2];
                                mi.dispose();
                                ++n2;
                            }
                        }
                    });
                }
            });
        }
    }

    private static void createCloseableMenuItems(Menu menu, Tag tag, TagType tag_type, Menu[] menuShowHide, boolean needs_separator_next) {
        List<Tag> tags = tag_type.getTags();
        int visible_count = 0;
        int invisible_count = 0;
        for (Tag t : tags) {
            if (t.isVisible()) {
                ++visible_count;
                continue;
            }
            ++invisible_count;
        }
        menuShowHide[0] = new Menu((Decorations)menu.getShell(), 4);
        MenuItem showhideitem = new MenuItem(menu, 64);
        showhideitem.setText(MessageText.getString("label.showhide.tag"));
        showhideitem.setMenu(menuShowHide[0]);
        MenuItem title = new MenuItem(menuShowHide[0], 8);
        title.setText("[" + tag_type.getTagTypeName(true) + "]");
        title.setEnabled(false);
        new MenuItem(menuShowHide[0], 2);
        if (invisible_count > 0) {
            MenuItem showAll = new MenuItem(menuShowHide[0], 8);
            Messages.setLanguageText((Widget)showAll, "label.show.all");
            showAll.addListener(13, event2 -> {
                for (Tag t : tags) {
                    if (t.isVisible()) continue;
                    t.setVisible(true);
                }
            });
            needs_separator_next = true;
        }
        if (visible_count > 0) {
            MenuItem hideAll = new MenuItem(menuShowHide[0], 8);
            Messages.setLanguageText((Widget)hideAll, "popup.error.hideall");
            hideAll.addListener(13, event2 -> {
                for (Tag t : tags) {
                    if (!t.isVisible()) continue;
                    t.setVisible(false);
                }
            });
            needs_separator_next = true;
        }
        if (tags.size() > 0) {
            if (needs_separator_next) {
                new MenuItem(menuShowHide[0], 2);
                needs_separator_next = false;
            }
            ArrayList<String> menu_names = new ArrayList<String>();
            IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
            for (Tag t : tags) {
                String name = t.getTagName(true);
                menu_names.add(name);
                menu_name_map.put(name, t);
            }
            List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
            for (Object obj : menu_structure) {
                Menu parent_menu;
                ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
                if (obj instanceof String) {
                    parent_menu = menuShowHide[0];
                    bucket_tags.add((Tag)menu_name_map.get((String)obj));
                } else {
                    Object[] entry = (Object[])obj;
                    List tag_names = (List)entry[1];
                    boolean sub_all_visible = true;
                    boolean sub_some_visible = false;
                    for (String name : tag_names) {
                        Tag sub_tag = (Tag)menu_name_map.get(name);
                        if (sub_tag.isVisible()) {
                            sub_some_visible = true;
                        } else {
                            sub_all_visible = false;
                        }
                        bucket_tags.add(sub_tag);
                    }
                    String mod = sub_all_visible ? " (*)" : (sub_some_visible ? " (+)" : "");
                    Menu menu_bucket = new Menu((Decorations)menuShowHide[0].getShell(), 4);
                    MenuItem bucket_item = new MenuItem(menuShowHide[0], 64);
                    bucket_item.setText(String.valueOf((String)entry[0]) + mod);
                    bucket_item.setMenu(menu_bucket);
                    parent_menu = menu_bucket;
                }
                for (final Tag t : bucket_tags) {
                    MenuItem showTag = new MenuItem(parent_menu, 32);
                    showTag.setSelection(t.isVisible());
                    Messages.setLanguageText((Widget)showTag, t.getTagName(false));
                    TagUIUtils.setMenuIcon(showTag, t);
                    showTag.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            t.setVisible(!t.isVisible());
                        }
                    });
                }
            }
        }
        showhideitem.setEnabled(true);
    }

    private static void createNonAutoMenuItems(Menu menu, Tag tag, final TagType tag_type, Menu[] menuShowHide) {
        if (tag_type.hasTagTypeFeature(32L)) {
            boolean has_ut;
            TagFeatureProperties props = (TagFeatureProperties)((Object)tag);
            boolean bl = has_ut = props.getProperty("untagged") != null;
            if (has_ut) {
                has_ut = false;
                for (Tag t : tag_type.getTags()) {
                    Boolean b;
                    props = (TagFeatureProperties)((Object)t);
                    TagFeatureProperties.TagProperty prop = props.getProperty("untagged");
                    if (prop == null || (b = prop.getBoolean()) == null || !b.booleanValue()) continue;
                    has_ut = true;
                    break;
                }
                if (!has_ut) {
                    if (menuShowHide[0] == null) {
                        menuShowHide[0] = new Menu((Decorations)menu.getShell(), 4);
                        MenuItem showhideitem = new MenuItem(menu, 64);
                        showhideitem.setText(MessageText.getString("label.showhide.tag"));
                        showhideitem.setMenu(menuShowHide[0]);
                    } else {
                        new MenuItem(menuShowHide[0], 2);
                    }
                    MenuItem showAll = new MenuItem(menuShowHide[0], 8);
                    Messages.setLanguageText((Widget)showAll, "label.untagged");
                    showAll.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            try {
                                String tag_name = MessageText.getString("label.untagged");
                                Tag ut_tag = tag_type.getTag(tag_name, true);
                                if (ut_tag == null) {
                                    ut_tag = tag_type.createTag(tag_name, true);
                                }
                                TagFeatureProperties tp2 = (TagFeatureProperties)((Object)ut_tag);
                                tp2.getProperty("untagged").setBoolean(true);
                            }
                            catch (TagException e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            }
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(tag);
        TagUIUtils.createTagGroupMenu(menu, tag_type, tags);
        MenuItem itemDelete = new MenuItem(menu, 8);
        Utils.setMenuItemImage(itemDelete, "delete");
        Messages.setLanguageText((Widget)itemDelete, "FileItem.delete");
        itemDelete.addListener(13, event2 -> {
            boolean bl = TagUIUtils.removeTags(tag);
        });
    }

    private static void createTagGroupMenu(Menu menu, TagType tag_type, final List<Tag> tagz) {
        if (tag_type.getTagType() != 3 || tagz.isEmpty()) {
            return;
        }
        List<TagGroup> groups = new ArrayList<TagGroup>();
        List<Tag> all_tags = tag_type.getTags();
        for (Tag t : all_tags) {
            TagGroup group = t.getGroupContainer();
            if (group == null || group.getName() == null || groups.contains(group)) continue;
            groups.add(group);
        }
        groups = TagUtils.sortTagGroups(groups);
        Menu groups_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem groups_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)groups_item, "TableColumn.header.tag.group");
        groups_item.setMenu(groups_menu);
        String existing_group = tagz.get(0).getGroup();
        if (existing_group == null) {
            existing_group = "";
        }
        for (Tag t : tagz) {
            Object g = t.getGroup();
            if (g == null) {
                g = "";
            }
            if (((String)g).equals(existing_group)) continue;
            existing_group = null;
            break;
        }
        MenuItem item_none = new MenuItem(groups_menu, 16);
        Messages.setLanguageText((Widget)item_none, "label.none");
        item_none.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (Tag t : tagz) {
                    t.setGroup(null);
                }
            }
        });
        item_none.setSelection(existing_group != null && existing_group.isEmpty());
        new MenuItem(groups_menu, 2);
        if (!groups.isEmpty()) {
            for (final TagGroup g : groups) {
                MenuItem item_group = new MenuItem(groups_menu, 16);
                item_group.setText(g.getName());
                item_group.setSelection(g.getName().equals(existing_group));
                item_group.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        for (Tag t : tagz) {
                            t.setGroup(g.getName());
                        }
                    }
                });
            }
            new MenuItem(groups_menu, 2);
        }
        MenuItem item_add = new MenuItem(groups_menu, 8);
        final String f_existing_group = existing_group;
        Messages.setLanguageText((Widget)item_add, "menu.add.group");
        item_add.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("TagGroupWindow.title", "TagGroupWindow.message");
                if (f_existing_group != null) {
                    entryWindow.setPreenteredText(f_existing_group, false);
                }
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        try {
                            String group = entryWindow.getSubmittedInput().trim();
                            if (group.length() == 0) {
                                group = null;
                            }
                            for (Tag t : tagz) {
                                t.setGroup(group);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
        new MenuItem(groups_menu, 2);
        Menu settings_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem settings_item = new MenuItem(groups_menu, 64);
        Messages.setLanguageText((Widget)settings_item, "TagSettingsView.title");
        settings_item.setMenu(settings_menu);
        if (groups.isEmpty()) {
            settings_menu.setEnabled(false);
        } else {
            for (TagGroup g : groups) {
                Menu tg_settings_menu = new Menu((Decorations)menu.getShell(), 4);
                MenuItem tg_settings_item = new MenuItem(settings_menu, 64);
                tg_settings_item.setText(g.getName());
                tg_settings_item.setMenu(tg_settings_menu);
                TagUIUtils.addTagGroupMenu(tg_settings_menu, g);
            }
        }
    }

    private static boolean addTagGroupMenu(Menu menu, final TagGroup group) {
        int tt = group.getTagType().getTagType();
        boolean need_sep = false;
        if (tt == 3) {
            MenuItem exclusive_item = new MenuItem(menu, 32);
            exclusive_item.setText(MessageText.getString("label.exclusive"));
            exclusive_item.setSelection(group.isExclusive());
            exclusive_item.addListener(13, e -> group.setExclusive(exclusive_item.getSelection()));
            File existing = group.getRootMoveOnAssignLocation();
            final Menu moa_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem isl_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)isl_item, "label.tag.group.moa.root");
            isl_item.setMenu(moa_menu);
            MenuItem clear_item = new MenuItem(moa_menu, 64);
            Messages.setLanguageText((Widget)clear_item, "Button.clear");
            clear_item.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    group.setRootMoveOnAssignLocation(null);
                }
            });
            if (existing != null) {
                MenuItem current_item = new MenuItem(moa_menu, 16);
                current_item.setSelection(true);
                current_item.setText(existing.getAbsolutePath());
                new MenuItem(moa_menu, 2);
            } else {
                clear_item.setEnabled(false);
            }
            MenuItem set_item = new MenuItem(moa_menu, 64);
            Messages.setLanguageText((Widget)set_item, "label.set");
            set_item.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DirectoryDialog dd = new DirectoryDialog(moa_menu.getShell());
                    dd.setFilterPath(TorrentOpener.getFilterPathData());
                    dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                    String path = dd.open();
                    if (path != null) {
                        TorrentOpener.setFilterPathData(path);
                        group.setRootMoveOnAssignLocation(new File(path));
                    }
                }
            });
            MenuItem rename_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)rename_item, "MyTorrentsView.menu.rename");
            rename_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = group.getName();
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.setPreenteredText(name, false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{name}));
                    entry.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                Utils.getOffOfSWTThread(() -> group.setName(input));
                            }
                        }
                    });
                }
            });
            need_sep = true;
        }
        if (tt == 3 || tt == 4) {
            TagUIUtils.addColourChooser(menu, "TagGroup.menu.defaultcolor", group.getColor() != null, group, (RGB selected) -> {
                int[] nArray;
                if (selected == null) {
                    nArray = null;
                } else {
                    int[] nArray2 = new int[3];
                    nArray2[0] = selected.red;
                    nArray2[1] = selected.green;
                    nArray = nArray2;
                    nArray2[2] = selected.blue;
                }
                group.setColor(nArray);
            });
            need_sep = true;
        }
        return need_sep;
    }

    public static void createSideBarMenuItems(Menu menu, List<Tag> _tags) {
        final ArrayList<Tag> tags = new ArrayList<Tag>(_tags);
        Iterator it = tags.iterator();
        boolean can_show = false;
        boolean can_hide = false;
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            if (tag.getTagType().getTagType() != 3) {
                it.remove();
                continue;
            }
            if (tag.isVisible()) {
                can_hide = true;
                continue;
            }
            can_show = true;
        }
        if (tags.size() == 0) {
            return;
        }
        TagType tag_type = ((Tag)tags.get(0)).getTagType();
        MenuItem itemShow = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemShow, "Button.bar.show");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (Tag tag : tags) {
                    tag.setVisible(true);
                }
            }
        });
        itemShow.setEnabled(can_show);
        MenuItem itemHide = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemHide, "Button.bar.hide");
        itemHide.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (Tag tag : tags) {
                    tag.setVisible(false);
                }
            }
        });
        itemHide.setEnabled(can_hide);
        TagUIUtils.createTagGroupMenu(menu, tag_type, tags);
        MenuItem itemDuplicate = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemDuplicate, "Subscription.menu.duplicate");
        itemDuplicate.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtils.duplicate(tags);
            }
        });
        MenuItem itemExport = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExport, "Subscription.menu.export");
        itemExport.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtils.export(tags);
            }
        });
        com.biglybt.pif.ui.menus.MenuItem[] items = MenuItemManager.getInstance().getAllAsArray("tag_content");
        if (items.length > 0) {
            MenuFactory.addSeparatorMenuItem(menu);
            MenuBuildUtils.addPluginMenuItems(items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(tags.toArray(new Tag[0])));
        }
    }

    private static void applyLocationToCurrent(final Tag tag, final File location, final long options, final int type, final Predicate<Taggable> filter2) {
        move_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                boolean set_data = (options & 1L) != 0L;
                boolean set_torrent = (options & 2L) != 0L;
                Set<DownloadManager> all_downloads = ((TagDownload)tag).getTaggedDownloads();
                List downloads = all_downloads.stream().filter(filter2).collect(Collectors.toList());
                for (DownloadManager download : downloads) {
                    File old_torrent_file;
                    boolean dl_is_complete = download.isDownloadComplete(false);
                    if (type == 1 && dl_is_complete && download.getDownloadState().getFlag(8L) || type == 2 && !dl_is_complete) continue;
                    if (set_data) {
                        try {
                            File existing_save_loc = download.getSaveLocation();
                            if (existing_save_loc.isFile()) {
                                existing_save_loc = existing_save_loc.getParentFile();
                            }
                            if (!existing_save_loc.equals(location)) {
                                download.moveDataFilesLive(location);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    if (!set_torrent || !(old_torrent_file = new File(download.getTorrentFileName())).exists()) continue;
                    try {
                        download.setTorrentFile(location, old_torrent_file.getName());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    public static void addLibraryViewTagsSubMenu(final DownloadManager[] dms, Menu menu_tags) {
        List<Tag> all_manual_t;
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu_tags.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        TagManager tm = TagManagerFactory.getTagManager();
        MenuItem item_create = new MenuItem(menu_tags, 8);
        Messages.setLanguageText((Widget)item_create, "label.add.tag");
        item_create.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (tags != null) {
                            Tag[] tagArray = tags;
                            int n = tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Tag new_tag = tagArray[n2];
                                DownloadManager[] downloadManagerArray = dms;
                                int n3 = dms.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    DownloadManager dm = downloadManagerArray[n4];
                                    new_tag.addTaggable(dm);
                                    ++n4;
                                }
                                COConfigurationManager.setParameter("Library.TagInSideBar", true);
                                ++n2;
                            }
                        }
                    }
                });
            }
        });
        MenuItem item_pop = new MenuItem(menu_tags, 8);
        Messages.setLanguageText((Widget)item_pop, "menu.tagging.view");
        item_pop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                String title;
                String data = "{\"mdi\":\"tabbed\",\"event_listener\":{\"name\":\"com.biglybt.ui.swt.views.TaggingView\"},\"id\":\"TaggingView\",\"control_type\":0,\"skin_id\":\"com.biglybt.ui.skin.skin3\"}";
                Map map = BDecoder.decodeStrings(BDecoder.decodeFromJSON(data));
                Map<String, Object> dms_exports = DataSourceResolver.exportDataSource(dms);
                map.put("data_source", dms_exports);
                if (dms.length == 1) {
                    title = String.valueOf(MessageText.getString("authenticator.torrent")) + " : " + dms[0].getDisplayName().replaceAll("&", "&&");
                } else {
                    String str = "";
                    int i = 0;
                    while (i < Math.min(3, dms.length)) {
                        str = String.valueOf(str) + (i == 0 ? "" : ", ") + dms[i].getDisplayName().replaceAll("&", "&&");
                        ++i;
                    }
                    if (dms.length > 3) {
                        str = String.valueOf(str) + "...";
                    }
                    title = String.valueOf(dms.length) + " " + MessageText.getString("ConfigView.section.torrents") + " : " + str;
                }
                PopOutManager.popOutStandAlone(String.valueOf(MessageText.getString("label.tags")) + " - " + title, map, "TagUIUtils:TaggingView");
            }
        });
        new MenuItem(menu_tags, 2);
        HashMap<TagType, ArrayList<Tag>> auto_map = new HashMap<TagType, ArrayList<Tag>>();
        TagType manual_tt = tm.getTagType(3);
        HashMap<Tag, Integer> manual_map = new HashMap<Tag, Integer>();
        DownloadManager[] downloadManagerArray = dms;
        int n3 = dms.length;
        int n4 = 0;
        while (n4 < n3) {
            DownloadManager dm = downloadManagerArray[n4];
            Iterator<TagType> tags = tm.getTagsForTaggable(dm);
            Iterator<Tag> iterator = tags.iterator();
            while (iterator.hasNext()) {
                Tag t = iterator.next();
                TagType tt = t.getTagType();
                if (tt.isTagTypeAuto() || t.isTagAuto()[0] && t.isTagAuto()[1]) {
                    ArrayList<Tag> x = (ArrayList<Tag>)auto_map.get(tt);
                    if (x == null) {
                        x = new ArrayList<Tag>();
                        auto_map.put(tt, x);
                    }
                    x.add(t);
                    continue;
                }
                if (tt != manual_tt) continue;
                Integer i = (Integer)manual_map.get(t);
                manual_map.put(t, i == null ? 1 : i + 1);
            }
            ++n4;
        }
        if (auto_map.size() > 0) {
            Menu menuAuto = new Menu((Decorations)menu_tags.getShell(), 4);
            MenuItem autoItem = new MenuItem(menu_tags, 64);
            Messages.setLanguageText((Widget)autoItem, "wizard.maketorrent.auto");
            autoItem.setMenu(menuAuto);
            List<TagType> auto_tags = TagUtils.sortTagTypes(auto_map.keySet());
            for (TagType tt : auto_tags) {
                MenuItem tt_i = new MenuItem(menuAuto, Constants.isOSX ? 32 : 8);
                String tt_str = String.valueOf(tt.getTagTypeName(true)) + ": ";
                List<Tag> tags = (List<Tag>)auto_map.get(tt);
                HashMap<Tag, Integer> tag_counts = new HashMap<Tag, Integer>();
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    Tag t;
                    Integer i = (Integer)tag_counts.get(t = (Tag)iterator.next());
                    tag_counts.put(t, i == null ? 1 : i + 1);
                }
                tags = TagUtils.sortTags(tag_counts.keySet());
                int num = 0;
                for (Tag t : tags) {
                    tt_str = String.valueOf(tt_str) + (num == 0 ? "" : ", ") + t.getTagName(true);
                    ++num;
                    if (dms.length <= 1) continue;
                    tt_str = String.valueOf(tt_str) + " (" + tag_counts.get(t) + ")";
                }
                tt_i.setText(tt_str);
                if (Constants.isOSX) {
                    tt_i.setSelection(true);
                    continue;
                }
                Utils.setMenuItemImage(tt_i, "graytick");
            }
        }
        if ((all_manual_t = manual_tt.getTags()).size() > 0) {
            if (auto_map.size() > 0) {
                new MenuItem(menu_tags, 2);
            }
            HashSet<TagGroup> tag_groups = new HashSet<TagGroup>();
            ArrayList<Tag> tag_no_group = new ArrayList<Tag>();
            for (Tag t : all_manual_t) {
                TagGroup tg = t.getGroupContainer();
                if (tg == null || tg.getName() == null) {
                    tag_no_group.add(t);
                    continue;
                }
                tag_groups.add(tg);
            }
            if (!tag_groups.isEmpty()) {
                List<TagGroup> l_tg = TagUtils.sortTagGroups(tag_groups);
                for (TagGroup tg : l_tg) {
                    Menu menuGroup = new Menu((Decorations)menu_tags.getShell(), 4);
                    MenuItem groupItem = new MenuItem(menu_tags, 64);
                    groupItem.setText(tg.getName());
                    groupItem.setMenu(menuGroup);
                    TagUIUtils.build(dms, menuGroup, manual_map, tg.getTags());
                }
                if (!tag_no_group.isEmpty()) {
                    Menu menuGroup = new Menu((Decorations)menu_tags.getShell(), 4);
                    MenuItem groupItem = new MenuItem(menu_tags, 64);
                    Messages.setLanguageText((Widget)groupItem, "menu.no.group");
                    groupItem.setMenu(menuGroup);
                    TagUIUtils.build(dms, menuGroup, manual_map, tag_no_group);
                }
                new MenuItem(menu_tags, 2);
            }
            TagUIUtils.build(dms, menu_tags, manual_map, all_manual_t);
        }
    }

    private static void build(final DownloadManager[] dms, Menu menu_tags, Map<Tag, Integer> manual_map, List<Tag> manual_t) {
        ArrayList<String> menu_names = new ArrayList<String>();
        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
        for (Tag t : manual_t) {
            if (t.isTagAuto()[0] && t.isTagAuto()[1]) continue;
            String name = t.getTagName(true);
            menu_names.add(name);
            menu_name_map.put(name, t);
        }
        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
        for (Object obj : menu_structure) {
            Menu parent_menu;
            ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
            if (obj instanceof String) {
                parent_menu = menu_tags;
                bucket_tags.add((Tag)menu_name_map.get((String)obj));
            } else {
                Object[] entry = (Object[])obj;
                List tag_names = (List)entry[1];
                boolean sub_all_selected = true;
                boolean sub_some_selected = false;
                for (String name : tag_names) {
                    Tag sub_tag = (Tag)menu_name_map.get(name);
                    Integer c = manual_map.get(sub_tag);
                    if (c != null && c == dms.length) {
                        sub_some_selected = true;
                    } else {
                        sub_all_selected = false;
                    }
                    bucket_tags.add(sub_tag);
                }
                String mod = sub_all_selected ? " (*)" : (sub_some_selected ? " (+)" : "");
                Menu menu_bucket = new Menu((Decorations)menu_tags.getShell(), 4);
                MenuItem bucket_item = new MenuItem(menu_tags, 64);
                bucket_item.setText(String.valueOf((String)entry[0]) + mod);
                bucket_item.setMenu(menu_bucket);
                parent_menu = menu_bucket;
            }
            for (final Tag t : bucket_tags) {
                final MenuItem t_i = new MenuItem(parent_menu, 32);
                String tag_name = t.getTagName(true);
                Integer c = manual_map.get(t);
                if (c != null) {
                    if (c == dms.length) {
                        t_i.setSelection(true);
                        t_i.setText(tag_name);
                    } else {
                        t_i.setText(String.valueOf(tag_name) + " (" + c + ")");
                    }
                } else {
                    t_i.setText(tag_name);
                }
                TagUIUtils.setMenuIcon(t_i, t);
                t_i.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        boolean selected = t_i.getSelection();
                        try {
                            t.addTaggableBatch(true);
                            DownloadManager[] downloadManagerArray = dms;
                            int n = dms.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DownloadManager dm = downloadManagerArray[n2];
                                if (selected) {
                                    t.addTaggable(dm);
                                } else {
                                    t.removeTaggable(dm);
                                }
                                ++n2;
                            }
                        }
                        finally {
                            t.addTaggableBatch(false);
                        }
                    }
                });
            }
        }
    }

    public static MenuItem createTagSelectionMenu(Menu top_menu, String resource, List<Tag> tags, final TagSelectionListener listener) {
        MenuItem top_item;
        Menu menu;
        if (resource != null) {
            menu = new Menu((Decorations)top_menu.getShell(), 4);
            top_item = new MenuItem(top_menu, 64);
            Messages.setLanguageText((Widget)top_item, resource);
            top_item.setMenu(menu);
        } else {
            menu = top_menu;
            top_item = null;
        }
        ArrayList<String> menu_names = new ArrayList<String>();
        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
        for (Tag t : tags) {
            String name = t.getTagName(true);
            menu_names.add(name);
            menu_name_map.put(name, t);
        }
        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
        for (Object obj : menu_structure) {
            Menu parent_menu;
            ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
            if (obj instanceof String) {
                parent_menu = menu;
                bucket_tags.add((Tag)menu_name_map.get((String)obj));
            } else {
                Object[] entry = (Object[])obj;
                List tag_names = (List)entry[1];
                for (String name : tag_names) {
                    Tag sub_tag = (Tag)menu_name_map.get(name);
                    bucket_tags.add(sub_tag);
                }
                Menu menu_bucket = new Menu((Decorations)menu.getShell(), 4);
                MenuItem bucket_item = new MenuItem(menu, 64);
                bucket_item.setText((String)entry[0]);
                bucket_item.setMenu(menu_bucket);
                parent_menu = menu_bucket;
            }
            for (final Tag t : bucket_tags) {
                MenuItem mi = new MenuItem(parent_menu, 8);
                Messages.setLanguageText((Widget)mi, t.getTagName(false));
                TagUIUtils.setMenuIcon(mi, t);
                mi.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        listener.selected(t);
                    }
                });
            }
        }
        new MenuItem(menu, 2);
        MenuItem item_create = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item_create, "label.add.tag");
        item_create.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (tags != null) {
                            Tag[] tagArray = tags;
                            int n = tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Tag tag = tagArray[n2];
                                listener.selected(tag);
                                ++n2;
                            }
                        }
                    }
                });
            }
        });
        return top_item;
    }

    private static void showFilesView(TagDownload tag) {
        Shell shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 2;
        fillLayout.marginWidth = 2;
        shell.setLayout((Layout)fillLayout);
        final FilesView view = new FilesView();
        view.setDisableWhenEmpty(false);
        view.initialize((Composite)shell);
        view.dataSourceChanged(tag);
        view.viewActivated();
        view.refresh();
        UIUpdatable viewUpdater = new UIUpdatable(){

            @Override
            public void updateUI() {
                view.refresh();
            }

            @Override
            public String getUpdateUIName() {
                return view.getFullTitle();
            }
        };
        UIUpdaterSWT.getInstance().addUpdater(viewUpdater);
        shell.addDisposeListener(e -> {
            UIUpdaterSWT.getInstance().removeUpdater(viewUpdater);
            view.delete();
        });
        shell.layout(true, true);
        shell.setText(tag.getTagName(true));
        shell.open();
    }

    protected static void export(final List<Tag> tags) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("tag.export.select.template.file"));
                dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                        path = VuzeFileHandler.getVuzeFileName(path);
                    }
                    try {
                        VuzeFile vf = TagManagerFactory.getTagManager().exportTags(tags);
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected static void duplicate(List<Tag> tags) {
        TagManager tm = TagManagerFactory.getTagManager();
        for (Tag tag : tags) {
            tm.duplicate(tag);
        }
    }

    public static void openRenameTagDialog(Tag tag) {
        if (tag == null || tag.getTagType().isTagTypeAuto()) {
            return;
        }
        SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
        String tagName = tag.getTagName(true);
        entry.setPreenteredText(tagName, false);
        entry.maintainWhitespace(false);
        entry.allowEmptyInput(false);
        entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{tagName}));
        entry.prompt(result -> {
            if (!result.hasSubmittedInput()) {
                return;
            }
            String input = result.getSubmittedInput().trim();
            if (input.length() > 0) {
                try {
                    tag.setTagName(input);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    public static boolean canDeleteTag(Tag tag) {
        if (tag == null) {
            return false;
        }
        int tt = tag.getTagType().getTagType();
        if (tt == 3 || tt == 7) {
            return true;
        }
        return tag instanceof Category && ((Category)tag).getType() == 0;
    }

    public static boolean removeTags(Tag ... tags) {
        return TagUIUtils.removeTags(new ArrayList<Tag>(Arrays.asList(tags)));
    }

    public static boolean removeTags(List<Tag> tags) {
        Tag tagToRemove = null;
        while (tagToRemove == null && tags.size() > 0) {
            tagToRemove = tags.get(0);
            if (TagUIUtils.canDeleteTag(tagToRemove)) continue;
            tags.remove(0);
            tagToRemove = null;
        }
        int numLeft = tags.size();
        if (tagToRemove == null || numLeft == 0) {
            return true;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.tag.text", new String[]{tagToRemove.getTagName(true), "" + tagToRemove.getTaggedCount()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        if (numLeft > 1) {
            String sDeleteAll = MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft});
            mb.addCheckBox("!" + sDeleteAll + "!", 0, false);
        }
        Tag finalTagToRemove = tagToRemove;
        mb.open(result -> {
            if (result == -1) {
                return;
            }
            boolean remove = result == 0;
            boolean doAll = mb.getCheckBoxEnabled();
            if (doAll) {
                if (remove) {
                    for (Tag tag2 : tags) {
                        if (!TagUIUtils.canDeleteTag(tag2)) continue;
                        tag2.removeTag();
                    }
                }
            } else {
                if (remove) {
                    finalTagToRemove.removeTag();
                }
                tags.remove(0);
                TagUIUtils.removeTags(tags);
            }
        });
        return true;
    }

    public static interface TagSelectionListener {
        public void selected(Tag var1);
    }
}

