/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceManagerFactory;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TrancodeUIUtils {
    public static TranscodeTarget[] getTranscodeTargets() {
        ArrayList<1> result = new ArrayList<1>();
        if (!COConfigurationManager.getStringParameter("ui").equals("az2")) {
            try {
                Device[] devices;
                DeviceManager dm = DeviceManagerFactory.getSingleton();
                Device[] deviceArray = devices = dm.getDevices();
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    final Device d = deviceArray[n2];
                    if (d instanceof DeviceMediaRenderer) {
                        final DeviceMediaRenderer dmr = (DeviceMediaRenderer)d;
                        boolean hide_device = d.isHidden();
                        if (COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true) && dmr.isNonSimple()) {
                            hide_device = true;
                        }
                        if (!hide_device) {
                            result.add(new TranscodeTarget(){

                                @Override
                                public String getName() {
                                    return d.getName();
                                }

                                @Override
                                public String getID() {
                                    return d.getID();
                                }

                                @Override
                                public TranscodeProfile[] getProfiles() {
                                    ArrayList<TranscodeProfile> ps = new ArrayList<TranscodeProfile>();
                                    com.biglybt.core.devices.TranscodeProfile[] profs = dmr.getTranscodeProfiles();
                                    if (profs.length == 0) {
                                        if (dmr.getTranscodeRequirement() == 1) {
                                            ps.add(new TranscodeProfile(){

                                                @Override
                                                public String getUID() {
                                                    return String.valueOf(dmr.getID()) + "/" + dmr.getBlankProfile().getName();
                                                }

                                                @Override
                                                public String getName() {
                                                    return MessageText.getString("devices.profile.direct");
                                                }
                                            });
                                        }
                                    } else {
                                        com.biglybt.core.devices.TranscodeProfile[] transcodeProfileArray = profs;
                                        int n = profs.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            final com.biglybt.core.devices.TranscodeProfile prof = transcodeProfileArray[n2];
                                            ps.add(new TranscodeProfile(){

                                                @Override
                                                public String getUID() {
                                                    return prof.getUID();
                                                }

                                                @Override
                                                public String getName() {
                                                    return prof.getName();
                                                }
                                            });
                                            ++n2;
                                        }
                                    }
                                    return ps.toArray(new TranscodeProfile[ps.size()]);
                                }
                            });
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Collections.sort(result, new Comparator<TranscodeTarget>(){

            @Override
            public int compare(TranscodeTarget o1, TranscodeTarget o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result.toArray(new TranscodeTarget[result.size()]);
    }

    public static interface TranscodeProfile {
        public String getUID();

        public String getName();
    }

    public static interface TranscodeTarget {
        public String getID();

        public String getName();

        public TranscodeProfile[] getProfiles();
    }
}

