/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.widgets;

import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AnimatedImage {
    private static final int SPEED = 100;
    Canvas canvas;
    boolean running;
    private Image[] images;
    private int currentImage = 0;
    private String imageName;

    public AnimatedImage(Composite parent) {
        this.canvas = new Canvas(parent, 262144);
        Color background = null;
        Composite p = parent;
        while (p != null && background == null) {
            background = p.getBackground();
            if (background != null) break;
            p = p.getParent();
        }
        this.canvas.setBackground(background);
        this.canvas.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                AnimatedImage.this.stop();
                AnimatedImage.this.disposeImages();
            }
        });
    }

    private void renderNextImage() {
        Display display;
        if (!this.canvas.isDisposed() && !(display = this.canvas.getDisplay()).isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AnimatedImage.this.canvas.isDisposed() && AnimatedImage.this.images != null) {
                        Image image;
                        AnimatedImage animatedImage = AnimatedImage.this;
                        animatedImage.currentImage = animatedImage.currentImage + 1;
                        if (AnimatedImage.this.currentImage >= AnimatedImage.this.images.length) {
                            AnimatedImage.this.currentImage = 0;
                        }
                        if (AnimatedImage.this.currentImage < AnimatedImage.this.images.length && (image = AnimatedImage.this.images[AnimatedImage.this.currentImage]) != null && !image.isDisposed()) {
                            Rectangle imageBounds = image.getBounds();
                            Image tempImage = new Image((Device)AnimatedImage.this.canvas.getDisplay(), new Rectangle(0, 0, imageBounds.width, imageBounds.height));
                            GC gcImage = new GC((Drawable)tempImage);
                            gcImage.setBackground(AnimatedImage.this.canvas.getBackground());
                            gcImage.fillRectangle(new Rectangle(0, 0, imageBounds.width, imageBounds.width));
                            gcImage.drawImage(image, 0, 0);
                            GC gc = new GC((Drawable)AnimatedImage.this.canvas);
                            Point canvasSize = AnimatedImage.this.canvas.getSize();
                            gc.drawImage(tempImage, (canvasSize.x - imageBounds.width) / 2, (canvasSize.y - imageBounds.height) / 2);
                            tempImage.dispose();
                            gcImage.dispose();
                            gc.dispose();
                        }
                    }
                }
            });
        }
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void start() {
        this.running = true;
        AEThread2 runner = new AEThread2("image runner", true){

            @Override
            public void run() {
                while (AnimatedImage.this.running) {
                    try {
                        AnimatedImage.this.renderNextImage();
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        AnimatedImage.this.running = false;
                    }
                }
            }
        };
        runner.start();
    }

    public void stop() {
        this.running = false;
    }

    public Control getControl() {
        return this.canvas;
    }

    public void dispose() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }

    public void setImageFromName(String imageName) {
        this.imageName = imageName;
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.images = imageLoader.getImages(imageName);
    }

    private void setImages(Image[] images) {
        this.disposeImages();
        this.images = images;
    }

    private void disposeImages() {
        if (this.images != null) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage(this.imageName);
            this.images = null;
        }
    }
}

