/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.widgets;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.widgets.TagCanvas;
import com.biglybt.util.StringCompareUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class TagPainter {
    private static final int DEF_MIN_WIDTH = 25;
    private static final Point MAX_IMAGE_SIZE = new Point(40, 28);
    private static final int DEF_CURVE_WIDTH = 25;
    private static final int COMPACT_CURVE_WIDTH = 15;
    private static final int DEF_PADDING_IMAGE_X = 5;
    private static final int COMPACT_PADDING_IMAGE_X = 0;
    private static final int DEF_PADDING_IMAGE_Y = 2;
    private static final int COMPACT_PADDING_IMAGE_Y = 1;
    private static final int DEF_CONTENT_PADDING_Y = 3;
    private static final int COMPACT_CONTENT_PADDING_Y = 2;
    private static final int DEF_CONTENT_PADDING_X0 = 5;
    private static final int COMPACT_CONTENT_PADDING_X0 = 3;
    private static final int DEF_CONTENT_PADDING_X1 = 8;
    private static final int COMPACT_CONTENT_PADDING_X1 = 5;
    protected final Tag tag;
    private final TagCanvas control;
    public int paddingContentY = 3;
    public int paddingContentX0 = 5;
    public int paddingContentX1 = 8;
    public int paddingImageX = 5;
    public int paddingImageY = 2;
    public int curveWidth = 25;
    public String imageID;
    public Image image;
    public String lastUsedName;
    public boolean imageOverridesText = false;
    public boolean showImage = true;
    public Font font = null;
    public Color colorTagFaded;
    public Color colorTag;
    public boolean alwaysDrawBorder;
    public boolean needsBorderOnSelection;
    protected boolean compact;
    protected boolean isEnabled = true;
    protected boolean enableWhenNoTaggables;
    protected TagCanvas.TagButtonTrigger trigger;
    protected boolean disableAuto;
    private int minWidth = 25;
    private boolean grayed;
    private int alpha = 255;
    private boolean selected;
    private boolean disposed;

    public TagPainter(Tag tag, TagCanvas control) {
        this.tag = tag;
        this.control = control;
    }

    public TagPainter(Tag tag) {
        this.tag = tag;
        this.control = null;
    }

    public Point computeSize(Device device, Font font) {
        if (this.lastUsedName == null) {
            this.lastUsedName = this.tag.getTagName(true);
        }
        GC gc = new GC((Drawable)device);
        gc.setFont(font);
        gc.setTextAntialias(1);
        boolean canShowImage = this.showImage && this.image != null && !this.image.isDisposed();
        boolean onlyShowImage = this.imageOverridesText && canShowImage;
        String text = this.lastUsedName.isEmpty() || onlyShowImage ? "\u200b" : this.lastUsedName;
        GCStringPrinter sp = new GCStringPrinter(gc, text, new Rectangle(0, 0, 9999, 9999), false, true, 16384);
        sp.calculateMetrics();
        Point size = sp.getCalculatedSize();
        gc.dispose();
        if (size == null) {
            return null;
        }
        size.x += this.paddingContentX0 + this.paddingContentX1;
        size.y += this.paddingContentY + this.paddingContentY;
        if (canShowImage) {
            if (onlyShowImage) {
                size.x = 0;
            }
            Rectangle bounds = this.image.getBounds();
            int imageH = size.y - this.paddingImageY - this.paddingImageY;
            int imageW = bounds.width * imageH / bounds.height;
            size.x += imageW + this.paddingImageX;
        }
        size.x = Math.max(this.minWidth, size.x);
        return size;
    }

    public void dispose() {
        if (this.imageID != null) {
            ImageLoader.getInstance().releaseImage(this.imageID);
            this.imageID = null;
            this.image = null;
        }
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
        this.disposed = true;
    }

    public Control getControl() {
        return this.control;
    }

    public Point getSize(GC gc) {
        this.updateImage();
        return this.computeSize(gc.getDevice(), gc.getFont());
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isGrayed() {
        return this.grayed;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setAlpha(int _alpha) {
        if (this.alpha != _alpha) {
            this.alpha = _alpha;
            this.redrawControl();
        }
    }

    public boolean paint(Taggable taggable, GC gc, int x, int y) {
        Point size = this.computeSize(gc.getDevice(), gc.getFont());
        if (taggable != null) {
            this.updateState(Collections.singletonList(taggable), gc.getDevice(), gc.getForeground(), gc.getBackground());
        } else {
            this.updateImage();
            this.updateColors(gc.getDevice(), gc.getForeground(), gc.getBackground());
        }
        Rectangle r = new Rectangle(0, 0, size.x, size.y);
        this.paintControl(gc, x, y, r, size, false);
        return true;
    }

    public void paintControl(GC gc, int xOfs, int yOfs, Rectangle clientArea, Point size, boolean focused) {
        int imageX;
        int imageW;
        int imageH;
        boolean imageOverride;
        if (this.lastUsedName == null) {
            return;
        }
        gc.setAlpha(this.alpha);
        Color colorOrigBG = gc.getBackground();
        Color colorText = Colors.getInstance().getReadableColor(this.selected ? (this.grayed ? this.colorTagFaded : this.colorTag) : colorOrigBG);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.selected) {
            gc.setBackground(this.grayed ? this.colorTagFaded : this.colorTag);
            gc.fillRoundRectangle(xOfs + -this.curveWidth, yOfs, size.x + this.curveWidth - 1, size.y - 1, this.curveWidth, this.curveWidth);
        }
        boolean bl = imageOverride = this.imageOverridesText && this.image != null;
        if (!(imageOverride || this.selected && !this.grayed)) {
            int y1;
            int lineWidth = focused ? 2 : 2;
            int x1 = y1 = lineWidth / 2;
            int width = size.x - lineWidth;
            int height = size.y - lineWidth;
            gc.setLineWidth(lineWidth);
            gc.setForeground(this.colorTag);
            gc.setLineStyle(1);
            gc.drawRoundRectangle(xOfs + -this.curveWidth, yOfs + y1, width + this.curveWidth, height - y1 + 1, this.curveWidth, this.curveWidth);
            gc.drawLine(xOfs + x1, yOfs + y1, xOfs + x1, yOfs + height - y1 + 1);
            gc.setLineWidth(1);
        }
        if (this.alwaysDrawBorder || this.selected && this.needsBorderOnSelection) {
            gc.setLineWidth(1);
            gc.setForeground(colorText);
            gc.setAlpha(112);
            gc.setLineStyle(1);
            gc.drawRoundRectangle(xOfs + -this.curveWidth, yOfs, size.x + this.curveWidth - 1, size.y - 1, this.curveWidth, this.curveWidth);
            gc.drawLine(xOfs, yOfs, xOfs, yOfs + size.y - 1);
            gc.setAlpha(this.alpha);
        }
        clientArea.x += xOfs;
        clientArea.y += yOfs;
        if (this.compact && this.showImage && imageOverride) {
            Rectangle bounds = this.image.getBounds();
            imageH = size.y - this.paddingImageY - this.paddingImageY;
            imageW = bounds.width * imageH / bounds.height;
            int leftPad = (clientArea.width - (imageW + this.paddingImageX * 2)) / 2;
            clientArea.x += leftPad;
            imageX = clientArea.x + this.paddingImageX;
            gc.drawImage(this.image, 0, 0, bounds.width, bounds.height, imageX, clientArea.y + this.paddingImageY, imageW, imageH);
            clientArea.x += leftPad + imageW + this.paddingImageX * 2;
            clientArea.width -= leftPad + imageW + this.paddingImageX * 2;
        } else {
            clientArea.x += this.paddingContentX0;
            clientArea.width -= this.paddingContentX0;
            imageX = clientArea.x;
            if (this.showImage && this.image != null) {
                Rectangle bounds = this.image.getBounds();
                imageH = size.y - this.paddingImageY - this.paddingImageY;
                imageW = bounds.width * imageH / bounds.height;
                gc.drawImage(this.image, 0, 0, bounds.width, bounds.height, imageX, clientArea.y + this.paddingImageY, imageW, imageH);
                clientArea.x += imageW + this.paddingImageX;
                clientArea.width -= imageW - this.paddingImageX;
            }
        }
        gc.setForeground(colorText);
        clientArea.y += this.paddingContentY;
        clientArea.height -= this.paddingContentY + this.paddingContentY;
        String text = imageOverride ? "\u200b" : (this.lastUsedName.isEmpty() ? "\u200b" : this.lastUsedName);
        GCStringPrinter sp = new GCStringPrinter(gc, text, clientArea, true, true, 16384);
        sp.printString();
        if (focused) {
            Rectangle focusRect = sp.getCalculatedDrawRect();
            if (focusRect == null) {
                focusRect = sp.getPrintArea();
            }
            gc.setLineDash(new int[]{2, 1});
            int y = focusRect.y + focusRect.height - 1;
            if (imageOverride) {
                Rectangle bounds = this.image.getBounds();
                int imageH2 = size.y - this.paddingImageY - this.paddingImageY;
                int imageW2 = bounds.width * imageH2 / bounds.height;
                gc.drawLine(imageX, y, imageX + imageW2, y);
            } else {
                if (this.lastUsedName.isEmpty()) {
                    focusRect.width = this.minWidth - this.curveWidth;
                }
                gc.drawLine(focusRect.x, y, focusRect.x + focusRect.width - 1, y);
            }
            gc.setLineStyle(1);
        }
    }

    private void redrawControl() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.redraw();
    }

    private void relayoutControl(boolean redraw) {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        try {
            this.control.requestLayout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (redraw) {
            this.control.redraw();
        }
    }

    public boolean setCompact(boolean compact, boolean imageOverride) {
        if (this.compact == compact) {
            return false;
        }
        this.compact = compact;
        if (compact) {
            this.paddingImageX = 0;
            this.paddingImageY = 1;
            this.paddingContentY = 2;
            this.paddingContentX0 = 3;
            this.paddingContentX1 = 5;
            this.curveWidth = 15;
            this.showImage = imageOverride;
            this.imageOverridesText = imageOverride;
            if (this.imageOverridesText) {
                this.paddingImageY = 2;
            }
        } else {
            this.paddingImageX = 5;
            this.paddingImageY = 2;
            this.paddingContentY = 3;
            this.paddingContentX0 = 5;
            this.paddingContentX1 = 8;
            this.curveWidth = 25;
            this.showImage = true;
        }
        this.relayoutControl(false);
        return true;
    }

    public boolean setDisableAuto(boolean disableAuto) {
        boolean enable;
        if (this.disableAuto == disableAuto) {
            return false;
        }
        this.disableAuto = disableAuto;
        if (disableAuto) {
            boolean[] auto = this.tag.isTagAuto();
            boolean isTagAuto = auto.length >= 2 && auto[0] && auto[1];
            enable = !isTagAuto;
        } else {
            enable = true;
        }
        boolean redraw = this.setEnabledNoRedraw(enable);
        if (redraw) {
            this.redrawControl();
        }
        return redraw;
    }

    public boolean setEnableWhenNoTaggables(boolean enableWhenNoTaggables) {
        if (this.enableWhenNoTaggables == enableWhenNoTaggables) {
            return false;
        }
        this.enableWhenNoTaggables = enableWhenNoTaggables;
        if (this.control != null) {
            this.control.redraw();
        }
        return true;
    }

    public boolean setEnabled(boolean enabled) {
        if (this.setEnabledNoRedraw(enabled)) {
            this.redrawControl();
            return true;
        }
        return false;
    }

    public boolean setEnabledNoRedraw(boolean enabled) {
        boolean wasEnabled = this.isEnabled;
        this.isEnabled = enabled;
        return wasEnabled ^ enabled;
    }

    public boolean setGrayed(boolean b) {
        if (this.setGrayedNoRedraw(b)) {
            this.redrawControl();
            return true;
        }
        return false;
    }

    protected boolean setGrayedNoRedraw(boolean b) {
        if (b == this.grayed) {
            return false;
        }
        this.grayed = b;
        return true;
    }

    public boolean setImage(Image newImage, String key) {
        if (!ImageLoader.isRealImage(newImage)) {
            return false;
        }
        if (newImage == this.image && StringCompareUtils.equals(key, this.imageID)) {
            return false;
        }
        if (this.imageID != null) {
            ImageLoader.getInstance().releaseImage(this.imageID);
        }
        this.image = newImage;
        this.imageID = key;
        if (this.control == null || this.control.isInitialised()) {
            this.relayoutControl(true);
        }
        return true;
    }

    public boolean setMinWidth(int minWidth) {
        if (this.minWidth == minWidth) {
            return false;
        }
        this.minWidth = minWidth;
        this.relayoutControl(false);
        return true;
    }

    public boolean setSelected(boolean select) {
        if (this.setSelected(select, true)) {
            this.redrawControl();
            return true;
        }
        return false;
    }

    protected boolean setSelected(boolean select, boolean unGray) {
        if (select != this.selected) {
            this.selected = select;
            if (this.grayed && unGray) {
                this.grayed = false;
            }
            return true;
        }
        return false;
    }

    public boolean updateColors(Device device, Color defaultFG, Color defaultBG) {
        Color newColorTag = ColorCache.getColor(device, this.tag.getColor());
        if (newColorTag == null) {
            newColorTag = defaultFG;
        }
        if (newColorTag.equals((Object)this.colorTag)) {
            return false;
        }
        this.colorTag = newColorTag;
        HSLColor hslColor = new HSLColor();
        hslColor.initHSLbyRGB(this.colorTag.getRed(), this.colorTag.getGreen(), this.colorTag.getBlue());
        hslColor.blend(defaultBG.getRed(), defaultBG.getGreen(), defaultBG.getBlue(), 0.75f);
        Color newColorTagFaded = ColorCache.getColor(device, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        this.colorTagFaded = newColorTagFaded == null ? defaultFG : newColorTagFaded;
        this.needsBorderOnSelection = !Colors.isColorContrastOk(defaultBG, this.colorTag);
        return true;
    }

    public void updateImage() {
        String iconFile = this.tag.getImageFile();
        if (iconFile != null) {
            try {
                File file = new File(iconFile);
                ImageLoader.getInstance().getFileImage(file, MAX_IMAGE_SIZE, (image, key, returnedImmediately) -> {
                    if (image == null) {
                        return;
                    }
                    if (this.isDisposed()) {
                        ImageLoader.getInstance().releaseImage(key);
                    } else {
                        Utils.execSWTThread(() -> {
                            boolean bl = this.setImage(image, key);
                        });
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            String id = this.tag.getImageID();
            if (id != null) {
                Image image2 = ImageLoader.getInstance().getImage(id);
                this.setImage(image2, id);
            } else {
                this.setImage(null, null);
            }
        }
    }

    public boolean updateName() {
        String tagName = this.tag.getTagName(true);
        if (!tagName.equals(this.lastUsedName)) {
            this.lastUsedName = null;
            this.relayoutControl(false);
            return true;
        }
        return false;
    }

    public boolean updateState(List<Taggable> taggables) {
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        return this.updateState(taggables, (Device)this.control.getDisplay(), this.control.getForeground(), this.control.getBackground());
    }

    public boolean updateState(List<Taggable> taggables, Device device, Color defaultFG, Color defaultBG) {
        boolean newEnableState;
        Boolean override;
        this.updateImage();
        boolean needRedraw = this.updateName();
        needRedraw |= this.updateColors(device, defaultFG, defaultBG);
        if (taggables == null) {
            needRedraw |= this.setEnabledNoRedraw(this.enableWhenNoTaggables);
            if (!this.enableWhenNoTaggables) {
                if (needRedraw |= this.setSelected(false, false)) {
                    this.redrawControl();
                }
                return needRedraw;
            }
        }
        boolean hasTag = false;
        boolean hasNoTag = false;
        Boolean bl = override = this.trigger == null ? null : this.trigger.tagSelectedOverride(this.tag);
        if (taggables != null && override == null) {
            for (Taggable taggable : taggables) {
                boolean curHasTag = this.tag.hasTaggable(taggable);
                if (!hasTag && curHasTag) {
                    hasTag = true;
                    if (!hasNoTag) continue;
                } else {
                    if (hasNoTag || curHasTag) continue;
                    hasNoTag = true;
                    if (!hasTag) {
                        continue;
                    }
                }
                break;
            }
        } else if (override != null) {
            hasNoTag = override == false;
            hasTag = override;
        }
        boolean[] auto = this.tag.isTagAuto();
        boolean auto_add = auto[0];
        boolean auto_rem = auto[1];
        if (hasTag && hasNoTag) {
            newEnableState = !auto_add;
            needRedraw |= this.setGrayedNoRedraw(true);
            needRedraw |= this.setSelected(true, false);
        } else {
            if (auto_add && auto_rem) {
                needRedraw |= this.setGrayedNoRedraw(!hasTag);
                newEnableState = false;
            } else {
                newEnableState = hasTag || !hasTag && !auto_add;
                needRedraw |= this.setGrayedNoRedraw(false);
            }
            needRedraw |= this.setSelected(hasTag, false);
        }
        if (this.disableAuto) {
            needRedraw |= this.setEnabledNoRedraw(newEnableState);
        }
        if (needRedraw) {
            this.redrawControl();
        }
        return needRedraw;
    }
}

