/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.utils;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageBytesDownloader {
    static final Map<String, List<ImageDownloaderListener>> map = new HashMap<String, List<ImageDownloaderListener>>();
    static final AEMonitor mon_map = new AEMonitor("ImageDownloaderMap");

    public static void loadImage(final String url, ImageDownloaderListener l) {
        mon_map.enter();
        try {
            List<ImageDownloaderListener> list = map.get(url);
            if (list != null) {
                list.add(l);
                return;
            }
            list = new ArrayList<ImageDownloaderListener>(1);
            list.add(l);
            map.put(url, list);
        }
        finally {
            mon_map.exit();
        }
        try {
            URL u = new URL(url);
            ResourceDownloader rd = AENetworkClassifier.categoriseAddress(u.getHost()) == "Public" ? ResourceDownloaderFactoryImpl.getSingleton().create(u) : ResourceDownloaderFactoryImpl.getSingleton().createWithAutoPluginProxy(u);
            rd.addListener(new ResourceDownloaderAdapter(){

                @Override
                public boolean completed(ResourceDownloader downloader, InputStream is) {
                    mon_map.enter();
                    try {
                        List<ImageDownloaderListener> list = map.get(url);
                        if (list != null) {
                            try {
                                if (is != null && is.available() > 0) {
                                    byte[] newImageBytes = new byte[is.available()];
                                    is.read(newImageBytes);
                                    for (ImageDownloaderListener l : list) {
                                        try {
                                            l.imageDownloaded(newImageBytes);
                                        }
                                        catch (Exception e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        map.remove(url);
                    }
                    finally {
                        mon_map.exit();
                    }
                    return false;
                }
            });
            rd.asyncDownload();
        }
        catch (Exception e) {
            Debug.out(url, e);
        }
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(byte[] var1);
    }
}

