/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerEnhancer;
import com.biglybt.core.download.EnhancedDownloadManager;
import com.biglybt.core.download.StreamManager;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.DataSourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class PlayUtils {
    public static final boolean COMPLETE_PLAY_ONLY = true;
    public static final String playableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac .mts .m2ts .wmv";
    private static volatile String actualPlayableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac .mts .m2ts .wmv";
    private static Boolean hasQuickTime;
    private static ThreadLocal<int[]> tls_non_block_indicator;
    private static AtomicInteger dm_uid;
    private static final Map<String, Object[]> ext_play_cache;

    static {
        tls_non_block_indicator = new ThreadLocal<int[]>(){

            @Override
            public int[] initialValue() {
                return new int[1];
            }
        };
        dm_uid = new AtomicInteger();
        ext_play_cache = new LinkedHashMap<String, Object[]>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
                return this.size() > 100;
            }
        };
    }

    public static boolean prepareForPlay(DownloadManager dm) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        if (edm != null) {
            edm.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canUseEMP(DiskManagerFileInfo file) {
        return PlayUtils.isExternallyPlayable(file);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index) {
        return PlayUtils.canUseEMP(torrent, file_index, true);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.canPlayViaExternalEMP(torrent, file_index, complete_only);
    }

    private static boolean canPlay(DownloadManager dm, int file_index) {
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    private static boolean canPlay(TOTorrent torrent, int file_index) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    public static boolean canPlayDS(Object ds, int file_index, boolean block_for_accuracy) {
        block15: {
            boolean bl;
            block16: {
                block13: {
                    boolean bl2;
                    block14: {
                        block11: {
                            boolean bl3;
                            block12: {
                                block9: {
                                    boolean bl4;
                                    block10: {
                                        int[] nArray;
                                        if (ds == null) {
                                            return false;
                                        }
                                        try {
                                            if (!block_for_accuracy) {
                                                int[] nArray2 = tls_non_block_indicator.get();
                                                nArray2[0] = nArray2[0] + 1;
                                            }
                                            if (!(ds instanceof com.biglybt.core.disk.DiskManagerFileInfo)) break block9;
                                            com.biglybt.core.disk.DiskManagerFileInfo fi = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
                                            bl4 = PlayUtils.canPlayDS(fi.getDownloadManager(), fi.getIndex(), block_for_accuracy);
                                            if (block_for_accuracy) break block10;
                                            nArray = tls_non_block_indicator.get();
                                        }
                                        catch (Throwable throwable) {
                                            if (!block_for_accuracy) {
                                                int[] nArray3 = tls_non_block_indicator.get();
                                                nArray3[0] = nArray3[0] - 1;
                                            }
                                            throw throwable;
                                        }
                                        nArray[0] = nArray[0] - 1;
                                    }
                                    return bl4;
                                }
                                DownloadManager dm = DataSourceUtils.getDM(ds);
                                if (dm == null) break block11;
                                bl3 = PlayUtils.canPlay(dm, file_index);
                                if (block_for_accuracy) break block12;
                                int[] nArray = tls_non_block_indicator.get();
                                nArray[0] = nArray[0] - 1;
                            }
                            return bl3;
                        }
                        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
                        if (torrent == null) break block13;
                        bl2 = PlayUtils.canPlay(torrent, file_index);
                        if (block_for_accuracy) break block14;
                        int[] nArray = tls_non_block_indicator.get();
                        nArray[0] = nArray[0] - 1;
                    }
                    return bl2;
                }
                if (!(ds instanceof ActivitiesEntry)) break block15;
                bl = ((ActivitiesEntry)ds).isPlayable(block_for_accuracy);
                if (block_for_accuracy) break block16;
                int[] nArray = tls_non_block_indicator.get();
                nArray[0] = nArray[0] - 1;
            }
            return bl;
        }
        if (!block_for_accuracy) {
            int[] nArray = tls_non_block_indicator.get();
            nArray[0] = nArray[0] - 1;
        }
        return false;
    }

    public static boolean isStreamPermitted() {
        return true;
    }

    private static boolean canStream(DownloadManager dm, int file_index) {
        com.biglybt.core.disk.DiskManagerFileInfo file;
        if (dm == null) {
            return false;
        }
        if (file_index == -1) {
            file = dm.getDownloadState().getPrimaryFile();
            if (file == null) {
                com.biglybt.core.disk.DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                if (files.length == 0) {
                    return false;
                }
                file = files[0];
            }
            file_index = file.getIndex();
        } else {
            file = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
        }
        if (file.getDownloaded() == file.getLength()) {
            return false;
        }
        if (!StreamManager.getSingleton().isStreamingUsable()) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index, false);
    }

    public static boolean canStreamDS(Object ds, int file_index, boolean block_for_accuracy) {
        boolean bl;
        block8: {
            block6: {
                boolean bl2;
                block7: {
                    int[] nArray;
                    if (ds == null) {
                        return false;
                    }
                    try {
                        if (!block_for_accuracy) {
                            int[] nArray2 = tls_non_block_indicator.get();
                            nArray2[0] = nArray2[0] + 1;
                        }
                        if (!(ds instanceof com.biglybt.core.disk.DiskManagerFileInfo)) break block6;
                        com.biglybt.core.disk.DiskManagerFileInfo fi = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
                        bl2 = PlayUtils.canStreamDS(fi.getDownloadManager(), fi.getIndex(), block_for_accuracy);
                        if (block_for_accuracy) break block7;
                        nArray = tls_non_block_indicator.get();
                    }
                    catch (Throwable throwable) {
                        if (!block_for_accuracy) {
                            int[] nArray3 = tls_non_block_indicator.get();
                            nArray3[0] = nArray3[0] - 1;
                        }
                        throw throwable;
                    }
                    nArray[0] = nArray[0] - 1;
                }
                return bl2;
            }
            DownloadManager dm = DataSourceUtils.getDM(ds);
            boolean bl3 = bl = dm != null && PlayUtils.canStream(dm, file_index);
            if (block_for_accuracy) break block8;
            int[] nArray = tls_non_block_indicator.get();
            nArray[0] = nArray[0] - 1;
        }
        return bl;
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            boolean use_peek;
            Object url;
            UIFunctions uif;
            if (hasQuickTime == null && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                hasQuickTime = uif.isProgramInstalled(".qtl", "Quicktime");
                try {
                    pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{hasQuickTime});
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
                }
            }
            if ((url = (use_peek = tls_non_block_indicator.get()[0] > 0) && pi.getIPC().canInvoke("peekContentURL", new Object[]{file}) ? pi.getIPC().invoke("peekContentURL", new Object[]{file}) : pi.getIPC().invoke("getContentURL", new Object[]{file})) instanceof String) {
                return new URL((String)url);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExternallyPlayable(Download d, int file_index, boolean complete_only) {
        if (d == null) {
            return false;
        }
        boolean use_cache = d.getState() != 4;
        String cache_key = null;
        long now = 0L;
        if (use_cache) {
            Object[] cached;
            Integer uid = (Integer)d.getUserData(PlayUtils.class);
            if (uid == null) {
                uid = dm_uid.getAndIncrement();
                d.setUserData(PlayUtils.class, uid);
            }
            cache_key = uid + "/" + file_index + "/" + complete_only;
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                cached = ext_play_cache.get(cache_key);
            }
            now = SystemTime.getMonotonousTime();
            if (cached != null && now - (Long)cached[0] < 60000L) {
                return (Boolean)cached[1];
            }
        }
        boolean result = PlayUtils.isExternallyPlayableSupport(d, file_index, complete_only);
        if (use_cache) {
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                ext_play_cache.put(cache_key, new Object[]{now, result});
            }
        }
        return result;
    }

    private static boolean isExternallyPlayableSupport(Download d, int file_index, boolean complete_only) {
        int primary_file_index = -1;
        if (file_index == -1) {
            DownloadManager dm = PluginCoreUtils.unwrap(d);
            if (dm == null) {
                return false;
            }
            DiskManagerFileInfo file = null;
            try {
                file = PluginCoreUtils.wrap(dm.getDownloadState().getPrimaryFile());
            }
            catch (DownloadException e) {
                return false;
            }
            if (file == null) {
                return false;
            }
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file.getIndex();
        } else {
            DiskManagerFileInfo file = d.getDiskManagerFileInfo(file_index);
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file_index;
        }
        if (primary_file_index == -1) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(d.getDiskManagerFileInfo()[primary_file_index]);
    }

    public static int[] getExternallyPlayableFileIndexes(Download d, boolean complete_only) {
        int[] playableIndexes = new int[]{};
        DiskManagerFileInfo[] fileInfos = d.getDiskManagerFileInfo();
        int i = 0;
        while (i < fileInfos.length) {
            DiskManagerFileInfo fileInfo2 = fileInfos[i];
            if ((!complete_only || fileInfo2.getLength() == fileInfo2.getDownloaded()) && PlayUtils.isExternallyPlayable(fileInfo2)) {
                int[] newPlayableIndexes = new int[playableIndexes.length + 1];
                System.arraycopy(playableIndexes, 0, newPlayableIndexes, 0, playableIndexes.length);
                newPlayableIndexes[playableIndexes.length] = i;
                playableIndexes = newPlayableIndexes;
            }
            ++i;
        }
        return playableIndexes;
    }

    public static com.biglybt.core.disk.DiskManagerFileInfo getBestPlayableFile(DownloadManager download) {
        com.biglybt.core.disk.DiskManagerFileInfo[] files = download.getDiskManagerFileInfoSet().getFiles();
        String exts = PlayUtils.getPlayableFileExtensions();
        long largest = -1L;
        com.biglybt.core.disk.DiskManagerFileInfo best = null;
        com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            long size;
            String ext;
            File file;
            String name;
            int extIndex;
            com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = diskManagerFileInfoArray[n2];
            if (!fileInfo2.isSkipped() && (extIndex = (name = (file = fileInfo2.getFile(true)).getName()).lastIndexOf(".")) > -1 && (ext = name.substring(extIndex)) != null && exts.contains(ext = ext.toLowerCase()) && (size = file.length()) > largest) {
                largest = size;
                best = fileInfo2;
            }
            ++n2;
        }
        return best;
    }

    private static boolean isExternallyPlayable(DiskManagerFileInfo file) {
        int extIndex;
        String name = file.getFile(true).getName();
        try {
            String is;
            Download dl = file.getDownload();
            if (dl != null && (is = PluginCoreUtils.unwrap(dl).getDownloadState().getAttribute("incompfilesuffix")) != null && name.endsWith(is)) {
                name = name.substring(0, name.length() - is.length());
            }
        }
        catch (Throwable dl) {
            // empty catch block
        }
        if ((extIndex = name.lastIndexOf(".")) > -1) {
            String ext = name.substring(extIndex);
            if (ext == null) {
                return false;
            }
            ext = ext.toLowerCase();
            if (PlayUtils.getPlayableFileExtensions().contains(ext)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExternallyPlayable(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        try {
            Download download = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(torrent.getHash());
            if (download != null) {
                return PlayUtils.isExternallyPlayable(download, file_index, complete_only);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean canPlayViaExternalEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(torrent, file_index, complete_only);
    }

    public static String getPlayableFileExtensions() {
        return actualPlayableFileExtensions;
    }

    public static void setPlayableFileExtensions(String str) {
        actualPlayableFileExtensions = str;
    }

    public static boolean isEMPAvailable() {
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
        return pi != null && !pi.getPluginState().isDisabled();
    }

    public static boolean playURL(URL url, String name) {
        Method ow;
        PluginInterface pi;
        block4: {
            try {
                pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (pi != null && !pi.getPluginState().isDisabled()) break block4;
                return false;
            }
            catch (Throwable e) {
                Debug.out(e);
                return false;
            }
        }
        Class<?> ewp_class = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        if (ewp_class != null && (ow = ewp_class.getMethod("openWindow", URL.class, String.class)) != null) {
            ow.invoke(null, url, name);
            return true;
        }
        return false;
    }
}

