/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.core.messenger.PlatformMessenger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import java.util.Iterator;

public class UrlFilter {
    private static UrlFilter instance = null;
    private String DEFAULT_RPC_WHITELIST = "https?://" + "https://www.biglybt.com/".replaceAll("\\.", "\\\\.") + ":?[0-9]*/" + ".*";
    private CopyOnWriteList<String> listUrlBlacklist = new CopyOnWriteList();
    private CopyOnWriteList<String> listUrlWhitelist = new CopyOnWriteList();
    private AEMonitor mon = new AEMonitor("UrlFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrlFilter getInstance() {
        Class<UrlFilter> clazz = UrlFilter.class;
        synchronized (UrlFilter.class) {
            if (instance == null) {
                instance = new UrlFilter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public UrlFilter() {
        this.addUrlWhitelist(this.DEFAULT_RPC_WHITELIST);
        this.addUrlWhitelist("https?://([^.]+.?)?biglybt.com:?[0-9]*/.*");
        this.addUrlWhitelist("https?://([^.]+.?)?vuze.com:?[0-9]*/.*");
        this.addUrlWhitelist("https?://192\\.168\\.0\\.*:?[0-9]*/.*");
        this.addUrlWhitelist("https?://localhost:?[0-9]*/.*");
        this.addUrlWhitelist("https?://plusone\\.google\\.com/.*");
        this.addUrlWhitelist("https?://clients[0-9]\\.google\\.com/.*");
    }

    public void addUrlWhitelist(String string) {
        this.addUrlWhitelistSupport(string);
        if (string.contains("://localhost")) {
            this.addUrlWhitelistSupport(string.replace("://localhost", "://127.0.0.1"));
        }
    }

    private void addUrlWhitelistSupport(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlWhitelist.contains(string)) {
                PlatformMessenger.debug("add whitelist of " + string);
                this.listUrlWhitelist.add(string);
            } else {
                PlatformMessenger.debug("whitelist already exists: " + string);
            }
        }
        finally {
            this.mon.exit();
        }
    }

    public void addUrlBlacklist(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlBlacklist.contains(string)) {
                PlatformMessenger.debug("add blacklist of " + string);
                this.listUrlBlacklist.add(string);
            }
        }
        finally {
            this.mon.exit();
        }
    }

    public String[] getUrlWhitelist() {
        return this.listUrlWhitelist.toArray((String[])new String[0]);
    }

    public boolean isWhitelisted(String url) {
        Iterator<String> it = this.listUrlWhitelist.iterator();
        while (it.hasNext()) {
            if (!url.matches(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean urlCanRPC(String url) {
        return this.urlCanRPC(url, false);
    }

    public boolean urlCanRPC(String url, boolean showDebug) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return false;
        }
        if (Constants.isCVSVersion() && url.startsWith("file://")) {
            return true;
        }
        if (this.isWhitelisted(url)) {
            return true;
        }
        if (showDebug) {
            Debug.out("urlCanRPC: URL '" + url + "' " + " does not match one of the " + this.listUrlWhitelist.size() + " whitelist entries");
        }
        return false;
    }

    public boolean urlIsBlocked(String url) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return true;
        }
        for (String blackListed : this.listUrlBlacklist) {
            if (!url.matches(blackListed)) continue;
            Debug.out("URL '" + url + "' " + " is blocked by " + blackListed);
            return true;
        }
        return false;
    }
}

