/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1StreamParser;
import org.gudy.bouncycastle.asn1.DEREncodable;

public class ASN1ObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private ASN1StreamParser _aIn;

    protected ASN1ObjectParser(int baseTag, int tagNumber, InputStream contentStream) {
        this._baseTag = baseTag;
        this._tagNumber = tagNumber;
        this._aIn = new ASN1StreamParser(contentStream);
    }

    int getTagNumber() {
        return this._tagNumber;
    }

    int getBaseTag() {
        return this._baseTag;
    }

    DEREncodable readObject() throws IOException {
        return this._aIn.readObject();
    }

    ASN1EncodableVector readVector() throws IllegalStateException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        try {
            DEREncodable obj;
            while ((obj = this.readObject()) != null) {
                v.add(obj.getDERObject());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return v;
    }
}

