/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DERBitString;
import org.gudy.bouncycastle.asn1.DERInputStream;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERObjectIdentifier;
import org.gudy.bouncycastle.asn1.DEROctetString;
import org.gudy.bouncycastle.asn1.DEROutputStream;
import org.gudy.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gudy.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gudy.bouncycastle.asn1.x9.X962NamedCurves;
import org.gudy.bouncycastle.asn1.x9.X962Parameters;
import org.gudy.bouncycastle.asn1.x9.X9ECParameters;
import org.gudy.bouncycastle.asn1.x9.X9ECPoint;
import org.gudy.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.gudy.bouncycastle.crypto.params.ECDomainParameters;
import org.gudy.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.gudy.bouncycastle.jce.interfaces.ECPublicKey;
import org.gudy.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.gudy.bouncycastle.jce.spec.ECParameterSpec;
import org.gudy.bouncycastle.jce.spec.ECPublicKeySpec;
import org.gudy.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;

    JCEECPublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        this.ecSpec = spec.getParams();
    }

    JCEECPublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
    }

    JCEECPublicKey(String algorithm, ECPublicKey key) {
        this.q = key.getQ();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParams();
    }

    JCEECPublicKey(String algorithm, ECPoint q, ECParameterSpec ecSpec) {
        this.algorithm = algorithm;
        this.q = q;
        this.ecSpec = ecSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo info) {
        X962Parameters params = new X962Parameters((DERObject)info.getAlgorithmId().getParameters());
        if (params.isNamedCurve()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
            X9ECParameters ecP = X962NamedCurves.getByOID(oid);
            this.ecSpec = new ECNamedCurveParameterSpec(X962NamedCurves.getName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        } else {
            X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
            this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        }
        DERBitString bits = info.getPublicKeyData();
        byte[] data = bits.getBytes();
        ASN1OctetString key = new DEROctetString(data);
        if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3)) {
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(data);
                DERInputStream dIn = new DERInputStream(bIn);
                key = (ASN1OctetString)dIn.readObject();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        X9ECPoint derQ = new X9ECPoint(this.ecSpec.getCurve(), key);
        this.q = derQ.getPoint();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X962Parameters params = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            params = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()));
        } else {
            X9ECParameters ecP = new X9ECParameters(this.ecSpec.getCurve(), this.ecSpec.getG(), this.ecSpec.getN(), this.ecSpec.getH(), this.ecSpec.getSeed());
            params = new X962Parameters(ecP);
        }
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(this.getQ()).getDERObject();
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params.getDERObject()), p.getOctets());
        try {
            dOut.writeObject(info);
            dOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return bOut.toByteArray();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = System.getProperty("line.separator");
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }
}

