/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.BERInputStream;
import org.gudy.bouncycastle.asn1.DERInputStream;
import org.gudy.bouncycastle.asn1.DERObjectIdentifier;
import org.gudy.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.gudy.bouncycastle.asn1.pkcs.SignedData;
import org.gudy.bouncycastle.asn1.x509.CertificateList;
import org.gudy.bouncycastle.asn1.x509.X509CertificateStructure;
import org.gudy.bouncycastle.jce.provider.PKIXCertPath;
import org.gudy.bouncycastle.jce.provider.X509CRLObject;
import org.gudy.bouncycastle.jce.provider.X509CertificateObject;
import org.gudy.bouncycastle.util.encoders.Base64;

public class JDKX509CertificateFactory
extends CertificateFactorySpi {
    private SignedData sData = null;
    private int sDataObjectCount = 0;

    private String readLine(InputStream in) throws IOException {
        int c;
        StringBuilder l = new StringBuilder();
        while ((c = in.read()) != 10 && c >= 0) {
            if (c == 13) continue;
            l.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return l.toString();
    }

    private Certificate readDERCertificate(InputStream in) throws IOException {
        DERInputStream dIn = new DERInputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(seq));
    }

    private Certificate readPKCS7Certificate(InputStream in) throws IOException {
        BERInputStream dIn = new BERInputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(seq));
    }

    private Certificate readPEMCertificate(InputStream in) throws IOException {
        String line;
        StringBuilder pemBuf = new StringBuilder();
        while ((line = this.readLine(in)) != null) {
            if (line.equals("-----BEGIN CERTIFICATE-----") || line.equals("-----BEGIN X509 CERTIFICATE-----")) break;
        }
        while ((line = this.readLine(in)) != null) {
            if (line.equals("-----END CERTIFICATE-----") || line.equals("-----END X509 CERTIFICATE-----")) break;
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(pemBuf.toString()));
            return this.readDERCertificate(bIn);
        }
        return null;
    }

    private CRL readDERCRL(InputStream in) throws IOException {
        DERInputStream dIn = new DERInputStream(in);
        return new X509CRLObject(new CertificateList((ASN1Sequence)dIn.readObject()));
    }

    private CRL readPEMCRL(InputStream in) throws IOException {
        String line;
        StringBuilder pemBuf = new StringBuilder();
        while ((line = this.readLine(in)) != null) {
            if (line.equals("-----BEGIN CRL-----") || line.equals("-----BEGIN X509 CRL-----")) break;
        }
        while ((line = this.readLine(in)) != null) {
            if (line.equals("-----END CRL-----") || line.equals("-----END X509 CRL-----")) break;
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(pemBuf.toString()));
            return this.readDERCRL(bIn);
        }
        return null;
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        int tag;
        block7: {
            if (this.sData != null && this.sDataObjectCount != this.sData.getCertificates().size()) {
                return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
            }
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            try {
                in.mark(10);
                tag = in.read();
                if (tag != -1) break block7;
                return null;
            }
            catch (IOException e) {
                throw new CertificateException(e.toString());
            }
        }
        if (tag != 48) {
            in.reset();
            return this.readPEMCertificate(in);
        }
        if (in.read() == 128) {
            in.reset();
            return this.readPKCS7Certificate(in);
        }
        in.reset();
        return this.readDERCertificate(in);
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        Certificate cert;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while ((cert = this.engineGenerateCertificate(inStream)) != null) {
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream);
        }
        try {
            inStream.mark(10);
            if (inStream.read() != 48) {
                inStream.reset();
                return this.readPEMCRL(inStream);
            }
            inStream.reset();
            return this.readDERCRL(inStream);
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        return null;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        return new PKIXCertPath(inStream, encoding);
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        for (Object obj : certificates) {
            if (obj == null || obj instanceof X509Certificate) continue;
            throw new CertificateException("list contains none X509Certificate object while creating CertPath\n" + obj.toString());
        }
        return new PKIXCertPath(certificates);
    }
}

