/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.util.OS;
import dorkbox.util.SwingUtil;
import dorkbox.util.jna.linux.GtkTheme;
import dorkbox.util.jna.windows.User32;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JMenuItem;

public class SizeAndScalingUtil {
    static int TRAY_SIZE = 0;
    static int TRAY_MENU_SIZE = 0;

    public static int getMacOSScaleFactor() {
        Object obj;
        if (OS.javaVersion == 6 && (obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor")) instanceof Float) {
            if (((Float)obj).floatValue() > 1.9f) {
                return 2;
            }
            return 1;
        }
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object scale = field.get(graphicsDevice);
                if (scale instanceof Integer) {
                    return (Integer)scale;
                }
            }
        }
        catch (Exception field) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(img);
        AffineTransform transform = g.getFontRenderContext().getTransform();
        return (int)transform.getScaleX();
    }

    public static int getTrayImageSize() {
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = OS.isLinux() ? GtkTheme.getIndicatorSize() : (OS.isMacOsX() ? SizeAndScalingUtil.getMacOSScaleFactor() * 18 : (OS.isWindows() ? User32.User32.GetSystemMetrics(50) : 32));
        }
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = 32;
        }
        return TRAY_SIZE;
    }

    public static int getMenuImageSize(Class<? extends Tray> trayType) {
        if (TRAY_MENU_SIZE == 0) {
            if (OS.isMacOsX()) {
                TRAY_MENU_SIZE = SizeAndScalingUtil.getMacOSScaleFactor() * 18;
            } else if (trayType == _SwingTray.class || trayType == _WindowsNativeTray.class) {
                if (OS.isWindows()) {
                    TRAY_MENU_SIZE = User32.User32.GetSystemMetrics(72) - 1;
                } else {
                    final AtomicInteger iconSize = new AtomicInteger();
                    SwingUtil.invokeAndWaitQuietly(new Runnable(){

                        @Override
                        public void run() {
                            JMenuItem jMenuItem = new JMenuItem();
                            if (SystemTray.SWING_UI != null) {
                                jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                            }
                            int height = SwingUtil.getLargestIconHeightForButton(jMenuItem);
                            iconSize.set(height);
                        }
                    });
                    TRAY_MENU_SIZE = iconSize.get();
                }
            } else {
                TRAY_MENU_SIZE = OS.isLinux() ? GtkTheme.getMenuEntryImageSize() : 16;
            }
        }
        return TRAY_MENU_SIZE;
    }
}

