/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.windows;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import dorkbox.util.jna.windows.GDI32;
import dorkbox.util.jna.windows.GetLastErrorException;
import dorkbox.util.jna.windows.HBITMAPWrap;
import dorkbox.util.jna.windows.User32;
import dorkbox.util.jna.windows.structs.ICONINFO;

public class HICONWrap
extends WinDef.HICON {
    private HBITMAPWrap bm;

    static WinDef.HICON createIconIndirect(WinDef.HBITMAP bm) {
        ICONINFO info = new ICONINFO();
        info.IsIcon = true;
        info.MaskBitmap = bm;
        info.ColorBitmap = bm;
        WinDef.HICON hicon = User32.User32.CreateIconIndirect(info);
        if (hicon == null) {
            throw new GetLastErrorException();
        }
        return hicon;
    }

    public HICONWrap() {
    }

    public HICONWrap(Pointer p) {
        super(p);
    }

    public HICONWrap(HBITMAPWrap bm) {
        this.bm = bm;
        this.setPointer(HICONWrap.createIconIndirect(bm).getPointer());
    }

    public void close() {
        this.bm.close();
        if (Pointer.nativeValue((Pointer)this.getPointer()) != 0L) {
            GDI32.DeleteObject((WinNT.HANDLE)this);
            this.setPointer(new Pointer(0L));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

