/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.windows;

import com.sun.jna.Callback;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import dorkbox.util.jna.windows.GetLastErrorException;
import dorkbox.util.jna.windows.Listener;
import dorkbox.util.jna.windows.MSG;
import dorkbox.util.jna.windows.User32;
import dorkbox.util.jna.windows.WNDPROC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsEventDispatch
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WindowsEventDispatch.class);
    private static final String NAME = "WindowsEventDispatch";
    public static final int WM_TASKBARCREATED = User32.User32.RegisterWindowMessage(new WString("TaskbarCreated"));
    public static final int WM_COMMAND = 273;
    public static final int WM_SHELLNOTIFY = 1025;
    public static final int WM_MEASUREITEM = 44;
    public static final int WM_DRAWITEM = 43;
    public static final int MF_POPUP = 16;
    private static final WindowsEventDispatch edt = new WindowsEventDispatch();
    private static final Map<Integer, List<Listener>> messageIDs = new HashMap<Integer, List<Listener>>();
    private static final Object lock = new Object();
    private static int referenceCount = 0;
    private Thread dispatchThread;
    private WNDPROC WndProc;
    private volatile WinDef.HWND hWnd;

    private WindowsEventDispatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = lock;
        synchronized (object) {
            int ref = referenceCount++;
            if (ref == 0) {
                edt.start_();
            }
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = lock;
        synchronized (object) {
            if (--referenceCount == 0) {
                edt.stop_();
            }
        }
    }

    public static WinDef.HWND get() {
        return WindowsEventDispatch.edt.hWnd;
    }

    private void start_() {
        this.dispatchThread = new Thread((Runnable)this, NAME);
        this.dispatchThread.start();
    }

    private void stop_() {
        User32.User32.SendMessage(this.hWnd, 18, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L));
        try {
            if (!Thread.currentThread().equals(this.dispatchThread)) {
                this.dispatchThread.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(int messageId, Listener listener) {
        Map<Integer, List<Listener>> map = messageIDs;
        synchronized (map) {
            List<Listener> listeners = messageIDs.get(messageId);
            if (listeners == null) {
                listeners = new ArrayList<Listener>();
                messageIDs.put(messageId, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(Listener listener) {
        Map<Integer, List<Listener>> map = messageIDs;
        synchronized (map) {
            for (Map.Entry<Integer, List<Listener>> entry : messageIDs.entrySet()) {
                List<Listener> value = entry.getValue();
                if (!value.remove(listener)) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.WndProc = new WNDPROC(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WinDef.LRESULT callback(WinDef.HWND hWnd, int msg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                ArrayList listeners = null;
                Map map = messageIDs;
                synchronized (map) {
                    listeners = (ArrayList)messageIDs.get(msg);
                    if (listeners != null) {
                        listeners = new ArrayList(listeners);
                    }
                }
                if (listeners != null) {
                    for (Listener listener : listeners) {
                        if (listener == null) continue;
                        try {
                            listener.run(hWnd, wParam, lParam);
                        }
                        catch (Exception e) {
                            logger.error("Error during listener execution.", e);
                        }
                    }
                }
                return User32.User32.DefWindowProc(hWnd, msg, wParam, lParam);
            }
        };
        this.hWnd = User32.User32.CreateWindowEx(0, "STATIC", NAME, 0, 0, 0, 0, 0, null, null, null, null);
        if (this.hWnd == null) {
            throw new GetLastErrorException();
        }
        User32.User32.SetWindowLong(this.hWnd, -4, (Callback)this.WndProc);
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
        MSG msg = new MSG();
        while (User32.User32.GetMessage(msg, null, 0, 0)) {
            User32.User32.TranslateMessage(msg);
            User32.User32.DispatchMessage(msg);
        }
        if (this.hWnd != null) {
            if (!User32.User32.DestroyWindow(this.hWnd)) {
                throw new GetLastErrorException();
            }
            this.hWnd = null;
        }
    }
}

