/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.IFilterFactoryDelegate;
import org.jacorb.notification.filter.MappingFilterImpl;
import org.jacorb.notification.filter.etcl.ETCLFilter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.slf4j.Logger;

public class DefaultFilterFactoryDelegate
implements IFilterFactoryDelegate,
Disposable {
    private final List availableFilters_ = new ArrayList();
    private final MutablePicoContainer filterPico_;
    private final ORB orb_;
    private final Logger logger_;
    private final IContainer container_;
    private final ComponentAdapterFactory componentAdapterFactory_;

    public DefaultFilterFactoryDelegate(IContainer container, Configuration config, ComponentAdapterFactory componentAdapterFactory) {
        MutablePicoContainer parent;
        this.componentAdapterFactory_ = componentAdapterFactory;
        this.container_ = container;
        this.filterPico_ = parent = container.getContainer();
        this.orb_ = (ORB)parent.getComponentInstanceOfType(ORB.class);
        this.logger_ = LogUtil.getLogger(config, this.getClass().getName());
        this.loadFilterPlugins(config);
    }

    public DefaultFilterFactoryDelegate(IContainer container, Configuration config) {
        this(container, config, (ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory());
    }

    public void dispose() {
        this.container_.destroy();
    }

    private void loadFilterPlugins(Configuration conf) {
        Configuration config = conf;
        ComponentAdapter etclCA = this.componentAdapterFactory_.createComponentAdapter((Object)"EXTENDED_TCL", ETCLFilter.class, null);
        this.filterPico_.registerComponent(etclCA);
        this.availableFilters_.add("EXTENDED_TCL");
        for (String key : config.getAttributeNamesWithPrefix("jacorb.notification.filter.plugin")) {
            String _clazzName = null;
            try {
                String _grammar = key.substring("jacorb.notification.filter.plugin".length() + 1);
                this.logger_.info("Loading Filterplugin for Grammar: " + _grammar);
                _clazzName = conf.getAttribute(key);
                Class _clazz = ObjectUtil.classForName((String)_clazzName);
                ComponentAdapter customCA = this.componentAdapterFactory_.createComponentAdapter((Object)_grammar, _clazz, null);
                this.filterPico_.registerComponent(customCA);
                this.availableFilters_.add(_grammar);
            }
            catch (ConfigurationException e) {
                this.logger_.error("Unable to access attribute: " + key, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.logger_.error("Property " + key + ": Unable to load FilterPlugin " + _clazzName + ". The FilterPlugin will not be available.", (Throwable)e);
            }
        }
    }

    private String getAvailableConstraintLanguages() {
        Iterator i = this.availableFilters_.iterator();
        StringBuffer b = new StringBuffer((String)i.next());
        while (i.hasNext()) {
            b.append(", ");
            b.append(i.next());
        }
        return b.toString();
    }

    @Override
    public AbstractFilter create_filter_servant(String grammar) throws InvalidGrammar {
        AbstractFilter _filterServant = (AbstractFilter)this.filterPico_.getComponentInstance((Object)grammar);
        if (_filterServant == null) {
            this.logger_.error("unable to create FilterServant as grammar " + grammar + " is unknown");
            throw new InvalidGrammar("Constraint Language '" + grammar + "' is not supported. Supported are: " + this.getAvailableConstraintLanguages());
        }
        return _filterServant;
    }

    @Override
    public MappingFilterImpl create_mapping_filter_servant(Configuration config, String grammar, Any any) throws InvalidGrammar {
        AbstractFilter _filter = this.create_filter_servant(grammar);
        return new MappingFilterImpl(this.orb_, config, _filter, any);
    }
}

