/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx.mx4j;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import org.jacorb.notification.ConsoleMain;
import org.jacorb.notification.jmx.JMXManageableMBeanProvider;
import org.jacorb.notification.jmx.mx4j.MX4JCOSNotificationService;
import org.jacorb.notification.jmx.mx4j.MX4JCOSNotificationServiceMBean;
import org.jacorb.orb.rmi.PortableRemoteObjectDelegateImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.slf4j.Logger;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.jmx.WrapperManagerMBean;

public class JMXMain
implements WrapperListener {
    public static final String DEFAULT_DOMAIN = "NotificationService";
    private static boolean sUseHTTPConnector = false;
    private static boolean sUseMX4J;
    private ObjectName notificationServiceName_;
    private final List connectors_ = new ArrayList();
    private ORB orb_;
    private MBeanServer mbeanServer_;
    private Logger logger_;

    private JMXMain() {
    }

    private void stopConnectors() {
        for (ObjectName name : this.connectors_) {
            try {
                this.mbeanServer_.invoke(name, "stop", null, null);
            }
            catch (Exception e) {
                this.logger_.warn("Unable to stop Connnector " + name, (Throwable)e);
            }
        }
    }

    private void startHTTPConnector() throws Exception {
        ObjectName _connectorName = new ObjectName("connectors:protocol=http");
        this.mbeanServer_.createMBean("mx4j.tools.adaptor.http.HttpAdaptor", _connectorName, null);
        this.mbeanServer_.setAttribute(_connectorName, new Attribute("Port", new Integer(8001)));
        this.mbeanServer_.setAttribute(_connectorName, new Attribute("Host", "localhost"));
        this.mbeanServer_.invoke(_connectorName, "start", null, null);
        ObjectName _processorName = new ObjectName("Server:name=XSLTProcessor");
        this.mbeanServer_.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", _processorName, null);
        this.mbeanServer_.setAttribute(_connectorName, new Attribute("ProcessorName", _processorName));
        this.connectors_.add(_connectorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIIOPConnector() throws Exception, IOException {
        JMXServiceURL _serviceURL = new JMXServiceURL("service:jmx:iiop://localhost/jndi/COSNotification");
        HashMap<String, String> _environment = new HashMap<String, String>();
        _environment.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        Object _nameService = this.orb_.resolve_initial_references("NameService");
        String _nameServiceIOR = this.orb_.object_to_string(_nameService);
        _environment.put("java.naming.provider.url", _nameServiceIOR);
        _environment.put("java.naming.corba.orb", (String)this.orb_);
        InitialContext context = new InitialContext(new Hashtable(_environment));
        try {
            context.unbind("COSNotification");
        }
        finally {
            context.close();
        }
        JMXConnectorServer _connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(_serviceURL, _environment, this.mbeanServer_);
        ObjectName _connectorServerName = ObjectName.getInstance("connectors:protocol=iiop");
        this.mbeanServer_.registerMBean(_connectorServer, _connectorServerName);
        _connectorServer.start();
        this.connectors_.add(_connectorServerName);
    }

    public Integer start(String[] args) {
        try {
            this.initORB(args);
            this.notificationServiceName_ = ObjectName.getInstance("NotificationService:type=EventChannelFactory");
            this.mbeanServer_ = ManagementFactory.getPlatformMBeanServer();
            this.registerNotificationService(args);
            this.registerWrapperManager();
            this.startIIOPConnector();
            if (sUseHTTPConnector) {
                this.startHTTPConnector();
            }
            return null;
        }
        catch (Exception e) {
            if (this.logger_ != null) {
                this.logger_.error("Unable to Start Service", (Throwable)e);
            }
            WrapperManager.log((int)6, (String)("Unable to Start Service" + e));
            this.stopConnectors();
            this.orb_.shutdown(true);
            throw new RuntimeException(e);
        }
    }

    private void registerNotificationService(String[] args) throws NotCompliantMBeanException, InstanceAlreadyExistsException, InstanceNotFoundException, MBeanException, ReflectionException {
        MX4JCOSNotificationService _notificationService = new MX4JCOSNotificationService(this.orb_, this.mbeanServer_, new JMXManageableMBeanProvider(DEFAULT_DOMAIN), args);
        StandardMBean _mbean = new StandardMBean(_notificationService, MX4JCOSNotificationServiceMBean.class);
        this.mbeanServer_.registerMBean(_mbean, this.notificationServiceName_);
        this.mbeanServer_.invoke(this.notificationServiceName_, "start", null, null);
    }

    private void initORB(String[] args) throws InvalidName, AdapterInactive {
        Properties _props = ConsoleMain.parseProperties(args);
        this.orb_ = ORB.init((String[])args, (Properties)_props);
        PortableRemoteObjectDelegateImpl.setORB((ORB)this.orb_);
        this.logger_ = ((org.jacorb.orb.ORB)this.orb_).getConfiguration().getLogger(this.getClass().getName());
        Thread _orbRunner = new Thread("ORB-Thread"){

            @Override
            public void run() {
                JMXMain.this.orb_.run();
            }
        };
        POA _poa = POAHelper.narrow((Object)this.orb_.resolve_initial_references("RootPOA"));
        _poa.the_POAManager().activate();
        _orbRunner.start();
    }

    public int stop(int code) {
        try {
            this.mbeanServer_.invoke(this.notificationServiceName_, "stop", null, null);
            this.mbeanServer_.unregisterMBean(this.notificationServiceName_);
            this.stopConnectors();
            this.orb_.shutdown(true);
        }
        catch (Exception e) {
            this.logger_.error("Error while stopping Service", (Throwable)e);
            WrapperManager.log((int)5, (String)("Unable to Stop Service" + e));
            return 1;
        }
        return 0;
    }

    public void controlEvent(int event) {
        if (WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        if (event == 200 || event == 201 || event == 203) {
            WrapperManager.stop((int)0);
        }
    }

    private void registerWrapperManager() throws JMException {
        if (!WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        WrapperManager.log((int)2, (String)"Registering WrapperManager MBean");
        ObjectName wrapperManagerName = ObjectName.getInstance("NotificationService:service=WrapperManager");
        StandardMBean wrapperManagerBean = new StandardMBean(new org.tanukisoftware.wrapper.jmx.WrapperManager(), WrapperManagerMBean.class);
        this.mbeanServer_.registerMBean(wrapperManagerBean, wrapperManagerName);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        if (list.remove("-mx4j")) {
            sUseMX4J = true;
            System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        }
        if (list.remove("-mx4j:http") && sUseMX4J) {
            sUseHTTPConnector = true;
        }
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", PortableRemoteObjectDelegateImpl.class.getName());
        JMXMain main = new JMXMain();
        WrapperManager.start((WrapperListener)main, (String[])list.toArray(new String[list.size()]));
    }
}

