/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import utilities.ExecRunner;
import utilities.ProgressBarOutputStream;
import utilities.ProgressStatusWorker;

public class PackageStatusChecker
extends ExecRunner {
    private String packageName;
    private String rootDirectory;
    private String currentVersion;

    public PackageStatusChecker(String pkgName, String rootDir, ProgressStatusWorker progressStatus) {
        super(new ProgressBarOutputStream(progressStatus.getProgressBar()));
        this.packageName = pkgName;
        this.rootDirectory = rootDir;
        this.createCheckPackageCommand();
    }

    private void createCheckPackageCommand() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add("/usr/bin/pacman");
        if (!this.rootDirectory.isEmpty()) {
            commandArgs.add("-r");
            commandArgs.add(this.rootDirectory);
        }
        commandArgs.add("-Ss");
        commandArgs.add(this.packageName);
        this.addExecCommand(commandArgs);
    }

    public PACKAGE_STATUS getPackageStatus() {
        this.execCommands();
        String pacmanOut = this.getOutputStream().toString();
        if (pacmanOut.isEmpty()) {
            return PACKAGE_STATUS.PKG_UNAVAILABLE;
        }
        int vStart = pacmanOut.indexOf(" ");
        int vEnd = pacmanOut.indexOf(" ", vStart + 1);
        this.currentVersion = pacmanOut.substring(vStart, vEnd).trim();
        if (pacmanOut.contains("[installed]")) {
            return PACKAGE_STATUS.PKG_INSTALLED;
        }
        return PACKAGE_STATUS.PKG_NOTINSTALLED;
    }

    public String getPackageVersion() {
        return this.currentVersion;
    }

    public static enum PACKAGE_STATUS {
        PKG_INSTALLED,
        PKG_UNAVAILABLE,
        PKG_NOTINSTALLED;

    }
}

