/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.UnitSymbolPackage.EUnitSymbol;
import com.bbn.openmap.corba.CSpecialist.UnitSymbolPackage.USF_update;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public class JUnit
extends OMGraphicAdapter
implements ImageObserver,
JObjectHolder {
    protected transient EComp object = null;
    EUnitSymbol eunit = null;
    Point point1;
    ImageIcon symbol_;
    ImageIcon echelon_;
    float total_height = 0.0f;
    float total_width = 0.0f;

    public JUnit(EUnitSymbol eunit) {
        JGraphic.fillOMGraphicParams((OMGraphic)this, eunit.egraphic);
        this.eunit = eunit;
    }

    public void setObject(EComp aObject) {
        this.object = aObject;
    }

    public EComp getObject() {
        return this.object;
    }

    public boolean generate(Projection proj) {
        this.needToRegenerate = false;
        switch (this.renderType) {
            case 2: {
                this.point1 = new Point(this.eunit.p1.x, this.eunit.p1.y);
                break;
            }
            case 3: {
                this.point1 = (Point)proj.forward(this.eunit.ll1.lat, this.eunit.ll1.lon, (Point2D)new Point());
                this.point1.x += this.eunit.p1.x;
                this.point1.y += this.eunit.p1.y;
                break;
            }
            case 1: {
                this.point1 = (Point)proj.forward(this.eunit.ll1.lat, this.eunit.ll1.lon, (Point2D)new Point());
                break;
            }
            case 0: {
                System.err.println("JUnit.generate: invalid RenderType");
                return false;
            }
        }
        String image_path = "fmsymbols/";
        image_path = image_path + this.eunit.group;
        image_path = image_path + "/";
        image_path = image_path + this.eunit.symbol;
        image_path = image_path + ".xbm";
        this.symbol_ = new ImageIcon(image_path.toLowerCase());
        image_path = "fmsymbols/echelons/";
        image_path = image_path + this.eunit.echelon;
        image_path = image_path + ".xbm";
        this.echelon_ = new ImageIcon(image_path.toLowerCase());
        return true;
    }

    public void render(Graphics g) {
        if (g == null) {
            System.err.println("JUnit.render: can't render null Graphics");
            return;
        }
        g.setColor(this.getDisplayColor());
        int ech_x = this.point1.x + this.symbol_.getIconWidth() / 2 - this.echelon_.getIconWidth() / 2;
        if (!this.eunit.echelon.equals("")) {
            g.drawImage(this.echelon_.getImage(), ech_x, this.point1.y, this);
            this.total_height = this.echelon_.getIconHeight();
            this.total_width = this.echelon_.getIconWidth();
        }
        int sym_y = this.point1.y + this.echelon_.getIconHeight();
        if (!this.eunit.symbol.equals("")) {
            g.drawImage(this.symbol_.getImage(), this.point1.x, sym_y, this);
            this.total_height += (float)this.symbol_.getIconHeight();
            if ((float)this.symbol_.getIconWidth() > this.total_width) {
                this.total_width = this.symbol_.getIconWidth();
            }
        }
        if (!this.eunit.bottom1.equals("")) {
            int x = this.point1.x + this.symbol_.getIconWidth() / 2;
            int y = this.point1.y + this.symbol_.getIconHeight() + this.echelon_.getIconHeight();
            Font font = new Font("Helvetica", 0, 10);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.eunit.bottom1);
            int h = fm.getHeight();
            this.total_height += (float)h;
            if ((float)w > this.total_width) {
                this.total_width = w;
            }
            g.drawString(this.eunit.bottom1, x -= w / 2, y += h);
        }
    }

    public float distance(int x, int y) {
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            System.err.println("JUnit.distance(): not projected!");
            return distance;
        }
        if (this.point1 == null) {
            System.err.println("JUnit.distance(): invalid Raster location");
            return distance;
        }
        if (x >= this.point1.x && (float)x <= (float)this.point1.x + this.total_width && y >= this.point1.y && (float)y <= (float)this.point1.y + this.total_height) {
            return 0.0f;
        }
        distance = Math.max(Math.max((float)(this.point1.x - x), (float)x - ((float)this.point1.x + this.total_width)), Math.max((float)(this.point1.y - y), (float)y - ((float)this.point1.y + this.total_height)));
        return distance;
    }

    public void update(GF_update update) {
        JGraphic.update(this, update);
    }

    public void update(USF_update update) {
        this.setNeedToRegenerate(true);
        switch (update.discriminator().value()) {
            case 1: {
                LLPoint ll = update.ll1();
                this.eunit.ll1.lat = ll.lat;
                this.eunit.ll1.lon = ll.lon;
                break;
            }
            case 0: {
                XYPoint pt = update.p1();
                this.eunit.p1.x = pt.x;
                this.eunit.p1.y = pt.y;
                break;
            }
            case 2: {
                this.eunit.group = update.group();
                break;
            }
            case 3: {
                this.eunit.symbol = update.symbol();
                break;
            }
            case 4: {
                this.eunit.echelon = update.echelon();
                break;
            }
            case 5: {
                this.eunit.left1 = update.left1();
                break;
            }
            case 6: {
                this.eunit.left2 = update.left2();
                break;
            }
            case 7: {
                this.eunit.left3 = update.left3();
                break;
            }
            case 8: {
                this.eunit.left4 = update.left4();
                break;
            }
            case 9: {
                this.eunit.right1 = update.right1();
                break;
            }
            case 10: {
                this.eunit.right2 = update.right2();
                break;
            }
            case 11: {
                this.eunit.right3 = update.right3();
                break;
            }
            case 12: {
                this.eunit.right4 = update.right4();
                break;
            }
            case 13: {
                this.eunit.top1 = update.top1();
                break;
            }
            case 14: {
                String bottom1;
                this.eunit.bottom1 = bottom1 = update.bottom1();
                break;
            }
            case 15: {
                this.eunit.nom_size = update.nom_size();
                break;
            }
            case 16: {
                this.eunit.min_size = update.min_size();
                break;
            }
            case 17: {
                short max_size;
                this.eunit.max_size = max_size = update.max_size();
                break;
            }
            case 18: {
                this.eunit.scale = update.scale();
                break;
            }
            case 19: {
                this.eunit.is_hq = update.is_hq();
                break;
            }
            case 20: {
                this.eunit.rotate = update.rotate();
                break;
            }
            default: {
                System.err.println("JUnit.update: invalid unit symbol update");
                this.setNeedToRegenerate(false);
            }
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

