/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Orthographic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;

public class MakeProjection {
    Projection p;
    public static final short MercatorType = 0;
    public static final short CADRGType = 1;
    public static final short OrthographicType = 2;

    public MakeProjection(CProjection mp) {
        this.p = MakeProjection.getProjection(mp);
    }

    public Projection getProj() {
        return this.p;
    }

    public static Projection getProjection(CProjection mp) {
        CADRG p;
        LatLonPoint.Double center = new LatLonPoint.Double((double)mp.center.lat, (double)mp.center.lon);
        switch (mp.kind) {
            case 1: {
                p = new CADRG((LatLonPoint)center, (float)mp.scale, (int)mp.width, (int)mp.height);
                break;
            }
            case 2: {
                p = new Orthographic((LatLonPoint)center, (float)mp.scale, (int)mp.width, (int)mp.height);
                break;
            }
            default: {
                p = new Mercator((LatLonPoint)center, (float)mp.scale, (int)mp.width, (int)mp.height);
            }
        }
        return p;
    }

    public static short getProjectionType(Projection mp) {
        if (mp instanceof CADRG) {
            return 1;
        }
        if (mp instanceof Orthographic) {
            return 2;
        }
        return 0;
    }
}

