/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.corbaImage;

import com.bbn.openmap.image.MapRequestHandler;
import com.bbn.openmap.plugin.corbaImage.corbaImageServer.ServerPOA;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.corba.CORBASupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CorbaImageServer
extends ServerPOA {
    protected static String iorfile = null;
    protected static String naming = null;
    public static final String ClassPropertyName = "class";
    protected MapRequestHandler map = null;

    public CorbaImageServer() {
        this("Default");
    }

    public CorbaImageServer(String name) {
    }

    public byte[] getImage(String request) {
        Debug.message((String)"cis", (String)"CorbaImageServer: handling subframe request for client");
        if (this.map == null) {
            Debug.error((String)"CorbaImageServer not configured for getting data!  No data source");
            return new byte[0];
        }
        byte[] imageData = new byte[]{};
        try {
            imageData = this.map.handleRequest(request);
        }
        catch (IOException ioe) {
            Debug.error((String)("CorbaImageServer: IOException processing: " + request));
        }
        if (imageData == null) {
            Debug.message((String)"cis", (String)"CorbaImageServer: something went wrong with image creation!");
            imageData = new byte[]{};
        }
        Debug.message((String)"cis", (String)("CorbaImageServer: returning image of length: " + imageData.length));
        return imageData;
    }

    public void start(String[] args) {
        CORBASupport cs = new CORBASupport();
        if (args != null) {
            this.parseArgs(args);
        }
        cs.start(this, args, iorfile, naming);
    }

    public void parseArgs(String[] args) {
        Properties properties = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-ior")) {
                iorfile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-name")) {
                naming = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                this.printHelp();
                continue;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                Debug.put((String)"cis");
                Debug.put((String)"imageserver");
                Debug.put((String)"formatter");
                continue;
            }
            if (args[i].equalsIgnoreCase("-properties")) {
                String propLocation = null;
                propLocation = args[++i];
                Debug.message((String)"cis", (String)("CorbaImageServer getting properties from " + propLocation));
                properties = this.loadProps(propLocation);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-h")) continue;
            this.printHelp();
        }
        if (iorfile == null && naming == null) {
            Debug.error((String)"CorbaImageServer: IOR file and name service name are null!  Use `-ior' or '-name' flag!");
            System.exit(-1);
        }
        if (properties == null) {
            Debug.error((String)"CorbaImageServer: No properties file for server specified!  Use `-properties' flag and a properties file suitable for MapRequestHandler!");
            System.exit(-1);
        } else {
            try {
                this.map = new MapRequestHandler(properties);
                Debug.output((String)("CorbaImageServer: CorbaImageServer!  Running with properties => " + properties));
            }
            catch (IOException ioe) {
                Debug.error((String)"CorbaImageServer caught IOException while loading properties into the MapRequestHandler.");
                this.map = null;
            }
        }
    }

    public Properties loadProps(String file) {
        File propsFile = new File(file);
        Properties props = new Properties();
        try {
            FileInputStream propsStream = new FileInputStream(propsFile);
            props.load(propsStream);
        }
        catch (FileNotFoundException e) {
            System.err.println("CorbaImageServer did not find properties file: \"" + file + "\"");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Caught IO Exception reading configuration file \"" + propsFile + "\"");
            e.printStackTrace();
            System.exit(1);
        }
        return props;
    }

    public void printHelp() {
        Debug.output((String)"usage: java CorbaImageServer [-ior <file> || -name <NAME>] -properties \"<path to properties file>\"");
        System.exit(1);
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        CorbaImageServer srv = new CorbaImageServer("CorbaImageServer");
        srv.start(args);
    }
}

