/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.tools.j3d.OM3DConstants;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;

public class Camera
implements OM3DConstants {
    private Group hud_group = new Group();
    private TransformGroup root_tx_grp;
    private Transform3D location;
    private ViewPlatform platform;
    private View view;
    private DirectionalLight headlight;
    private PhysicalBody body;
    private PhysicalEnvironment env;

    public Camera() {
        this.hud_group.setCapability(14);
        this.platform = new ViewPlatform();
        this.location = new Transform3D();
        this.root_tx_grp = new TransformGroup();
        this.root_tx_grp.setCapability(18);
        this.root_tx_grp.setCapability(17);
        this.root_tx_grp.setTransform(this.location);
        this.root_tx_grp.addChild((Node)this.platform);
        this.root_tx_grp.addChild((Node)this.hud_group);
        this.headlight = new DirectionalLight();
        this.headlight.setCapability(13);
        this.headlight.setColor(White);
        this.headlight.setInfluencingBounds((Bounds)LIGHT_BOUNDS);
        this.root_tx_grp.addChild((Node)this.headlight);
        this.body = new PhysicalBody();
        this.env = new PhysicalEnvironment();
        this.view = new View();
        this.view.setBackClipDistance(10000.0);
        this.view.setPhysicalBody(this.body);
        this.view.setPhysicalEnvironment(this.env);
        this.view.attachViewPlatform(this.platform);
    }

    public void setCanvas(Canvas3D canvas) {
        this.view.addCanvas3D(canvas);
    }

    public void setLocation(Vector3f loc) {
        this.location.setTranslation(loc);
        this.root_tx_grp.setTransform(this.location);
    }

    public void setOrientation(AxisAngle4f angle) {
        this.location.setRotation(angle);
        this.root_tx_grp.setTransform(this.location);
    }

    public void addHUDObject(Node geom) {
        this.hud_group.addChild(geom);
    }

    public void setHeadLight(boolean enable) {
        this.headlight.setEnable(enable);
    }

    public Node getNode() {
        return this.root_tx_grp;
    }
}

