/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Vector3d;

public class OMKeyBehavior
extends Behavior {
    protected static final double FAST_SPEED = 2.0;
    protected static final double NORMAL_SPEED = 1.0;
    protected static final double SLOW_SPEED = 0.5;
    private TransformGroup cameraTransformGroup;
    private Transform3D transform3D;
    private Transform3D locationTransform3D;
    private Transform3D xRotLookTransform;
    private Transform3D yRotLookTransform;
    private Transform3D zRotLookTransform;
    private WakeupCondition keyCriterion;
    protected static final double TWO_PI = Math.PI * 2;
    protected double rotateXAmount = 0.19634954084936207;
    protected double rotateYAmount = 0.19634954084936207;
    protected double rotateZAmount = 0.19634954084936207;
    protected double moveRate = 0.3;
    protected double speed = 1.0;
    protected int forwardKey = 38;
    protected int backKey = 40;
    protected int leftKey = 37;
    protected int rightKey = 39;
    protected boolean DEBUG = false;
    protected Projection projection;

    public OMKeyBehavior(TransformGroup cameraTG, Projection proj) {
        this(cameraTG, proj, null);
    }

    public OMKeyBehavior(TransformGroup cameraTG, Projection proj, Vector3d initialLocation) {
        this.projection = proj;
        this.DEBUG = Debug.debugging((String)"3dkey");
        this.cameraTransformGroup = cameraTG;
        this.transform3D = new Transform3D();
        this.locationTransform3D = new Transform3D();
        this.xRotLookTransform = new Transform3D();
        this.yRotLookTransform = new Transform3D();
        this.zRotLookTransform = new Transform3D();
        this.setViewerLocation(initialLocation);
        this.setEnable(true);
    }

    public void initialize() {
        WakeupCriterion[] keyEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
        this.keyCriterion = new WakeupOr(keyEvents);
        this.wakeupOn(this.keyCriterion);
    }

    public void setViewerLocation(Vector3d initialLocation) {
        this.cameraTransformGroup.getTransform(this.locationTransform3D);
        float scale = 1.0f;
        if (initialLocation == null) {
            initialLocation = new Vector3d();
            if (this.projection != null) {
                float centerXOffset = (float)this.projection.getWidth() / 2.0f * scale;
                float centerYOffset = (float)(this.projection.getHeight() * 2) / 3.0f * scale;
                Debug.message((String)"3d", (String)("OM3DViewer with projection " + this.projection + ", setting center of scene to " + centerXOffset + ", " + centerYOffset));
                initialLocation.set((double)centerXOffset, 50.0, (double)centerYOffset);
            } else {
                initialLocation.set(0.0, 50.0, 0.0);
            }
        }
        Transform3D toMove = new Transform3D();
        toMove.set((double)scale, initialLocation);
        this.locationTransform3D.mul(toMove);
        this.cameraTransformGroup.setTransform(this.locationTransform3D);
    }

    public void processStimulus(Enumeration criteria) {
        if (this.DEBUG) {
            Debug.output((String)"OMKeyBehavior: processStimulus");
        }
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                if (event[i].getID() != 401) continue;
                this.processKeyEvent((KeyEvent)event[i]);
            }
        }
        this.wakeupOn(this.keyCriterion);
    }

    protected void processKeyEvent(KeyEvent event) {
        int keycode = event.getKeyCode();
        this.speed = event.isShiftDown() ? 2.0 : 1.0;
        if (event.isAltDown()) {
            this.altMove(keycode);
        } else if (event.isControlDown()) {
            this.controlMove(keycode);
        } else {
            this.standardMove(keycode);
        }
    }

    protected void standardMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.moveForward();
        } else if (keycode == this.backKey) {
            this.moveBackward();
        } else if (keycode == this.leftKey) {
            this.rotLeft();
        } else if (keycode == this.rightKey) {
            this.rotRight();
        }
    }

    protected void altMove(int keycode) {
        if (this.DEBUG) {
            Debug.output((String)"altMove");
        }
        if (keycode == this.forwardKey) {
            this.rotUp();
        } else if (keycode == this.backKey) {
            this.rotDown();
        } else if (keycode == this.leftKey) {
            this.moveLeft();
        } else if (keycode == this.rightKey) {
            this.moveRight();
        }
    }

    protected void controlMove(int keycode) {
        if (keycode == this.forwardKey) {
            this.moveUp();
        } else if (keycode == this.backKey) {
            this.moveDown();
        } else if (keycode == this.leftKey) {
            this.lookUp();
        } else if (keycode == this.rightKey) {
            this.lookDown();
        }
    }

    public void moveForward() {
        if (this.DEBUG) {
            Debug.output((String)"Moving forward +");
        }
        this.doMove(new Vector3d(0.0, 0.0, -this.getMovementRate()));
    }

    public void moveBackward() {
        if (this.DEBUG) {
            Debug.output((String)"Moving Backward _");
        }
        this.doMove(new Vector3d(0.0, 0.0, this.getMovementRate()));
    }

    public void moveLeft() {
        if (this.DEBUG) {
            Debug.output((String)"Moving left <");
        }
        this.doMove(new Vector3d(-this.getMovementRate(), 0.0, 0.0));
    }

    public void moveRight() {
        if (this.DEBUG) {
            Debug.output((String)"Moving right >");
        }
        this.doMove(new Vector3d(this.getMovementRate(), 0.0, 0.0));
    }

    public void moveUp() {
        if (this.DEBUG) {
            Debug.output((String)"Moving up ^");
        }
        this.doMove(new Vector3d(0.0, this.getMovementRate(), 0.0));
    }

    public void moveDown() {
        if (this.DEBUG) {
            Debug.output((String)"Moving down v ");
        }
        this.doMove(new Vector3d(0.0, -this.getMovementRate(), 0.0));
    }

    public void rotRight() {
        if (this.DEBUG) {
            Debug.output((String)"Rotating right");
        }
        this.doRotateY(this.getRotateRightAmount());
    }

    public void lookRight() {
        if (this.DEBUG) {
            Debug.output((String)"Looking right");
        }
        this.doLookY(this.getRotateRightAmount());
    }

    public void rotUp() {
        if (this.DEBUG) {
            Debug.output((String)"Rotating up");
        }
        this.doRotateX(this.getRotateUpAmount());
    }

    public void lookUp() {
        if (this.DEBUG) {
            Debug.output((String)"Looking up");
        }
        this.doLookX(this.getRotateUpAmount());
    }

    public void rotLeft() {
        if (this.DEBUG) {
            Debug.output((String)"Rotating left");
        }
        this.doRotateY(this.getRotateLeftAmount());
    }

    public void lookLeft() {
        if (this.DEBUG) {
            Debug.output((String)"Looking left");
        }
        this.doLookY(this.getRotateLeftAmount());
    }

    public void rotDown() {
        if (this.DEBUG) {
            Debug.output((String)"Rotating down");
        }
        this.doRotateX(this.getRotateDownAmount());
    }

    public void lookDown() {
        if (this.DEBUG) {
            Debug.output((String)"Looking down");
        }
        this.doLookX(this.getRotateDownAmount());
    }

    public void rollLeft() {
        if (this.DEBUG) {
            Debug.output((String)"Rolling left");
        }
        this.doRotateZ(this.getRollLeftAmount());
    }

    public void rollLookLeft() {
        if (this.DEBUG) {
            Debug.output((String)"Tilting left");
        }
        this.doLookZ(this.getRollLeftAmount());
    }

    public void rollRight() {
        if (this.DEBUG) {
            Debug.output((String)"Rolling right");
        }
        this.doRotateZ(this.getRollRightAmount());
    }

    public void rollLookRight() {
        if (this.DEBUG) {
            Debug.output((String)"Tilting right");
        }
        this.doLookZ(this.getRollRightAmount());
    }

    protected void changePosition(Transform3D toMove) {
        this.cameraTransformGroup.getTransform(this.transform3D);
        Transform3D viewTransform = new Transform3D();
        viewTransform.invert(this.xRotLookTransform);
        viewTransform.mulInverse(this.yRotLookTransform);
        viewTransform.mulInverse(this.zRotLookTransform);
        this.transform3D.mul(viewTransform);
        this.transform3D.mul(toMove);
        this.transform3D.mulInverse(viewTransform);
        this.cameraTransformGroup.setTransform(this.transform3D);
    }

    public void doRotateY(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating Y " + radians + " radians"));
        }
        Transform3D toMove = new Transform3D();
        toMove.rotY(radians);
        this.changePosition(toMove);
    }

    public void doLookY(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating view Y " + radians + " radians"));
        }
        this.cameraTransformGroup.getTransform(this.transform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotY(radians);
        this.transform3D.mul(toMove);
        this.cameraTransformGroup.setTransform(this.transform3D);
        this.yRotLookTransform.mul(toMove);
    }

    public void doRotateX(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating X " + radians + " radians"));
        }
        Transform3D toMove = new Transform3D();
        toMove.rotX(radians);
        this.changePosition(toMove);
    }

    public void doLookX(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating view X " + radians + " radians"));
        }
        this.cameraTransformGroup.getTransform(this.transform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotX(radians);
        this.transform3D.mul(toMove);
        this.cameraTransformGroup.setTransform(this.transform3D);
        this.xRotLookTransform.mul(toMove);
    }

    public void doRotateZ(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating Z " + radians + " radians"));
        }
        Transform3D toMove = new Transform3D();
        toMove.rotZ(radians);
        this.changePosition(toMove);
    }

    public void doLookZ(double radians) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: rotating view Z " + radians + " radians"));
        }
        this.cameraTransformGroup.getTransform(this.transform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotZ(radians);
        this.transform3D.mul(toMove);
        this.cameraTransformGroup.setTransform(this.transform3D);
        this.zRotLookTransform.mul(toMove);
    }

    public void doMove(Vector3d theMove) {
        if (this.DEBUG) {
            Debug.output((String)("OMKeyBehavior: moving " + theMove));
            Debug.output((String)("     transform before:\n " + this.transform3D));
        }
        Transform3D toMove = new Transform3D();
        toMove.setTranslation(theMove);
        this.changePosition(toMove);
    }

    public double getMovementRate() {
        return this.moveRate * this.speed;
    }

    public double getRollLeftAmount() {
        return this.rotateZAmount * this.speed;
    }

    public double getRollRightAmount() {
        return -this.rotateZAmount * this.speed;
    }

    public double getRotateUpAmount() {
        return this.rotateYAmount * this.speed;
    }

    public double getRotateDownAmount() {
        return -this.rotateYAmount * this.speed;
    }

    public double getRotateLeftAmount() {
        return this.rotateYAmount * this.speed;
    }

    public double getRotateRightAmount() {
        return -this.rotateYAmount * this.speed;
    }

    public void setRotateXAmount(double radians) {
        this.rotateXAmount = radians;
    }

    public void setRotateYAmount(double radians) {
        this.rotateYAmount = radians;
    }

    public void setRotateZAmount(double radians) {
        this.rotateZAmount = radians;
    }

    public void setMovementRate(double meters) {
        this.moveRate = meters;
    }

    public void setForwardKey(int key) {
        this.forwardKey = key;
    }

    public void setBackKey(int key) {
        this.backKey = key;
    }

    public void setLeftKey(int key) {
        this.leftKey = key;
    }

    public void setRightKey(int key) {
        this.rightKey = key;
    }
}

