/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapBeanRepaintPolicy;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.layer.BufferedLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ContainerEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedLayerMapBean
extends BufferedMapBean {
    private static Logger logger = Logger.getLogger(BufferedLayerMapBean.class.getName());
    protected BufferedLayer bufferedLayer;
    protected boolean DEBUG = logger.isLoggable(Level.FINE);

    public BufferedLayerMapBean() {
    }

    public BufferedLayerMapBean(boolean useThreadedNotification) {
        super(useThreadedNotification);
    }

    public void setBackgroundColor(Color color) {
        super.setBackground(color);
        this.getBufferedLayer().setBackground(color);
    }

    public void setBckgrnd(Paint paint) {
        super.setBckgrnd(paint);
        this.getBufferedLayer().setBckgrnd(paint);
    }

    public synchronized void setBufferedLayer(BufferedLayer bl) {
        this.bufferedLayer = bl;
    }

    public synchronized BufferedLayer getBufferedLayer() {
        if (this.bufferedLayer == null) {
            this.bufferedLayer = new BufferedLayer();
            this.addPropertyChangeListener(this.bufferedLayer);
            this.bufferedLayer.setName("Background Layers");
        }
        return this.bufferedLayer;
    }

    public void setMapBeanRepaintPolicy(MapBeanRepaintPolicy mbrp) {
        super.setMapBeanRepaintPolicy(mbrp);
        MapBean mb = this.getBufferedLayer().getMapBean();
        if (mb != null) {
            if (mbrp == null) {
                mb.setMapBeanRepaintPolicy(mbrp);
            } else {
                MapBeanRepaintPolicy mbrp2 = (MapBeanRepaintPolicy)mbrp.clone();
                mb.setMapBeanRepaintPolicy(mbrp2);
                mbrp2.setMap(mb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(LayerEvent evt) {
        this.setBufferDirty(true);
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            return;
        }
        if (layers == null) {
            logger.warning("layer[] is null!");
            return;
        }
        boolean oldChange = this.getDoContainerChange();
        this.setDoContainerChange(false);
        Layer[] layerArray = this;
        synchronized (this) {
            BufferedLayer bufLayer = this.getBufferedLayer();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (type == 402) {
                if (this.DEBUG) {
                    this.debugmsg("Replacing all layers");
                }
                this.removeAll();
                bufLayer.clearLayers();
                bufLayer.setProjection(this.getRotatedProjection());
                for (Layer layer : layers) {
                    if (layer == null) {
                        logger.warning("skipping null layer in layer array passed to MapBean");
                        continue;
                    }
                    if (this.DEBUG) {
                        this.debugmsg("Adding layer[" + layer.getName() + "]");
                    }
                    if (layer.getAddAsBackground()) {
                        if (this.DEBUG) {
                            logger.fine("Adding layer[" + layer.getName() + "] to background");
                        }
                        bufLayer.addLayer(layer);
                    } else {
                        this.add(layer);
                    }
                    layer.setVisible(true);
                }
                if (bufLayer.hasLayers()) {
                    this.add(bufLayer);
                }
            } else if (type == 400) {
                this.remove(bufLayer);
                if (this.DEBUG) {
                    this.debugmsg("Adding new layers");
                }
                for (Layer layer : layers) {
                    if (this.DEBUG) {
                        this.debugmsg("Adding layer[" + layer.getName() + "]");
                    }
                    layer.setVisible(true);
                    if (layer.getAddAsBackground()) {
                        if (this.DEBUG) {
                            this.debugmsg("Adding layer[" + layer.getName() + "] to background");
                        }
                        bufLayer.addLayer(layer);
                        continue;
                    }
                    this.add(layer);
                }
                if (bufLayer.hasLayers()) {
                    this.add(bufLayer);
                }
            } else if (type == 401) {
                if (this.DEBUG) {
                    this.debugmsg("Removing layers");
                }
                for (Layer layer : layers) {
                    if (this.DEBUG) {
                        this.debugmsg("Removing layer[" + layer.getName() + "]");
                    }
                    this.remove(layer);
                    bufLayer.removeLayer(layer);
                }
            }
            if (!this.layerRemovalDelayed) {
                this.purgeAndNotifyRemovedLayers();
            }
            this.setDoContainerChange(oldChange);
            this.revalidate();
            this.repaint();
            return;
        }
    }

    public void repaint(Layer layer) {
        if (this.bufferedLayer == null || this.bufferedLayer.isReadyToPaint()) {
            super.repaint(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeLayers(ContainerEvent e) {
        BufferedLayer bufLayer;
        if (!this.doContainerChange) {
            return;
        }
        Component[] comps = this.getComponents();
        int ncomponents = comps.length;
        int nBufLayerComponents = 0;
        BufferedLayerMapBean bufferedLayerMapBean = this;
        synchronized (bufferedLayerMapBean) {
            bufLayer = this.getBufferedLayer();
        }
        if (ncomponents == 0 || comps[ncomponents - 1] != bufLayer) {
            super.changeLayers(e);
            return;
        }
        Component[] bufLayers = bufLayer.getLayers();
        nBufLayerComponents = bufLayers.length;
        Layer[] newLayers = new Layer[ncomponents + nBufLayerComponents - 1];
        System.arraycopy(comps, 0, newLayers, 0, ncomponents - 1);
        System.arraycopy(bufLayers, 0, newLayers, ncomponents - 1, nBufLayerComponents);
        if (this.DEBUG) {
            this.debugmsg("changeLayers() - firing change");
        }
        this.firePropertyChange("MapBean.layers", this.currentLayers, newLayers);
        for (Layer layer : this.addedLayers) {
            layer.added(this);
        }
        this.addedLayers.removeAllElements();
        this.currentLayers = newLayers;
    }

    public void dispose() {
        if (this.bufferedLayer != null) {
            this.bufferedLayer.dispose();
        }
        super.dispose();
    }
}

