/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.ApplicationStructureAttribute;
import com.bbn.openmap.dataAccess.cgm.BeginMetafile;
import com.bbn.openmap.dataAccess.cgm.BeginPicture;
import com.bbn.openmap.dataAccess.cgm.BeginPictureBody;
import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.CharacterHeight;
import com.bbn.openmap.dataAccess.cgm.CircleElement;
import com.bbn.openmap.dataAccess.cgm.CircularArcClosedElement;
import com.bbn.openmap.dataAccess.cgm.CircularArcElement;
import com.bbn.openmap.dataAccess.cgm.ColorModel;
import com.bbn.openmap.dataAccess.cgm.ColorSelectionMode;
import com.bbn.openmap.dataAccess.cgm.ColorTable;
import com.bbn.openmap.dataAccess.cgm.DummyCommand;
import com.bbn.openmap.dataAccess.cgm.EdgeColor;
import com.bbn.openmap.dataAccess.cgm.EdgeType;
import com.bbn.openmap.dataAccess.cgm.EdgeVisibility;
import com.bbn.openmap.dataAccess.cgm.EdgeWidth;
import com.bbn.openmap.dataAccess.cgm.EdgeWidthMode;
import com.bbn.openmap.dataAccess.cgm.EllipseElement;
import com.bbn.openmap.dataAccess.cgm.EllipticalArcClosedElement;
import com.bbn.openmap.dataAccess.cgm.EllipticalArcElement;
import com.bbn.openmap.dataAccess.cgm.EndMetafile;
import com.bbn.openmap.dataAccess.cgm.EndPicture;
import com.bbn.openmap.dataAccess.cgm.FillColor;
import com.bbn.openmap.dataAccess.cgm.FontList;
import com.bbn.openmap.dataAccess.cgm.InteriorStyle;
import com.bbn.openmap.dataAccess.cgm.LineColor;
import com.bbn.openmap.dataAccess.cgm.LineType;
import com.bbn.openmap.dataAccess.cgm.LineWidth;
import com.bbn.openmap.dataAccess.cgm.LineWidthMode;
import com.bbn.openmap.dataAccess.cgm.MetafileDescription;
import com.bbn.openmap.dataAccess.cgm.MetafileElementList;
import com.bbn.openmap.dataAccess.cgm.MetafileVersion;
import com.bbn.openmap.dataAccess.cgm.PolygonElement;
import com.bbn.openmap.dataAccess.cgm.PolylineElement;
import com.bbn.openmap.dataAccess.cgm.RectangleElement;
import com.bbn.openmap.dataAccess.cgm.TextColor;
import com.bbn.openmap.dataAccess.cgm.TextElement;
import com.bbn.openmap.dataAccess.cgm.TextFontIndex;
import com.bbn.openmap.dataAccess.cgm.VDCExtent;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Command
implements Cloneable {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.cgm.Command");
    int[] args;
    int ElementClass;
    int ElementId;

    public Command(int ec, int eid, int l, DataInputStream in) throws IOException {
        this.ElementClass = ec;
        this.ElementId = eid;
        if (l != 31) {
            this.args = new int[l];
            for (int i = 0; i < l; ++i) {
                this.args[i] = in.read();
            }
            if (l % 2 != 0) {
                in.read();
            }
        } else {
            l = this.read16(in);
            this.args = new int[l];
            for (int i = 0; i < l; ++i) {
                this.args[i] = in.read();
            }
            if (l % 2 != 0) {
                in.read();
            }
        }
    }

    public int read16(DataInputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    public String toString() {
        return this.ElementClass + "," + this.ElementId + " (" + this.args.length + ")";
    }

    public String makeString() {
        if (this.args.length <= 0) {
            return "";
        }
        char[] a = new char[this.args.length - 1];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (char)this.args[i + 1];
        }
        return new String(a);
    }

    public String makeString(int k) {
        char[] a = new char[this.args[k]];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (char)this.args[k + i + 1];
        }
        return new String(a);
    }

    public int makeInt(int i) {
        return (short)(this.args[2 * i] << 8) + this.args[2 * i + 1];
    }

    public void paint(CGMDisplay d) {
    }

    public void scale(CGMDisplay d) {
    }

    public static Command read(DataInputStream in) throws IOException {
        int k = in.read();
        if (k == -1) {
            return null;
        }
        k = k << 8 | in.read();
        int ec = k >> 12;
        int eid = k >> 5 & 0x7F;
        int l = k & 0x1F;
        block0 : switch (ec) {
            case 0: {
                switch (eid) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        return new BeginMetafile(ec, eid, l, in);
                    }
                    case 2: {
                        return new EndMetafile(ec, eid, l, in);
                    }
                    case 3: {
                        return new BeginPicture(ec, eid, l, in);
                    }
                    case 4: {
                        return new BeginPictureBody(ec, eid, l, in);
                    }
                    case 5: {
                        return new EndPicture(ec, eid, l, in);
                    }
                    case 6: {
                        return new DummyCommand(ec, eid, l, in, "Begin Segment");
                    }
                    case 7: {
                        return new DummyCommand(ec, eid, l, in, "End Segment");
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Begin Figure");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "End Figure");
                    }
                    case 13: {
                        return new DummyCommand(ec, eid, l, in, "Being Protection Region");
                    }
                    case 14: {
                        return new DummyCommand(ec, eid, l, in, "End Protection Region");
                    }
                    case 15: {
                        return new DummyCommand(ec, eid, l, in, "Begin Compound Line");
                    }
                    case 16: {
                        return new DummyCommand(ec, eid, l, in, "End Compound Line");
                    }
                    case 17: {
                        return new DummyCommand(ec, eid, l, in, "Begin Compound Text Path");
                    }
                    case 18: {
                        return new DummyCommand(ec, eid, l, in, "End Compound Text Path");
                    }
                    case 19: {
                        return new DummyCommand(ec, eid, l, in, "Begin Tile Array");
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "End Tile Array");
                    }
                    case 21: {
                        return new DummyCommand(ec, eid, l, in, "Begin Application Structure");
                    }
                    case 22: {
                        return new DummyCommand(ec, eid, l, in, "Begin Application Structure Body");
                    }
                    case 23: {
                        return new DummyCommand(ec, eid, l, in, "End Application Structure");
                    }
                }
                break;
            }
            case 1: {
                switch (eid) {
                    case 1: {
                        return new MetafileVersion(ec, eid, l, in);
                    }
                    case 2: {
                        return new MetafileDescription(ec, eid, l, in);
                    }
                    case 3: {
                        return new DummyCommand(ec, eid, l, in, "VDC Type");
                    }
                    case 4: {
                        return new DummyCommand(ec, eid, l, in, "Integer Precision");
                    }
                    case 5: {
                        return new DummyCommand(ec, eid, l, in, "Real Precision");
                    }
                    case 6: {
                        return new DummyCommand(ec, eid, l, in, "Index Precision");
                    }
                    case 7: {
                        return new DummyCommand(ec, eid, l, in, "Color Precision");
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Color Index Precision");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "Maximum Color Index");
                    }
                    case 10: {
                        return new DummyCommand(ec, eid, l, in, "Color Value Extent");
                    }
                    case 11: {
                        return new MetafileElementList(ec, eid, l, in);
                    }
                    case 12: {
                        return new DummyCommand(ec, eid, l, in, "Metafile Defaults Replacement");
                    }
                    case 13: {
                        return new FontList(ec, eid, l, in);
                    }
                    case 14: {
                        return new DummyCommand(ec, eid, l, in, "Character Set List");
                    }
                    case 15: {
                        return new DummyCommand(ec, eid, l, in, "Character Coding Announcer");
                    }
                    case 16: {
                        return new DummyCommand(ec, eid, l, in, "Name Precision");
                    }
                    case 17: {
                        return new DummyCommand(ec, eid, l, in, "Maximum VDC Extent");
                    }
                    case 18: {
                        return new DummyCommand(ec, eid, l, in, "Segment Priority Extent");
                    }
                    case 19: {
                        return new ColorModel(ec, eid, l, in);
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "Color Calibration");
                    }
                    case 21: {
                        return new DummyCommand(ec, eid, l, in, "Font Properties");
                    }
                    case 22: {
                        return new DummyCommand(ec, eid, l, in, "Glyph Mapping");
                    }
                    case 23: {
                        return new DummyCommand(ec, eid, l, in, "Symbol Library List");
                    }
                    case 24: {
                        return new DummyCommand(ec, eid, l, in, "Picture Directory");
                    }
                }
                break;
            }
            case 2: {
                switch (eid) {
                    case 1: {
                        return new DummyCommand(ec, eid, l, in, "Scaling Mode");
                    }
                    case 2: {
                        return new ColorSelectionMode(ec, eid, l, in);
                    }
                    case 3: {
                        return new LineWidthMode(ec, eid, l, in);
                    }
                    case 4: {
                        return new DummyCommand(ec, eid, l, in, "Marker Size Specification Mode");
                    }
                    case 5: {
                        return new EdgeWidthMode(ec, eid, l, in);
                    }
                    case 6: {
                        return new VDCExtent(ec, eid, l, in);
                    }
                    case 7: {
                        return new DummyCommand(ec, eid, l, in, "Background Color");
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Device Viewport");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "Device Viewport Specification Mode");
                    }
                    case 10: {
                        return new DummyCommand(ec, eid, l, in, "Device Viewport Mapping");
                    }
                    case 11: {
                        return new DummyCommand(ec, eid, l, in, "Line Representation");
                    }
                    case 12: {
                        return new DummyCommand(ec, eid, l, in, "Marker Representation");
                    }
                    case 13: {
                        return new DummyCommand(ec, eid, l, in, "Text Representation");
                    }
                    case 14: {
                        return new DummyCommand(ec, eid, l, in, "Fill Representation");
                    }
                    case 15: {
                        return new DummyCommand(ec, eid, l, in, "Edge Representation");
                    }
                    case 16: {
                        return new DummyCommand(ec, eid, l, in, "Interior Style Specification Mode");
                    }
                    case 17: {
                        return new DummyCommand(ec, eid, l, in, "Line and Edge Type Definition");
                    }
                    case 18: {
                        return new DummyCommand(ec, eid, l, in, "Hatch Style Definition");
                    }
                    case 19: {
                        return new DummyCommand(ec, eid, l, in, "Geometric Pattern Definition");
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "Application Structure Directory");
                    }
                }
                break;
            }
            case 3: {
                switch (eid) {
                    case 1: {
                        return new DummyCommand(ec, eid, l, in, "VDC Integer Precision");
                    }
                    case 2: {
                        return new DummyCommand(ec, eid, l, in, "VDC Real Precision");
                    }
                    case 3: {
                        return new DummyCommand(ec, eid, l, in, "Auxiliary Color");
                    }
                    case 4: {
                        return new DummyCommand(ec, eid, l, in, "Transparency");
                    }
                    case 5: {
                        return new DummyCommand(ec, eid, l, in, "Clip Rectangle");
                    }
                    case 6: {
                        return new DummyCommand(ec, eid, l, in, "Clip Indicator");
                    }
                    case 7: {
                        return new DummyCommand(ec, eid, l, in, "Line Clipping Mode");
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Marker Clipping Mode");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "Edge Clipping Mode");
                    }
                    case 10: {
                        return new DummyCommand(ec, eid, l, in, "New Region");
                    }
                    case 11: {
                        return new DummyCommand(ec, eid, l, in, "Save Primitive Context");
                    }
                    case 12: {
                        return new DummyCommand(ec, eid, l, in, "Restore Primitive Context");
                    }
                    case 17: {
                        return new DummyCommand(ec, eid, l, in, "Protection Region Indicator");
                    }
                    case 18: {
                        return new DummyCommand(ec, eid, l, in, "Generalized Text Path Mode");
                    }
                    case 19: {
                        return new DummyCommand(ec, eid, l, in, "Mitre Limit");
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "Transparent Cell Color");
                    }
                }
                break;
            }
            case 4: {
                switch (eid) {
                    case 1: {
                        return new PolylineElement(ec, eid, l, in);
                    }
                    case 2: {
                        return new DummyCommand(ec, eid, l, in, "Disjoint Polyline");
                    }
                    case 3: {
                        return new DummyCommand(ec, eid, l, in, "Polymarker");
                    }
                    case 4: {
                        return new TextElement(ec, eid, l, in);
                    }
                    case 5: {
                        return new DummyCommand(ec, eid, l, in, "Text");
                    }
                    case 6: {
                        return new DummyCommand(ec, eid, l, in, "Restricted Text");
                    }
                    case 7: {
                        return new PolygonElement(ec, eid, l, in);
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Append Text");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "Cell Array");
                    }
                    case 10: {
                        return new DummyCommand(ec, eid, l, in, "Generalized Drawing Primitive");
                    }
                    case 11: {
                        return new RectangleElement(ec, eid, l, in);
                    }
                    case 12: {
                        return new CircleElement(ec, eid, l, in);
                    }
                    case 13: {
                        return new DummyCommand(ec, eid, l, in, "Circular Arc Point");
                    }
                    case 14: {
                        return new DummyCommand(ec, eid, l, in, "Circular Arc 3 Point Close");
                    }
                    case 15: {
                        return new CircularArcElement(ec, eid, l, in);
                    }
                    case 16: {
                        return new CircularArcClosedElement(ec, eid, l, in);
                    }
                    case 17: {
                        return new EllipseElement(ec, eid, l, in);
                    }
                    case 18: {
                        return new EllipticalArcElement(ec, eid, l, in);
                    }
                    case 19: {
                        return new EllipticalArcClosedElement(ec, eid, l, in);
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "Circular Arc Center Reversed");
                    }
                    case 21: {
                        return new DummyCommand(ec, eid, l, in, "Connecting Edge");
                    }
                    case 22: {
                        return new DummyCommand(ec, eid, l, in, "Hyperbolic Arc");
                    }
                    case 23: {
                        return new DummyCommand(ec, eid, l, in, "Parabolic Arc");
                    }
                    case 24: {
                        return new DummyCommand(ec, eid, l, in, "Non-Uniform B-Spline");
                    }
                    case 25: {
                        return new DummyCommand(ec, eid, l, in, "Non-Uniform Rational B-Spline");
                    }
                    case 26: {
                        return new DummyCommand(ec, eid, l, in, "Polybezier");
                    }
                    case 27: {
                        return new DummyCommand(ec, eid, l, in, "Polysymbol");
                    }
                    case 28: {
                        return new DummyCommand(ec, eid, l, in, "Bitonal Tile");
                    }
                    case 29: {
                        return new DummyCommand(ec, eid, l, in, "Tile");
                    }
                }
                break;
            }
            case 5: {
                switch (eid) {
                    case 1: {
                        return new DummyCommand(ec, eid, l, in, "Line Bundle Index");
                    }
                    case 2: {
                        return new LineType(ec, eid, l, in);
                    }
                    case 3: {
                        return new LineWidth(ec, eid, l, in);
                    }
                    case 4: {
                        return new LineColor(ec, eid, l, in);
                    }
                    case 5: {
                        return new DummyCommand(ec, eid, l, in, "Marker Bundle Index");
                    }
                    case 6: {
                        return new DummyCommand(ec, eid, l, in, "Marker Type");
                    }
                    case 7: {
                        return new DummyCommand(ec, eid, l, in, "Marker Size");
                    }
                    case 8: {
                        return new DummyCommand(ec, eid, l, in, "Marker Color");
                    }
                    case 9: {
                        return new DummyCommand(ec, eid, l, in, "Text Bundle Index");
                    }
                    case 10: {
                        return new TextFontIndex(ec, eid, l, in);
                    }
                    case 11: {
                        return new DummyCommand(ec, eid, l, in, "Text Precision");
                    }
                    case 12: {
                        return new DummyCommand(ec, eid, l, in, "Character Expansion Factor");
                    }
                    case 13: {
                        return new DummyCommand(ec, eid, l, in, "Character Spacing");
                    }
                    case 14: {
                        return new TextColor(ec, eid, l, in);
                    }
                    case 15: {
                        return new CharacterHeight(ec, eid, l, in);
                    }
                    case 16: {
                        return new DummyCommand(ec, eid, l, in, "Character Orientation");
                    }
                    case 17: {
                        return new DummyCommand(ec, eid, l, in, "Text Path");
                    }
                    case 18: {
                        return new DummyCommand(ec, eid, l, in, "Text Alignment");
                    }
                    case 19: {
                        return new DummyCommand(ec, eid, l, in, "Character Set Index");
                    }
                    case 20: {
                        return new DummyCommand(ec, eid, l, in, "Alternate Character Set Index");
                    }
                    case 21: {
                        return new DummyCommand(ec, eid, l, in, "Fill Bundle Index");
                    }
                    case 22: {
                        return new InteriorStyle(ec, eid, l, in);
                    }
                    case 23: {
                        return new FillColor(ec, eid, l, in);
                    }
                    case 24: {
                        return new DummyCommand(ec, eid, l, in, "Hatch Index");
                    }
                    case 25: {
                        return new DummyCommand(ec, eid, l, in, "Pattern Index");
                    }
                    case 26: {
                        return new DummyCommand(ec, eid, l, in, "Edge Bundle Index");
                    }
                    case 27: {
                        return new EdgeType(ec, eid, l, in);
                    }
                    case 28: {
                        return new EdgeWidth(ec, eid, l, in);
                    }
                    case 29: {
                        return new EdgeColor(ec, eid, l, in);
                    }
                    case 30: {
                        return new EdgeVisibility(ec, eid, l, in);
                    }
                    case 31: {
                        return new DummyCommand(ec, eid, l, in, "Fill Reference Point");
                    }
                    case 32: {
                        return new DummyCommand(ec, eid, l, in, "Pattern Table");
                    }
                    case 33: {
                        return new DummyCommand(ec, eid, l, in, "Pattern Size");
                    }
                    case 34: {
                        return new ColorTable(ec, eid, l, in);
                    }
                    case 35: {
                        return new DummyCommand(ec, eid, l, in, "Aspect Source Flags");
                    }
                    case 36: {
                        return new DummyCommand(ec, eid, l, in, "Pick Indentifier");
                    }
                    case 37: {
                        return new DummyCommand(ec, eid, l, in, "Line Cap");
                    }
                    case 38: {
                        return new DummyCommand(ec, eid, l, in, "Line Join");
                    }
                    case 39: {
                        return new DummyCommand(ec, eid, l, in, "Line Type Continuation");
                    }
                    case 40: {
                        return new DummyCommand(ec, eid, l, in, "Line Type Initial Offset");
                    }
                    case 41: {
                        return new DummyCommand(ec, eid, l, in, "Text Score Type");
                    }
                    case 42: {
                        return new DummyCommand(ec, eid, l, in, "Restricted Text Type");
                    }
                    case 43: {
                        return new DummyCommand(ec, eid, l, in, "Interpolated Interior");
                    }
                    case 44: {
                        return new DummyCommand(ec, eid, l, in, "Edge Cap");
                    }
                    case 45: {
                        return new DummyCommand(ec, eid, l, in, "Edge Join");
                    }
                    case 46: {
                        return new DummyCommand(ec, eid, l, in, "Edge Type Continuation");
                    }
                    case 47: {
                        return new DummyCommand(ec, eid, l, in, "Edge Type Initial Offset");
                    }
                    case 48: {
                        return new DummyCommand(ec, eid, l, in, "Symbol Library Index");
                    }
                    case 49: {
                        return new DummyCommand(ec, eid, l, in, "Symbol Color");
                    }
                    case 50: {
                        return new DummyCommand(ec, eid, l, in, "Symbol Size");
                    }
                    case 51: {
                        return new DummyCommand(ec, eid, l, in, "Symbol Orientation");
                    }
                }
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                switch (eid) {
                    case 1: {
                        return new ApplicationStructureAttribute(ec, eid, l, in);
                    }
                }
                break;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Ignored Opcode: " + ec + "/" + eid);
        }
        return new Command(ec, eid, l, in);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

