/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.logging.Logger;

public class SimpleEmptyTileHandler
implements EmptyTileHandler,
PropertyConsumer {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler");
    public static final String BACKGROUND_PROPERTY = "background";
    public static final String NO_COVERAGE_PROPERTY = "noCoverage";
    public static final String NO_COVERAGE_ZOOM_PROPERTY = "noCoverageZoom";
    public static final int TILE_SIZE = 256;
    protected DrawingAttributes backgroundAtts = DrawingAttributes.getDefaultClone();
    protected DrawingAttributes noCoverageAtts = DrawingAttributes.getDefaultClone();
    protected String prefix;
    protected BufferedImage emptyTileImage;
    protected BufferedImage backgroundTileImage;
    protected int noCoverageZoom = 0;

    public SimpleEmptyTileHandler() {
        this.noCoverageAtts.setLinePaint(OMColor.clear);
    }

    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        if (zoomLevel < this.noCoverageZoom) {
            return this.backgroundTileImage;
        }
        logger.fine("returning emptyTileImage: " + this.emptyTileImage);
        return this.emptyTileImage;
    }

    public void setPropertyPrefix(String pref) {
        this.prefix = pref;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        DrawingAttributes backgroundDA = DrawingAttributes.getDefaultClone();
        DrawingAttributes noCoverageDA = DrawingAttributes.getDefaultClone();
        backgroundDA.setProperties(prefix + BACKGROUND_PROPERTY, props);
        noCoverageDA.setProperties(prefix + NO_COVERAGE_PROPERTY, props);
        this.setBackgroundAtts(backgroundDA);
        this.setNoCoverageAtts(noCoverageDA);
        this.noCoverageZoom = PropUtils.intFromProperties(props, prefix + NO_COVERAGE_ZOOM_PROPERTY, this.noCoverageZoom);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.getBackgroundAtts().getProperties(props);
        this.getNoCoverageAtts().getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.getBackgroundAtts().getPropertyInfo(props);
        this.getNoCoverageAtts().getPropertyInfo(props);
        return props;
    }

    protected BufferedImage createTileImageFromDrawingAttributes(DrawingAttributes da) {
        BufferedImage bi = null;
        if (da != null) {
            OMRect rect = new OMRect(0, 0, 256, 256);
            da.setTo(rect);
            rect.generate(new Mercator(new LatLonPoint.Double(), 100000.0f, 256, 256));
            bi = new BufferedImage(256, 256, 2);
            Graphics g = bi.getGraphics();
            rect.render(g);
            g.dispose();
        }
        return bi;
    }

    public DrawingAttributes getBackgroundAtts() {
        return this.backgroundAtts;
    }

    public void setBackgroundAtts(DrawingAttributes backgroundAtts) {
        if (backgroundAtts != null && !backgroundAtts.equals(this.backgroundAtts)) {
            this.backgroundTileImage = this.createTileImageFromDrawingAttributes(backgroundAtts);
            this.backgroundAtts = backgroundAtts;
        }
        if (this.backgroundAtts == null) {
            this.backgroundAtts = DrawingAttributes.getDefaultClone();
        }
    }

    public DrawingAttributes getNoCoverageAtts() {
        return this.noCoverageAtts;
    }

    public void setNoCoverageAtts(DrawingAttributes noCoverageAtts) {
        if (noCoverageAtts != null && !noCoverageAtts.equals(this.noCoverageAtts)) {
            logger.fine("the no coverage atts are not standard, creating a new emptyTileImage");
            this.emptyTileImage = this.createTileImageFromDrawingAttributes(noCoverageAtts);
            this.noCoverageAtts = noCoverageAtts;
        } else {
            logger.fine("++++++++ " + noCoverageAtts + " vs " + this.noCoverageAtts);
        }
        if (this.noCoverageAtts == null) {
            this.noCoverageAtts = DrawingAttributes.getDefaultClone();
        }
    }

    public int getNoCoverageZoom() {
        return this.noCoverageZoom;
    }

    public void setNoCoverageZoom(int noCoverageZoom) {
        this.noCoverageZoom = noCoverageZoom;
    }
}

