/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ServerMapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.TMSMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.PropUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class TileGrabber {
    public static void main(String[] args) {
        block23: {
            String[] arg;
            ArgParser ap = new ArgParser("TileGrabber");
            ap.add("source", "Path to fetch tiles from, should be http://path/{z}/{x}/{y}.png form", 1);
            ap.add("target", "Path to the output directory for fetched tiles", 1);
            ap.add("fromZoom", "Starting zoom level", 1);
            ap.add("toZoom", "Ending zoom level", 1);
            ap.add("minx", "min x tile (only used if fromZoom and toZoom match)", 1);
            ap.add("miny", "min y tile (only used if fromZoom and toZoom match)", 1);
            ap.add("maxx", "max x tile (only used if fromZoom and toZoom match)", 1);
            ap.add("maxy", "max y tile (only used if fromZoom and toZoom match)", 1);
            ap.add("minlon", "min longitude", 1);
            ap.add("minlat", "min latitude", 1);
            ap.add("maxlon", "max longitude", 1);
            ap.add("maxlat", "max latitude", 1);
            ap.add("shapefile", "fetch coverage over shapes in shapefile", 1);
            ap.add("verbose", "Describe what's going on.");
            ap.add("extraVerbose", "Really describe what's going on.");
            ap.add("fill", "Only fetch tiles that don't exist.");
            ap.add("TMS", "Specify that the tile numbering scheme matches TMS (OSM is default)");
            if (!ap.parse(args)) {
                ap.printUsage();
                System.exit(0);
            }
            if ((arg = ap.getArgValues("source")) != null) {
                try {
                    Builder wwthBuilder = new Builder(arg[0]);
                    arg = ap.getArgValues("target");
                    if (arg != null) {
                        wwthBuilder.targetFile(arg[0]);
                    }
                    if ((arg = ap.getArgValues("fromZoom")) != null) {
                        wwthBuilder.fromZoom(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("toZoom")) != null) {
                        wwthBuilder.toZoom(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("minx")) != null) {
                        wwthBuilder.minx(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("miny")) != null) {
                        wwthBuilder.miny(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("maxx")) != null) {
                        wwthBuilder.maxx(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("maxy")) != null) {
                        wwthBuilder.maxy(Integer.parseInt(arg[0]));
                    }
                    if ((arg = ap.getArgValues("minlon")) != null) {
                        wwthBuilder.minlon(Double.parseDouble(arg[0]));
                    }
                    if ((arg = ap.getArgValues("minlat")) != null) {
                        wwthBuilder.minlat(Double.parseDouble(arg[0]));
                    }
                    if ((arg = ap.getArgValues("maxlon")) != null) {
                        wwthBuilder.maxlon(Double.parseDouble(arg[0]));
                    }
                    if ((arg = ap.getArgValues("maxlat")) != null) {
                        wwthBuilder.maxlat(Double.parseDouble(arg[0]));
                    }
                    if ((arg = ap.getArgValues("verbose")) != null) {
                        wwthBuilder.verbose = true;
                    }
                    if ((arg = ap.getArgValues("extraVerbose")) != null) {
                        wwthBuilder.verbose = true;
                        wwthBuilder.extraVerbose = true;
                    }
                    if ((arg = ap.getArgValues("fill")) != null) {
                        wwthBuilder.setFill(true);
                    }
                    if ((arg = ap.getArgValues("TMS")) != null) {
                        wwthBuilder.transform = new TMSMapTileCoordinateTransform();
                    }
                    if ((arg = ap.getArgValues("shapefile")) != null) {
                        wwthBuilder.go(arg[0]);
                        break block23;
                    }
                    System.out.println(wwthBuilder.toString());
                    wwthBuilder.go();
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    System.out.println(nfe.getMessage());
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                    System.out.println(fnfe.getMessage());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.out.println(ioe.getMessage());
                }
            } else {
                ap.bail("Need a source directory.", true);
            }
        }
        System.exit(0);
    }

    public static class Builder {
        protected String source;
        protected String target = "";
        protected int fromZoom = 0;
        protected int toZoom = 0;
        protected int minx = 0;
        protected int miny = 0;
        protected int maxx = -1;
        protected int maxy = -1;
        protected double minlon = -180.0;
        protected double minlat = -85.0;
        protected double maxlon = 180.0;
        protected double maxlat = 85.0;
        protected boolean fill = false;
        protected boolean verbose = false;
        protected boolean extraVerbose = false;
        protected boolean tileBoundsSet = false;
        MapTileCoordinateTransform transform = new OSMMapTileCoordinateTransform();

        public Builder(String source) throws FileNotFoundException {
            if (source == null) {
                throw new FileNotFoundException("Source file invalid");
            }
            this.source = source;
        }

        public Builder targetFile(String targetFile) {
            this.target = targetFile;
            return this;
        }

        public Builder fromZoom(int zoomLevel) throws NumberFormatException {
            if (this.checkZoomLevel(zoomLevel)) {
                this.fromZoom = zoomLevel;
            }
            if (this.fromZoom > this.toZoom) {
                this.toZoom = this.fromZoom;
            }
            return this;
        }

        public Builder toZoom(int zoomLevel) throws NumberFormatException {
            if (this.checkZoomLevel(zoomLevel)) {
                this.toZoom = zoomLevel;
                if (this.fromZoom > this.toZoom) {
                    this.fromZoom = this.toZoom;
                }
            }
            return this;
        }

        protected boolean checkZoomLevel(int zoomLevel) {
            if (zoomLevel < 0 || zoomLevel > 20) {
                throw new NumberFormatException("Zoom level needs to be > 0 and < 20");
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WholeWorldTileHandler[");
            sb.append("source:").append(this.source).append(',');
            sb.append("target:").append(this.target).append(',');
            sb.append("fromZoom:").append(this.fromZoom).append(',');
            sb.append("toZoom:").append(this.toZoom).append(',');
            if (this.minx != 0) {
                sb.append(",").append("minx:").append(this.minx);
            }
            if (this.miny != 0) {
                sb.append(",").append("miny:").append(this.miny);
            }
            if (this.maxx >= 0) {
                sb.append(",").append("maxx:").append(this.maxx);
            }
            if (this.maxy >= 0) {
                sb.append(",").append("maxy:").append(this.maxy);
            }
            sb.append(']');
            return sb.toString();
        }

        protected int[] getTileBoundsForProjection(LatLonPoint ul, LatLonPoint lr, int z) {
            if (this.fromZoom == this.toZoom && this.tileBoundsSet) {
                ZoomLevelInfo zoomInfo = new ZoomLevelInfo();
                zoomInfo.setZoomLevel(z);
                int maxDim = zoomInfo.getEdgeTileCount();
                if (this.maxx == -1) {
                    this.maxx = maxDim;
                }
                if (this.maxy == -1) {
                    this.maxy = maxDim;
                }
                return new int[]{this.miny, this.minx, this.maxy, this.maxx};
            }
            return this.transform.getTileBoundsForProjection(ul, lr, z);
        }

        public void go() throws FileNotFoundException, IOException {
            LatLonPoint.Double ul = new LatLonPoint.Double(this.maxlat, this.minlon);
            LatLonPoint.Double lr = new LatLonPoint.Double(this.minlat, this.maxlon);
            ServerMapTileFactory tileServer = new ServerMapTileFactory();
            StandardMapTileFactory.TilePathBuilder serverPathBuilder = new StandardMapTileFactory.TilePathBuilder(this.source);
            StandardMapTileFactory.TilePathBuilder localPathBuilder = new StandardMapTileFactory.TilePathBuilder(this.target);
            ZoomLevelInfo zoomInfo = new ZoomLevelInfo();
            for (int z = this.fromZoom; z <= this.toZoom; ++z) {
                int[] uv = this.getTileBoundsForProjection(ul, lr, z);
                int startX = uv[1];
                int endX = uv[3];
                int startY = uv[0];
                int endY = uv[2];
                if (this.verbose) {
                    System.out.println("fetching tiles for zoom level " + z + " between " + startY + ", " + startX + " and " + endY + ", " + endX);
                }
                zoomInfo.setZoomLevel(z);
                int maxDim = zoomInfo.getEdgeTileCount();
                for (int x = startX; x <= endX && x <= maxDim - 1; ++x) {
                    for (int y = startY; y <= endY && y <= maxDim - 1; ++y) {
                        File localFile;
                        String serverImagePath = serverPathBuilder.buildTilePath(x, y, z, ".png");
                        String localFilePath = localPathBuilder.buildTilePath(x, y, z, ".png");
                        if (this.fill && (localFile = new File(localFilePath)).exists()) {
                            if (!this.extraVerbose) continue;
                            System.out.println("--- skipping " + localFilePath + ", aready got it");
                            continue;
                        }
                        if (this.extraVerbose) {
                            System.out.println("<<< fetching " + serverImagePath);
                        }
                        tileServer.getImageBytes(serverImagePath, localFilePath);
                    }
                }
            }
        }

        public void go(String shapefile) throws FileNotFoundException, IOException {
            try {
                if (this.verbose) {
                    System.out.println("fetching tiles covering " + shapefile);
                }
                URL shp = PropUtils.getResourceOrFileOrURL(shapefile);
                EsriGraphicList egl = EsriGraphicList.getEsriGraphicList(shp, null, null);
                this.fetchTilesForEsriGraphicList(egl);
            }
            catch (MalformedURLException murle) {
                throw new FileNotFoundException(murle.getMessage());
            }
        }

        protected void fetchTilesForEsriGraphicList(EsriGraphicList egl) throws FileNotFoundException, IOException {
            for (OMGraphic omg : egl) {
                if (omg instanceof EsriGraphicList) {
                    this.fetchTilesForEsriGraphicList((EsriGraphicList)omg);
                    continue;
                }
                if (!(omg instanceof EsriGraphic)) continue;
                this.fetchTilesForEsriGraphic((EsriGraphic)((Object)omg));
            }
        }

        protected void fetchTilesForEsriGraphic(EsriGraphic eg) throws FileNotFoundException, IOException {
            double[] coords = eg.getExtents();
            this.minlat = coords[0];
            this.minlon = coords[1];
            this.maxlat = coords[2];
            this.maxlon = coords[3];
            this.go();
        }

        public void minx(int parseInt) {
            this.minx = parseInt;
            this.tileBoundsSet = true;
        }

        public void miny(int parseInt) {
            this.miny = parseInt;
            this.tileBoundsSet = true;
        }

        public void maxx(int parseInt) {
            this.maxx = parseInt;
            this.tileBoundsSet = true;
        }

        public void maxy(int parseInt) {
            this.maxy = parseInt;
            this.tileBoundsSet = true;
        }

        public void minlon(double parsed) {
            this.minlon = parsed;
        }

        public void minlat(double parsed) {
            this.minlat = parsed;
        }

        public void maxlon(double parsed) {
            this.maxlon = parsed;
        }

        public void maxlat(double parsed) {
            this.maxlat = parsed;
        }

        public boolean isFill() {
            return this.fill;
        }

        public void setFill(boolean fill) {
            this.fill = fill;
        }
    }
}

