/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.rule.IndexRule;
import com.bbn.openmap.omGraphics.rule.Rule;
import com.bbn.openmap.omGraphics.rule.RuleHandler;
import com.bbn.openmap.util.PropUtils;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbfHandler
extends RuleHandler<List> {
    protected DbfFile dbf;
    protected List<Rule> rules;
    protected DrawingAttributes defaultDA = new DrawingAttributes();

    protected DbfHandler() {
    }

    public DbfHandler(String dbfFilePath) throws IOException, FormatException {
        this(new BinaryFile(dbfFilePath));
    }

    public DbfHandler(BinaryFile bf) throws IOException, FormatException {
        this();
        this.dbf = new DbfFile(bf);
        this.dbf.close();
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.defaultDA.setProperties(prefix, props);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        this.defaultDA.getProperties(props);
        return props;
    }

    public DbfFile getDbf() {
        return this.dbf;
    }

    public void setDbf(DbfFile dbf) {
        this.dbf = dbf;
    }

    public DrawingAttributes getDefaultDA() {
        return this.defaultDA;
    }

    public void setDefaultDA(DrawingAttributes defaultDA) {
        this.defaultDA = defaultDA;
    }

    public void close() {
        if (this.dbf != null) {
            this.dbf.close();
        }
    }

    @Override
    public Rule createRule() {
        return new DbfRule(this.dbf);
    }

    @Override
    public List getRecordDataForOMGraphic(OMGraphic omg) {
        try {
            return this.dbf.getRecordData((Integer)omg.getAttribute("SHAPE_INDEX_ATTRIBUTE"));
        }
        catch (IOException iOException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return null;
    }

    public class DbfRule
    extends IndexRule {
        DbfFile dbf;

        public DbfRule(DbfFile dbf) {
            this.dbf = dbf;
        }

        public int getRecordColumnIndexForName(String columnName) {
            return this.dbf.getColumnIndexForName(columnName);
        }

        public String getRecordColumnName(int index) {
            return this.dbf.getColumnName(index);
        }
    }
}

