/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.ProjMath;

public class EsriPolyline
extends OMPoly
implements EsriGraphic,
Cloneable {
    double[] extents;

    public EsriPolyline(double[] points, int units, int lineType) {
        super(points, units, lineType);
    }

    public void setExtents(double[] extents) {
        this.extents = extents;
    }

    public double[] getExtents() {
        if (this.extents == null) {
            this.extents = new double[]{90.0, 180.0, -90.0, -180.0};
            double[] points = super.getLatLonArray();
            double[] degreePoints = new double[points.length];
            System.arraycopy(points, 0, degreePoints, 0, points.length);
            this.addExtents(ProjMath.arrayRadToDeg(degreePoints));
        }
        return this.extents;
    }

    public void setType(int t) {
    }

    public int getType() {
        return 3;
    }

    public void addExtents(double[] graphicExtents) {
        double[] ex = this.getExtents();
        for (int i = 0; i < graphicExtents.length - 1; i += 2) {
            if (ex[0] > graphicExtents[i]) {
                ex[0] = graphicExtents[i];
            }
            if (ex[1] > graphicExtents[i + 1]) {
                ex[1] = graphicExtents[i + 1];
            }
            if (ex[2] < graphicExtents[i]) {
                ex[2] = graphicExtents[i];
            }
            if (!(ex[3] < graphicExtents[i + 1])) continue;
            ex[3] = graphicExtents[i + 1];
        }
    }

    public static EsriPolyline convert(OMPoly ompoly) {
        if (ompoly.getRenderType() == 1) {
            double[] rawLL = ompoly.getLatLonArray();
            double[] degreePoints = new double[rawLL.length];
            System.arraycopy(rawLL, 0, degreePoints, 0, rawLL.length);
            EsriPolyline ePoly = new EsriPolyline(degreePoints, 1, ompoly.getLineType());
            ePoly.setAttributes(ompoly.getAttributes());
            DrawingAttributes attributes = new DrawingAttributes();
            attributes.setFrom(ompoly);
            attributes.setTo(ePoly);
            ePoly.setIsPolygon(false);
            return ePoly;
        }
        return null;
    }

    public boolean isPolygon() {
        return false;
    }

    public EsriGraphic shallowCopy() {
        return this.shallowCopyPolyline();
    }

    public EsriPolyline shallowCopyPolyline() {
        return (EsriPolyline)this.clone();
    }
}

