/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.DeepCopyUtil;
import java.util.Iterator;

public class EsriPolylineList
extends EsriGraphicList {
    public boolean add(OMGraphic shape) {
        boolean ret = false;
        try {
            if (this.typeMatches(shape)) {
                ret = this.graphics.add(shape);
                this.addExtents(((EsriGraphic)((Object)shape)).getExtents());
            } else if (shape instanceof OMPoly) {
                EsriPolyline eg = this.convert((OMPoly)shape);
                if (this.typeMatches(eg)) {
                    ret = this.graphics.add(eg);
                    this.addExtents(eg.getExtents());
                }
            } else if (shape instanceof OMLine) {
                EsriPolyline eg;
                OMPoly omp = EsriPolylineList.convert((OMLine)shape);
                if (omp != null && this.typeMatches(eg = this.convert(omp))) {
                    ret = this.graphics.add(eg);
                    this.addExtents(eg.getExtents());
                }
            } else if (shape instanceof OMGraphicList && !((OMGraphicList)shape).isVague()) {
                Iterator it = ((OMGraphicList)shape).iterator();
                while (it.hasNext()) {
                    this.add((OMGraphic)it.next());
                }
                ret = true;
            } else {
                Debug.message("esri", "EsriPolygonList.add()- graphic isn't a EsriPoly or OMPoly, can't add.");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ret;
    }

    public EsriPolyline convert(OMPoly ompoly) {
        return EsriPolyline.convert(ompoly);
    }

    public boolean typeMatches(OMGraphic omg) {
        return omg instanceof EsriGraphic && ((EsriGraphic)((Object)omg)).getType() == this.getType();
    }

    public int getType() {
        return 3;
    }

    public EsriPolylineList() {
    }

    public EsriPolylineList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriPolylineList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public static OMPoly convert(OMLine omLine) {
        if (omLine.getRenderType() == 1) {
            OMPoly poly = new OMPoly(DeepCopyUtil.deepCopy(omLine.getLL()), 0, omLine.getLineType());
            poly.setAttributes(omLine.getAttributes());
            DrawingAttributes da = new DrawingAttributes();
            da.setFrom(omLine);
            da.setTo(poly);
            return poly;
        }
        return null;
    }

    public EsriGraphic shallowCopy() {
        EsriPolylineList ret = new EsriPolylineList(this.size());
        ret.setAttributes(this.getAttributes());
        for (EsriGraphic g : this) {
            ret.add((OMGraphic)((Object)g.shallowCopy()));
        }
        return ret;
    }
}

