/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMapFrame
extends JFrame
implements BeanContextMembershipListener,
BeanContextChild,
PropertyConsumer {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.OpenMapFrame");
    public static final String xProperty = "x";
    public static final String yProperty = "y";
    public static final String WidthProperty = "Width";
    public static final String HeightProperty = "Height";
    public static final String TitleProperty = "Title";
    protected boolean useAsInternalFrameRootPaneIfNecessary = true;
    private BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();
    protected String propertyPrefix;
    protected int frameLocX = -1;
    protected int frameLocY = -1;
    protected int frameWidth = Integer.MAX_VALUE;
    protected int frameHeight = Integer.MAX_VALUE;
    protected I18n i18n = Environment.getI18n();

    public OpenMapFrame() {
        this("");
    }

    public OpenMapFrame(boolean useAsInternalFrameRootPaneIfNecessary) {
        this(Environment.get("openmap.Title"), useAsInternalFrameRootPaneIfNecessary);
    }

    public OpenMapFrame(String title) {
        this(title, true);
    }

    public OpenMapFrame(String title, boolean useAsInternalFrameRootPaneIfNecessary) {
        super(title);
        this.useAsInternalFrameRootPaneIfNecessary = useAsInternalFrameRootPaneIfNecessary;
    }

    protected void setPosition() {
        this.setPosition(this.getWidth(), this.getHeight());
    }

    protected void setPosition(int w, int h) {
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        logger.fine("Screen dimensions are " + d);
        if (w > d.width) {
            w = d.width - d.width / 10;
        }
        if (h > d.height) {
            h = d.height - d.height / 10;
        }
        if (this.frameLocX < 0) {
            this.frameLocX = d.width / 2 - w / 2;
        }
        if (this.frameLocY < 0) {
            this.frameLocY = d.height / 2 - h / 2;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Setting window bounds from " + this.frameLocX + ", " + this.frameLocY + " for size " + w + ", " + h);
        }
        this.setBounds(this.frameLocX, this.frameLocY, w, h);
    }

    public void findAndInit(Iterator<?> it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        this.considerForContent(someObj);
        if (someObj instanceof JMenuBar) {
            logger.fine("OpenMapFrame: Found a MenuBar");
            this.getRootPane().setJMenuBar((JMenuBar)someObj);
            this.invalidate();
        }
    }

    public void considerForContent(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Component && this.getContentPane().getComponentCount() == 0) {
            logger.fine("Found a MapPanel");
            this.setContent((Component)someObj);
        }
    }

    public void setContent(Component component) {
        MapPanel mapPanel;
        JMenuBar jmb;
        this.getContentPane().add(component);
        if (component instanceof MapPanel && (jmb = (mapPanel = (MapPanel)((Object)component)).getMapMenuBar()) != null) {
            logger.fine("OpenMapFrame: Got MenuBar from MapPanel");
            this.getRootPane().setJMenuBar(jmb);
        }
        this.setPosition(this.frameWidth, this.frameHeight);
        this.invalidate();
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    @Override
    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Container) {
            logger.fine("OpenMapFrame: MapBean is being removed from frame");
            this.getContentPane().remove((Container)someObj);
            if (this.getJMenuBar() == ((MapPanel)someObj).getMapMenuBar()) {
                logger.fine("OpenMapFrame: Menu Bar is being removed");
                this.setJMenuBar(null);
            }
        }
        if (someObj instanceof JMenuBar && this.getJMenuBar() == (JMenuBar)someObj) {
            logger.fine("OpenMapFrame: Menu Bar is being removed");
            this.setJMenuBar(null);
        }
        if (this.equals(someObj)) {
            this.dispose();
        }
    }

    @Override
    public BeanContext getBeanContext() {
        if (this.beanContextChildSupport != null) {
            return this.beanContextChildSupport.getBeanContext();
        }
        return null;
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    @Override
    public void setProperties(String prefix, Properties setList) {
        boolean useInternalFrames;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.frameLocX = PropUtils.intFromProperties(setList, prefix + xProperty, this.frameLocX);
        this.frameLocY = PropUtils.intFromProperties(setList, prefix + yProperty, this.frameLocY);
        this.frameWidth = PropUtils.intFromProperties(setList, prefix + WidthProperty, this.frameWidth);
        this.frameHeight = PropUtils.intFromProperties(setList, prefix + HeightProperty, this.frameHeight);
        this.setTitle(setList.getProperty(prefix + TitleProperty, this.getTitle()));
        if (this.getContentPane().getComponentCount() > 0) {
            logger.fine("setting window dimensions");
            this.setPosition(this.frameWidth, this.frameHeight);
        }
        if (this.useAsInternalFrameRootPaneIfNecessary && (useInternalFrames = PropUtils.booleanFromProperties(setList, "openmap.UseInternalFrames", false)) && Environment.getInternalFrameDesktop() == null) {
            logger.fine("Setting OpenMapFrame as internal pane.");
            Environment.useInternalFrames(this.getRootPane());
        }
    }

    @Override
    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        getList.setProperty(xProperty, "" + this.getBounds().x);
        getList.setProperty(yProperty, "" + this.getBounds().y);
        getList.setProperty("openmap.Width", Integer.toString(this.getWidth()));
        getList.setProperty("openmap.Height", Integer.toString(this.getHeight()));
        return getList;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.setProperty(xProperty, "Starting X coordinate of window");
        list.setProperty(yProperty, "Starting Y coordinate of window");
        return list;
    }

    @Override
    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    @Override
    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setUseAsInternalFrameRootPaneIfNecessary(boolean val) {
        this.useAsInternalFrameRootPaneIfNecessary = true;
    }

    public boolean getUseAsInternalFrameRootPaneIfNecessary() {
        return this.useAsInternalFrameRootPaneIfNecessary;
    }

    @Override
    public void dispose() {
        MapHandler mh = (MapHandler)this.getBeanContext();
        if (mh != null) {
            mh.dispose();
        }
        this.beanContextChildSupport = null;
        this.getContentPane().removeAll();
        JMenuBar jmb = this.getJMenuBar();
        if (jmb != null) {
            jmb.removeAll();
        }
        this.setJMenuBar(null);
        this.getRootPane().remove(this);
        super.dispose();
    }
}

