/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.event;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.gui.event.EventListPresenter;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPartList;
import com.bbn.openmap.tools.icon.OMIconFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EventListIconPackage
extends OMComponent {
    protected int buttonSize = 16;
    protected ImageIcon xImage;
    protected ImageIcon clockImage;
    protected ImageIcon thumbsUpImage;
    protected ImageIcon thumbsDownImage;
    protected ImageIcon invisibleImage;
    public static final String ShowRatingsProperty = "showRatings";
    public static final String ShowPlayFilterProperty = "showPlayFilter";
    public static final String ButtonSizeProperty = "buttonSize";
    protected boolean showRatings = true;
    protected boolean showPlayFilter = true;

    public EventListIconPackage() {
        this.initIcons();
    }

    public EventListIconPackage(int buttonSize) {
        this.setButtonSize(buttonSize);
        this.initIcons();
    }

    public int getButtonSize() {
        return this.buttonSize;
    }

    public void setButtonSize(int buttonSize) {
        this.buttonSize = buttonSize;
    }

    public boolean isShowRatings() {
        return this.showRatings;
    }

    public void setShowRatings(boolean showRatings) {
        this.showRatings = showRatings;
    }

    public boolean isShowPlayFilter() {
        return this.showPlayFilter;
    }

    public void setShowPlayFilter(boolean showPlayFilter) {
        this.showPlayFilter = showPlayFilter;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showRatings = PropUtils.booleanFromProperties(props, prefix + ShowRatingsProperty, this.showRatings);
        this.showPlayFilter = PropUtils.booleanFromProperties(props, prefix + ShowPlayFilterProperty, this.showPlayFilter);
        this.buttonSize = PropUtils.intFromProperties(props, prefix + ButtonSizeProperty, this.buttonSize);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.setProperty(prefix + ShowRatingsProperty, Boolean.toString(this.showRatings));
        props.setProperty(prefix + ShowPlayFilterProperty, Boolean.toString(this.showPlayFilter));
        props.setProperty(prefix + ButtonSizeProperty, Integer.toString(this.buttonSize));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), ShowRatingsProperty, "Show Ratings", "Show controls for adding ratings to events", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), ShowPlayFilterProperty, "Show Play Filter", "Show controls for restricting playback to certain events", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), ButtonSizeProperty, "Button Size", "Pixel size for buttons", null);
        return props;
    }

    protected void initIcons() {
        DrawingAttributes greyDa = new DrawingAttributes();
        Color gry = new Color(-1717986919, true);
        greyDa.setFillPaint(gry);
        greyDa.setLinePaint(gry);
        DrawingAttributes whtDa = new DrawingAttributes();
        whtDa.setLinePaint(Color.white);
        whtDa.setStroke(new BasicStroke(2.0f));
        DrawingAttributes handsDa = new DrawingAttributes();
        handsDa.setStroke(new BasicStroke(2.0f));
        DrawingAttributes invisDa = new DrawingAttributes();
        invisDa.setLinePaint(OMColor.clear);
        invisDa.setFillPaint(OMColor.clear);
        DrawingAttributes timeDa = new DrawingAttributes();
        timeDa.setLinePaint(OMColor.blue);
        timeDa.setFillPaint(OMColor.blue);
        BasicIconPart ip = new BasicIconPart((Shape)new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0), invisDa);
        this.invisibleImage = OMIconFactory.getIcon(this.buttonSize, this.buttonSize, ip);
        IconPartList ipl = new IconPartList();
        ipl.add(new BasicIconPart((Shape)new Ellipse2D.Double(5.0, 5.0, 90.0, 90.0), greyDa));
        ipl.add(new BasicIconPart((Shape)new Line2D.Double(30.0, 30.0, 70.0, 70.0), whtDa));
        ipl.add(new BasicIconPart((Shape)new Line2D.Double(30.0, 70.0, 70.0, 30.0), whtDa));
        this.xImage = OMIconFactory.getIcon(this.buttonSize, this.buttonSize, ipl);
        ipl = new IconPartList();
        ipl.add(new BasicIconPart((Shape)new Ellipse2D.Double(10.0, 10.0, 80.0, 80.0), handsDa));
        ipl.add(new BasicIconPart((Shape)new Line2D.Double(50.0, 50.0, 50.0, 15.0), handsDa));
        ipl.add(new BasicIconPart((Shape)new Line2D.Double(50.0, 50.0, 70.0, 50.0), handsDa));
        this.clockImage = OMIconFactory.getIcon(this.buttonSize, this.buttonSize, ipl);
        DrawingAttributes goodDa = new DrawingAttributes();
        goodDa.setFillPaint(Color.green);
        goodDa.setLinePaint(Color.green.darker().darker());
        ip = new BasicIconPart((Shape)new Polygon(new int[]{50, 90, 10, 50}, new int[]{10, 90, 90, 10}, 4), goodDa);
        this.thumbsUpImage = OMIconFactory.getIcon(this.buttonSize, this.buttonSize, ip);
        DrawingAttributes badDa = new DrawingAttributes();
        badDa.setFillPaint(Color.red);
        badDa.setLinePaint(Color.red.darker().darker());
        ip = new BasicIconPart((Shape)new Polygon(new int[]{10, 90, 50, 10}, new int[]{10, 10, 90, 10}, 4), badDa);
        this.thumbsDownImage = OMIconFactory.getIcon(this.buttonSize, this.buttonSize, ip);
    }

    protected JPanel createEventControlPanel(EventListPresenter elp) {
        Dimension buttonDim = new Dimension(this.buttonSize, this.buttonSize);
        final EventListPresenter eventListPresenter = elp;
        JPanel eventControlPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        eventControlPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        c.weightx = 0.5;
        if (this.showPlayFilter) {
            JPanel timeFilterPanel = new JPanel();
            gridbag.setConstraints(timeFilterPanel, c);
            eventControlPanel.add(timeFilterPanel);
            JButton clockButton = new JButton(this.clockImage);
            clockButton.setPreferredSize(buttonDim);
            clockButton.setToolTipText("Mark event(s) for play filtering.");
            clockButton.setBorderPainted(false);
            clockButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    eventListPresenter.setSelectedEventsAttribute("PLAY_FILTER", Boolean.TRUE);
                }
            });
            timeFilterPanel.add(clockButton);
            JButton timeClearAllButton = new JButton(this.xImage);
            timeClearAllButton.setPreferredSize(buttonDim);
            timeClearAllButton.setToolTipText("Clear selected events from play filtering.");
            timeClearAllButton.setBorderPainted(false);
            timeClearAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    eventListPresenter.setSelectedEventsAttribute("PLAY_FILTER", null);
                }
            });
            timeFilterPanel.add(timeClearAllButton);
        }
        c.weightx = 1.0;
        c.insets = new Insets(2, 0, 2, 2);
        if (this.showRatings) {
            c.weightx = 0.5;
            JPanel ratingsPanel = new JPanel();
            gridbag.setConstraints(ratingsPanel, c);
            eventControlPanel.add(ratingsPanel);
            JButton thumbsUpButton = new JButton(this.thumbsUpImage);
            thumbsUpButton.setPreferredSize(buttonDim);
            thumbsUpButton.setToolTipText("Flag selected event(s) as positive.");
            thumbsUpButton.setBorderPainted(false);
            thumbsUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    eventListPresenter.setSelectedEventsAttribute("RATING", "+");
                }
            });
            ratingsPanel.add(thumbsUpButton);
            JButton thumbsDownButton = new JButton(this.thumbsDownImage);
            thumbsDownButton.setPreferredSize(buttonDim);
            thumbsDownButton.setToolTipText("Flag selected event(s) as negative.");
            thumbsDownButton.setBorderPainted(false);
            thumbsDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    eventListPresenter.setSelectedEventsAttribute("RATING", "-");
                }
            });
            ratingsPanel.add(thumbsDownButton);
            JButton clearAllRatingsButton = new JButton(this.xImage);
            clearAllRatingsButton.setPreferredSize(buttonDim);
            clearAllRatingsButton.setToolTipText("Clear ratings of selected events.");
            clearAllRatingsButton.setBorderPainted(false);
            clearAllRatingsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    eventListPresenter.setSelectedEventsAttribute("RATING", null);
                }
            });
            ratingsPanel.add(clearAllRatingsButton);
        }
        return eventControlPanel;
    }
}

