/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.image.wms.IWmsLayer;
import com.bbn.openmap.image.wms.IWmsLayerStyle;
import com.bbn.openmap.image.wms.IWmsNestedLayer;
import com.bbn.openmap.image.wms.Legend;
import com.bbn.openmap.image.wms.Version;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.proj.coords.AxisOrder;
import com.bbn.openmap.proj.coords.BoundingBox;
import com.bbn.openmap.proj.coords.CoordinateReferenceSystem;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesSupport {
    public static final String WMSPrefix = "openmap.wms.";
    public static final int FMT_GETMAP = 0;
    public static final int FMT_GETFEATUREINFO = 1;
    private Map<Integer, List<String>> formatsList = new HashMap<Integer, List<String>>();
    private String onlineResource;
    private List<String> keywordsList = null;
    private String wmsTitle = null;
    private String wmsAbstract = null;
    private int updateSequence = 1;
    private List<IWmsLayer> wmslayers = new ArrayList<IWmsLayer>();
    private String layersTitle;
    private Collection<String> crsCodes = CoordinateReferenceSystem.getCodes();

    CapabilitiesSupport(Properties props, String scheme, String hostName, int port, String path) throws WMSException {
        this.wmsTitle = props.getProperty("openmap.wms.Title", "Sample Title");
        this.wmsAbstract = props.getProperty("openmap.wms.Abstract", "Sample Abstract");
        this.layersTitle = props.getProperty("openmap.wms.LayersTitle", "Sample Layer List");
        String[] strKeywords = props.getProperty("openmap.wms.Keyword", "").split(" ");
        List<String> keywords = Arrays.asList(strKeywords);
        this.setKeywords(keywords);
        this.setUrl(scheme, hostName, port, path);
        ArrayList<String> al = new ArrayList<String>();
        this.setFormats(0, al);
        this.setFormats(1, al);
    }

    public void setUrl(String scheme, String hostName, int port, String path) {
        StringBuilder url = new StringBuilder();
        url.append(scheme);
        url.append("://");
        url.append(hostName);
        if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
            url.append(":");
            url.append(port);
        }
        url.append(path);
        this.setUrl(url.toString());
    }

    public void setUrl(String url) {
        this.onlineResource = url;
    }

    private Document generateCapabilitiesDocument(Version version) {
        Document doc = version.createCapabilitiesDocumentStart();
        Element root = doc.getDocumentElement();
        root.setAttribute("version", version.getVersionString());
        root.setAttribute("updateSequence", Integer.toString(this.updateSequence));
        Element service = doc.createElement("Service");
        service.appendChild(this.textnode(doc, "Name", version.getServiceName()));
        service.appendChild(this.textnode(doc, "Title", this.wmsTitle));
        service.appendChild(this.textnode(doc, "Abstract", this.wmsAbstract));
        if (!this.keywordsList.isEmpty()) {
            Element keywordListElement = doc.createElement("KeywordList");
            for (int i = 0; i < this.keywordsList.size(); ++i) {
                keywordListElement.appendChild(this.textnode(doc, "Keyword", this.keywordsList.get(i)));
            }
            service.appendChild(keywordListElement);
        }
        service.appendChild(this.onlineResource(doc, this.onlineResource));
        service.appendChild(this.textnode(doc, "Fees", "none"));
        service.appendChild(this.textnode(doc, "AccessConstraints", "none"));
        root.appendChild(service);
        Element capability = doc.createElement("Capability");
        Element request = doc.createElement("Request");
        request.appendChild(this.requestcap(doc, "GetCapabilities", version.getCapabiltiesFormats(), "Get", this.onlineResource));
        request.appendChild(this.requestcap(doc, "GetMap", (Collection<String>)this.formatsList.get(0), "Get", this.onlineResource));
        request.appendChild(this.requestcap(doc, "GetFeatureInfo", (Collection<String>)this.formatsList.get(1), "Get", this.onlineResource));
        capability.appendChild(request);
        Element exceptionElement = doc.createElement("Exception");
        for (String format : version.getExceptionFormats()) {
            exceptionElement.appendChild(this.textnode(doc, "Format", format));
        }
        capability.appendChild(exceptionElement);
        capability.appendChild(this.createLayersElement(doc, version));
        root.appendChild(capability);
        return doc;
    }

    private Element createLayersElement(Document doc, Version version) {
        Element layers = doc.createElement("Layer");
        layers.appendChild(this.textnode(doc, "Title", this.layersTitle));
        Iterator<String> it = this.crsCodes.iterator();
        while (it.hasNext()) {
            layers.appendChild(this.textnode(doc, version.getCoordinateReferenceSystemAcronym(), it.next()));
        }
        layers.appendChild(version.createLatLonBoundingBox(doc));
        it = this.crsCodes.iterator();
        while (it.hasNext()) {
            this.appendSRSBoundingBox(doc, layers, it.next(), version);
        }
        ArrayList<IWmsLayer> reverseLayers = new ArrayList<IWmsLayer>(this.wmslayers);
        Collections.reverse(reverseLayers);
        for (IWmsLayer wmsLayer : reverseLayers) {
            this.createLayerElement(doc, layers, wmsLayer, version);
        }
        return layers;
    }

    private void createLayerElement(Document doc, Element layers, IWmsLayer wmsLayer, Version version) {
        IWmsNestedLayer[] nestedLayers;
        IWmsLayerStyle[] styles;
        Element layerElement = (Element)this.node(doc, "Layer");
        layerElement.setAttribute("queryable", wmsLayer.isQueryable() ? "1" : "0");
        layerElement.setAttribute("opaque", "0");
        layerElement.setAttribute("noSubsets", "0");
        layerElement.appendChild(this.textnode(doc, "Name", wmsLayer.getWmsName()));
        layerElement.appendChild(this.textnode(doc, "Title", wmsLayer.getTitle()));
        if (wmsLayer.getAbstract() != null) {
            layerElement.appendChild(this.textnode(doc, "Abstract", wmsLayer.getAbstract()));
        }
        if ((styles = wmsLayer.getStyles()) != null) {
            for (int i = 0; i < styles.length; ++i) {
                IWmsLayerStyle style = styles[i];
                Element styleElement = (Element)this.node(doc, "Style");
                styleElement.appendChild(this.textnode(doc, "Name", style.getName()));
                styleElement.appendChild(this.textnode(doc, "Title", style.getTitle()));
                if (style.getAbstract() != null) {
                    styleElement.appendChild(this.textnode(doc, "Abstract", style.getAbstract()));
                }
                wmsLayer.setStyle(style.getName());
                Legend legend = wmsLayer.getLegend();
                if (legend != null) {
                    for (Dimension2D dimension2D : legend.getSizeHints()) {
                        int width = (int)dimension2D.getWidth();
                        int height = (int)dimension2D.getHeight();
                        String format = "image/png";
                        Element legendURLElement = (Element)this.node(doc, "LegendURL");
                        legendURLElement.setAttribute("width", Integer.toString(width));
                        legendURLElement.setAttribute("height", Integer.toString(height));
                        legendURLElement.appendChild(this.textnode(doc, "Format", format));
                        StringBuilder url = new StringBuilder();
                        url.append(this.onlineResource);
                        url.append("?").append("SERVICE").append("=WMS");
                        url.append("&").append("VERSION").append("=");
                        url.append(version.getVersionString());
                        url.append("&").append("REQUEST").append("=");
                        url.append("GetLegendGraphic");
                        url.append("&").append("LAYER").append("=");
                        url.append(wmsLayer.getWmsName());
                        url.append("&").append("STYLE").append("=").append(style.getName());
                        url.append("&").append("FORMAT").append("=").append(format);
                        url.append("&").append("WIDTH").append("=").append(width);
                        url.append("&").append("HEIGHT").append("=").append(height);
                        legendURLElement.appendChild(this.onlineResource(doc, url.toString()));
                        styleElement.appendChild(legendURLElement);
                    }
                }
                layerElement.appendChild(styleElement);
            }
        }
        if (wmsLayer instanceof IWmsNestedLayer && (nestedLayers = ((IWmsNestedLayer)wmsLayer).getNestedLayers()) != null) {
            for (int i = 0; i < nestedLayers.length; ++i) {
                this.createLayerElement(doc, layerElement, nestedLayers[i], version);
            }
        }
        layers.appendChild(layerElement);
    }

    public void incUpdateSequence() {
        ++this.updateSequence;
    }

    public boolean setFormats(int request, Collection<String> formats) {
        switch (request) {
            case 0: 
            case 1: {
                this.formatsList.put(request, new ArrayList<String>(formats));
                return true;
            }
        }
        return false;
    }

    public void setOnlineResource(String url) {
        this.onlineResource = url;
    }

    public void setKeywords(List<String> keywordsList) {
        this.keywordsList = keywordsList;
    }

    public void addLayer(IWmsLayer wmsLayer) {
        this.wmslayers.add(wmsLayer);
    }

    public void setLayersTitle(String title) {
        this.layersTitle = title;
    }

    private void appendSRSBoundingBox(Document doc, Element layers, String crsCode, Version version) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.getForCode(crsCode);
        BoundingBox bbox = crs.getBoundingBox();
        if (bbox == null) {
            return;
        }
        Element e1 = (Element)this.node(doc, "BoundingBox");
        e1.setAttribute(version.getCoordinateReferenceSystemAcronym(), crs.getCode());
        if (version.usesAxisOrder() && crs.getAxisOrder() == AxisOrder.northBeforeEast) {
            e1.setAttribute("minx", Double.toString(bbox.getMinY()));
            e1.setAttribute("miny", Double.toString(bbox.getMinX()));
            e1.setAttribute("maxx", Double.toString(bbox.getMaxY()));
            e1.setAttribute("maxy", Double.toString(bbox.getMaxX()));
        } else {
            e1.setAttribute("minx", Double.toString(bbox.getMinX()));
            e1.setAttribute("miny", Double.toString(bbox.getMinY()));
            e1.setAttribute("maxx", Double.toString(bbox.getMaxX()));
            e1.setAttribute("maxy", Double.toString(bbox.getMaxY()));
        }
        layers.appendChild(e1);
    }

    String generateXMLString(Version version) throws IOException, TransformerConfigurationException, TransformerException {
        StringWriter strWriter = new StringWriter();
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.setOutputProperty("version", "1.0");
        tr.setOutputProperty("encoding", "UTF-8");
        Document document = this.generateCapabilitiesDocument(version);
        if (document.getDoctype() != null) {
            tr.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
        }
        tr.transform(new DOMSource(document), new StreamResult(strWriter));
        return strWriter.toString();
    }

    private Node textnode(Document doc, String Name2, String text) {
        Element e1 = doc.createElement(Name2);
        if (text == null) {
            text = "";
        }
        Text n = doc.createTextNode(text);
        e1.appendChild(n);
        return e1;
    }

    private Node node(Document doc, String Name2) {
        return doc.createElement(Name2);
    }

    private Node onlineResource(Document doc, String url) {
        Element onlineResource = doc.createElement("OnlineResource");
        onlineResource.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        onlineResource.setAttribute("xlink:type", "simple");
        onlineResource.setAttribute("xlink:href", url);
        return onlineResource;
    }

    private Node requestcap(Document doc, String requestName, Collection<String> formatList, String methodName, String url) {
        Element methodNode = doc.createElement(methodName);
        methodNode.appendChild(this.onlineResource(doc, url));
        Element httpNode = doc.createElement("HTTP");
        httpNode.appendChild(methodNode);
        Element dcpTypeNode = doc.createElement("DCPType");
        dcpTypeNode.appendChild(httpNode);
        Element requestNameNode = doc.createElement(requestName);
        for (String format : formatList) {
            requestNameNode.appendChild(this.textnode(doc, "Format", format));
        }
        requestNameNode.appendChild(dcpTypeNode);
        return requestNameNode;
    }
}

