/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.event;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.event.OMEventHandler;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.event.EventImporter;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.time.TemporalOMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.time.RealTimeHandler;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.time.TimeBoundsHandler;
import com.bbn.openmap.time.TimeBoundsProvider;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.PropUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLayer
extends OMGraphicHandlerLayer
implements DataBoundsProvider,
TimeBoundsProvider,
TimeEventListener,
OMEventHandler {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.event.EventLayer");
    public static final String ImporterProperty = "importer";
    protected EventImporter importer = null;
    protected DataBounds dataBounds = null;
    protected TimeBounds timeBounds;
    protected long time;
    protected String mode;
    protected boolean active = false;
    protected List<TimeBoundsHandler> timeBoundsHandlers = new ArrayList<TimeBoundsHandler>();
    protected LinkedList<OMEvent> events = new LinkedList();
    protected LinkedList<OMEvent> filters = new LinkedList();

    public EventLayer() {
        this.dataBounds = new DataBounds();
    }

    @Override
    public synchronized OMGraphicList prepare() {
        Projection p = this.getProjection();
        TemporalOMGraphicList scenarioGraphics = null;
        OMGraphicList list = this.getList();
        if (p != null) {
            boolean DEBUG = logger.isLoggable(Level.FINE);
            if (list == null || !(list instanceof TemporalOMGraphicList)) {
                scenarioGraphics = this.createData();
                if (scenarioGraphics == null) {
                    return null;
                }
            } else {
                scenarioGraphics = new TemporalOMGraphicList(list);
            }
            long currentTime = this.getTime();
            if (DEBUG) {
                logger.fine("EventLayer (" + this.getName() + ") snapshot at " + currentTime);
            }
            scenarioGraphics.generate(p, currentTime);
            if (DEBUG) {
                logger.fine("EventLayer (" + this.getName() + ") setting list of " + scenarioGraphics.size() + " scenario graphics");
            }
        }
        return scenarioGraphics;
    }

    public synchronized TemporalOMGraphicList createData() {
        if (this.importer != null) {
            return this.importer.createData(this);
        }
        return null;
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String importerClass = properties.getProperty(prefix + ImporterProperty);
        if (importerClass != null) {
            this.importer = (EventImporter)ComponentFactory.create(importerClass, prefix, properties);
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.importer != null) {
            props.put(prefix + ImporterProperty, this.importer.getClass().getName());
        }
        if (this.importer instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.importer)).getProperties(props);
        }
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        PropUtils.setI18NPropertyInfo(this.i18n, list, this.getClass(), ImporterProperty, "Data Importer", "Class name of data importer", null);
        if (this.importer instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.importer)).getPropertyInfo(list);
        }
        return list;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public DataBounds getDataBounds() {
        return this.dataBounds;
    }

    @Override
    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof TimeBoundsHandler) {
            this.addTimeBoundsHandler((TimeBoundsHandler)someObj);
        }
        if (someObj instanceof RealTimeHandler) {
            ((RealTimeHandler)someObj).addTimeEventListener(this);
        }
    }

    @Override
    public void addTimeBoundsHandler(TimeBoundsHandler tbh) {
        logger.fine("found TimeBoundsHandler: " + tbh.getClass().getName());
        this.timeBoundsHandlers.add(tbh);
    }

    protected void setTimeBounds(TimeBounds tb) {
        this.timeBounds = tb;
        if (this.active) {
            this.callForTimeBoundsReset();
        }
    }

    @Override
    public TimeBounds getTimeBounds() {
        if (this.active) {
            return this.timeBounds;
        }
        return null;
    }

    @Override
    public void handleTimeBounds(TimeBounds tb) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (this.timeBounds != null) {
            this.callForTimeBoundsReset();
        }
    }

    @Override
    public void removeTimeBoundsHandler(TimeBoundsHandler tbh) {
        this.timeBoundsHandlers.remove(tbh);
    }

    @Override
    public void updateTime(TimeEvent te) {
        this.time = te.getSystemTime();
        if (this.active) {
            this.setList(this.prepare());
            this.repaint();
        }
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public List<OMEvent> getEventList() {
        return this.getEventList(null);
    }

    @Override
    public List<OMEvent> getEventList(List filters) {
        if (this.active) {
            return this.events;
        }
        return null;
    }

    @Override
    public Boolean getFilterState(String filterName) {
        return this.isVisible() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public List getFilters() {
        return this.filters;
    }

    @Override
    public List<OMEvent> getMacroFilteredList(Collection eventCollection) {
        return this.events;
    }

    @Override
    public void setFilterState(String filterName, Boolean state) {
    }

    public void callForTimeBoundsReset() {
        for (TimeBoundsHandler tbh : this.timeBoundsHandlers) {
            tbh.resetTimeBounds();
        }
    }

    @Override
    public void setVisible(boolean setting) {
        super.setVisible(setting);
        this.setActive(setting);
    }
}

