/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.imageTile;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.MapTileRequester;
import com.bbn.openmap.dataAccess.mapTile.ServerMapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MapTileLayer
extends OMGraphicHandlerLayer
implements MapTileRequester {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.imageTile.TileLayer");
    public static final String TILE_FACTORY_CLASS_PROPERTY = "tileFactory";
    public static final String INCREMENTAL_UPDATES_PROPERTY = "incrementalUpdates";
    public static final String ZOOM_LEVEL_PROPERTY = "zoomLevel";
    public static final String DATA_ATTRIBUTION_PROPERTY = "attribution";
    public static final String SAVE_CACHE_PROPERTY = "saveCache";
    protected MapTileFactory tileFactory;
    protected boolean incrementalUpdates = false;
    protected int zoomLevel = -1;
    protected String attribution = null;
    protected boolean saveCache = true;
    protected DrawingAttributes attributionAttributes = DrawingAttributes.getDefaultClone();

    public MapTileLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setTileFactory(new StandardMapTileFactory());
        this.setInterruptable(false);
    }

    public MapTileLayer(MapTileFactory tileFactory) {
        this();
        this.tileFactory = tileFactory;
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        if (projection == null) {
            return null;
        }
        if (this.tileFactory != null) {
            return this.tileFactory.getTiles(projection, this.zoomLevel, new OMGraphicList());
        }
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
        OMText attrib = this.getAttributionGraphic();
        if (attrib != null) {
            attrib.render(g);
        }
    }

    protected OMText getAttributionGraphic() {
        Projection proj = this.getProjection();
        if (this.attribution != null && proj != null) {
            OMText attText = new OMText(10, proj.getHeight() - 10, this.attribution, 0);
            if (this.attributionAttributes != null) {
                this.attributionAttributes.setTo(attText);
            }
            attText.generate(proj);
            return attText;
        }
        return null;
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    public void setProperties(String prefix, Properties props) {
        block8: {
            super.setProperties(prefix, props);
            prefix = PropUtils.getScopedPropertyPrefix(prefix);
            this.attribution = props.getProperty(prefix + DATA_ATTRIBUTION_PROPERTY, this.attribution);
            this.attributionAttributes.setProperties(prefix, props);
            String tileFactoryClassString = props.getProperty(prefix + TILE_FACTORY_CLASS_PROPERTY);
            if (tileFactoryClassString != null) {
                MapTileFactory itf = (MapTileFactory)ComponentFactory.create(tileFactoryClassString, prefix, props);
                if (itf != null) {
                    this.setTileFactory(itf);
                }
            } else {
                String rootDirString = props.getProperty(prefix + "rootDir");
                if (rootDirString != null) {
                    try {
                        new URL(rootDirString);
                        if (!(this.getTileFactory() instanceof ServerMapTileFactory)) {
                            this.setTileFactory(new ServerMapTileFactory(rootDirString));
                        }
                    }
                    catch (MalformedURLException e) {
                        if (this.getTileFactory() instanceof StandardMapTileFactory) break block8;
                        this.setTileFactory(new StandardMapTileFactory());
                    }
                }
            }
        }
        if (this.tileFactory instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.tileFactory)).setProperties(prefix, props);
        }
        this.incrementalUpdates = PropUtils.booleanFromProperties(props, prefix + INCREMENTAL_UPDATES_PROPERTY, this.incrementalUpdates);
        this.setZoomLevel(PropUtils.intFromProperties(props, prefix + ZOOM_LEVEL_PROPERTY, this.zoomLevel));
        this.saveCache = PropUtils.booleanFromProperties(props, prefix + SAVE_CACHE_PROPERTY, this.saveCache);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.tileFactory != null) {
            props.put(prefix + TILE_FACTORY_CLASS_PROPERTY, this.tileFactory.getClass().getName());
            if (this.tileFactory instanceof PropertyConsumer) {
                ((PropertyConsumer)((Object)this.tileFactory)).getProperties(props);
            }
        }
        props.put(prefix + INCREMENTAL_UPDATES_PROPERTY, Boolean.toString(this.incrementalUpdates));
        props.put(prefix + ZOOM_LEVEL_PROPERTY, Integer.toString(this.zoomLevel));
        props.put(prefix + DATA_ATTRIBUTION_PROPERTY, PropUtils.unnull(this.attribution));
        props.put(prefix + SAVE_CACHE_PROPERTY, Boolean.toString(this.saveCache));
        this.attributionAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), ZOOM_LEVEL_PROPERTY, "Zoom Level", "Force zoom level for queries (-1 is no forcing)", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), DATA_ATTRIBUTION_PROPERTY, "Attribution", "Attribution for data source", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), SAVE_CACHE_PROPERTY, "Disable Tile Factory Reset", "Disable tile factory reset on layer remove", null);
        if (this.tileFactory instanceof StandardMapTileFactory) {
            ((StandardMapTileFactory)this.tileFactory).getPropertyInfo(props);
            props.put("initProperties", ((StandardMapTileFactory)this.tileFactory).getInitPropertiesOrder() + " " + ZOOM_LEVEL_PROPERTY + " " + DATA_ATTRIBUTION_PROPERTY + " " + SAVE_CACHE_PROPERTY);
        } else {
            props.put("initProperties", "rootDir fileExt zoomLevel attribution saveCache");
        }
        return props;
    }

    public void removed(Container cont) {
        MapTileFactory tileFactory = this.getTileFactory();
        if (tileFactory != null && !this.saveCache) {
            tileFactory.reset();
        }
    }

    public MapTileFactory getTileFactory() {
        return this.tileFactory;
    }

    public void setTileFactory(MapTileFactory tileFactory) {
        logger.fine("setting tile factory to: " + tileFactory.getClass().getName());
        tileFactory.setMapTileRequester(this);
        this.tileFactory = tileFactory;
        this.doPrepare();
    }

    public boolean isIncrementalUpdates() {
        return this.incrementalUpdates;
    }

    public void setIncrementalUpdates(boolean incrementalUpdates) {
        this.incrementalUpdates = incrementalUpdates;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (this.getTileFactory() instanceof ServerMapTileFactory) {
            JPanel clearCachePanel = new JPanel(new BorderLayout());
            clearCachePanel.add((Component)new JPanel(), "West");
            clearCachePanel.add((Component)new JPanel(), "East");
            JButton clearButton = new JButton(this.i18n.get(MapTileLayer.class, "clearCacheLabel", "Clear Tile Cache"));
            clearCachePanel.add((Component)clearButton, "Center");
            clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String query = MapTileLayer.this.i18n.get(MapTileLayer.class, "mapTileLayerDeleteCacheQuery", "Delete tiles on disk? Click OK to delete...");
                    int dialogResult = JOptionPane.showConfirmDialog(null, query, "Warning", 2);
                    if (dialogResult == 0) {
                        MapTileLayer.this.clearCache();
                    }
                }
            });
            panel.add(clearCachePanel);
        }
        panel.add(this.getDefaultSettingsPanel(this.getClass(), this.getTransparency()));
        return panel;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public DrawingAttributes getAttributionAttributes() {
        return this.attributionAttributes;
    }

    public void setAttributionAttributes(DrawingAttributes attributionAttributes) {
        this.attributionAttributes = attributionAttributes;
    }

    public boolean shouldContinue() {
        return !this.isInterruptable() || !this.isCancelled();
    }

    public void listUpdated() {
        if (this.incrementalUpdates) {
            this.repaint();
        }
    }

    public void clearCache() {
        MapTileFactory mtf = this.getTileFactory();
        if (mtf != null) {
            mtf.reset();
        }
    }
}

