/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrame;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfFrameCacheHandler
extends CacheHandler
implements RpfFrameProvider {
    public static final int FRAME_CACHE_SIZE = 5;
    protected RpfColortable colortable;
    protected boolean Dchum = true;
    protected boolean outlineChum = false;
    protected RpfTocHandler[] tocs;
    protected RpfViewAttributes viewAttributes = new RpfViewAttributes();

    public RpfFrameCacheHandler(String[] RpfPaths) {
        this(RpfPaths, 5);
    }

    public RpfFrameCacheHandler(String[] RpfPaths, int max_size) {
        super(max_size);
        this.tocs = RpfFrameCacheHandler.createTocHandlers(RpfPaths);
        this.colortable = new RpfColortable();
    }

    public RpfFrameCacheHandler(RpfTocHandler[] tocHandlers) {
        this.tocs = tocHandlers;
        this.colortable = new RpfColortable();
    }

    @Override
    public boolean needViewAttributeUpdates() {
        return false;
    }

    @Override
    public void setViewAttributes(RpfViewAttributes va) {
        this.viewAttributes = va;
        if (va != null && this.colortable != null) {
            this.colortable.setOpaqueness(va.opaqueness);
            this.colortable.setNumColors(va.numberOfColors);
        }
    }

    public Vector<RpfCoverageBox> getCatalogCoverage(double ullat, double ullon, double lrlat, double lrlon, Projection proj, String chartSeries) {
        Vector<RpfCoverageBox> coverages = new Vector<RpfCoverageBox>();
        for (RpfTocHandler toc : this.tocs) {
            if (toc.hasChanged()) {
                toc.reload();
            }
            if (!toc.isValid()) continue;
            toc.getCatalogCoverage(ullat, ullon, lrlat, lrlon, proj, chartSeries, coverages);
        }
        return coverages;
    }

    @Override
    public float getCalculatedCoverage(double ullat, double ullon, double lrlat, double lrlon, Projection p, String chartSeries) {
        int x;
        int y;
        RpfCoverageBox rcb;
        int i;
        if (chartSeries.equalsIgnoreCase("ANY")) {
            return 0.0f;
        }
        List results = this.getCatalogCoverage(ullat, ullon, lrlat, lrlon, p, chartSeries);
        int size = ((Vector)results).size();
        if (size == 0) {
            return 0.0f;
        }
        double frameLatInterval = Double.MAX_VALUE;
        double frameLonInterval = Double.MAX_VALUE;
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)((Vector)results).elementAt(i);
            if (rcb.subframeLatInterval < frameLatInterval) {
                frameLatInterval = rcb.subframeLatInterval;
            }
            if (!(rcb.subframeLonInterval < frameLonInterval)) continue;
            frameLonInterval = rcb.subframeLonInterval;
        }
        if (frameLatInterval == Double.MAX_VALUE || frameLonInterval == Double.MAX_VALUE) {
            return 0.0f;
        }
        int numHFrames = (int)Math.ceil((lrlon - ullon) / frameLonInterval);
        int numVFrames = (int)Math.ceil((ullat - lrlat) / frameLatInterval);
        boolean[][] coverage = new boolean[numHFrames][numVFrames];
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)((Vector)results).elementAt(i);
            if (rcb.percentCoverage == 100.0f) {
                return 1.0f;
            }
            for (y = 0; y < numVFrames; ++y) {
                for (x = 0; x < numHFrames; ++x) {
                    float yFrameLoc = (float)(lrlat + (double)y * frameLatInterval);
                    float xFrameLoc = (float)(ullon + (double)x * frameLonInterval);
                    if (coverage[x][y] || !rcb.within(yFrameLoc, xFrameLoc)) continue;
                    coverage[x][y] = true;
                }
            }
        }
        float count = 0.0f;
        for (y = 0; y < numVFrames; ++y) {
            for (x = 0; x < numHFrames; ++x) {
                if (!coverage[x][y]) continue;
                count += 1.0f;
            }
        }
        return count / (float)(numHFrames * numVFrames);
    }

    public Vector<RpfCoverageBox> getCoverage(double ullat, double ullon, double lrlat, double lrlon, Projection proj) {
        Debug.message("rpf", "RpfFrameCacheHandler: getCoverage()");
        Vector<RpfCoverageBox> coverageBoxes = new Vector<RpfCoverageBox>();
        int count = -1;
        for (RpfTocHandler toc : this.tocs) {
            ++count;
            if (toc.hasChanged()) {
                toc.reload();
            }
            if (!toc.isValid()) continue;
            List<RpfTocEntry> coverageEntries = toc.getBestCoverageEntry(ullat, ullon, lrlat, lrlon, proj, this.viewAttributes);
            for (RpfTocEntry currentEntry : coverageEntries) {
                if (currentEntry != null) {
                    if (Debug.debugging("rpftoc")) {
                        System.out.println("RFCH: Toc " + count + " returned an entry");
                    }
                    RpfCoverageBox currentCoverage = currentEntry.coverage;
                    Object[] coverageArray = new Object[coverageBoxes.size()];
                    coverageBoxes.copyInto(coverageArray);
                    coverageBoxes.removeAllElements();
                    int size = coverageArray.length;
                    if (size == 0) {
                        coverageBoxes.addElement(currentCoverage);
                        continue;
                    }
                    boolean addedCurrent = false;
                    boolean okToAddCurrent = true;
                    for (int j = 0; j < size; ++j) {
                        RpfCoverageBox rcb = (RpfCoverageBox)coverageArray[j];
                        if (!addedCurrent) {
                            if (j == 0) {
                                if (RpfFrameCacheHandler.scaleDifference(proj, currentCoverage) <= RpfFrameCacheHandler.scaleDifference(proj, rcb) && currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                    coverageBoxes.addElement(currentCoverage);
                                    addedCurrent = true;
                                    if (currentCoverage.scale != rcb.scale) break;
                                    coverageBoxes.addElement(rcb);
                                    continue;
                                }
                                coverageBoxes.addElement(rcb);
                                continue;
                            }
                            if (currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                if (coverageBoxes.get((int)0).scale == currentCoverage.scale) {
                                    coverageBoxes.add(currentCoverage);
                                    addedCurrent = true;
                                } else {
                                    okToAddCurrent = false;
                                }
                                coverageBoxes.add(rcb);
                                continue;
                            }
                            coverageBoxes.add(rcb);
                            continue;
                        }
                        if (coverageBoxes.get((int)0).scale != rcb.scale) continue;
                        coverageBoxes.add(rcb);
                    }
                    if (addedCurrent || !okToAddCurrent || coverageBoxes.get((int)0).scale != currentCoverage.scale) continue;
                    coverageBoxes.add(currentCoverage);
                    continue;
                }
                if (!Debug.debugging("rpftoc")) continue;
                System.out.println("RFCH: Toc " + count + " did NOT return an entry");
            }
        }
        return coverageBoxes;
    }

    @Override
    public String getSubframeAttributes(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        return frame.getReport(x, y, frameEntry, entry.Cib);
    }

    @Override
    public int[] getSubframeData(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        return frame.decompressSubframe(x, y, this.colortable);
    }

    @Override
    public RpfIndexedImageData getRawSubframeData(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        RpfIndexedImageData riid = new RpfIndexedImageData();
        riid.imageData = frame.decompressSubframe(x, y);
        riid.colortable = this.colortable.colors;
        return riid;
    }

    protected void checkColortable(RpfFrame frame, RpfFrameEntry frameEntry, RpfTocEntry entry, int tocNumber, int entryNumber) {
        if (Debug.debugging("rpf")) {
            Debug.output("RpfFrameCacheHandler: getting new colors");
            Debug.output("RpfFrameCacheHandler: getting CIB colors = " + entry.Cib);
        }
        this.colortable.setFrom(frame.getColortable());
        this.colortable.setCib(entry.Cib);
        this.colortable.setATOCIndexes(tocNumber, entryNumber);
        this.colortable.zone = entry.zone;
        this.colortable.seriesCode = entry.info.seriesCode;
        if (this.viewAttributes != null) {
            this.colortable.setOpaqueness(this.viewAttributes.opaqueness);
        }
    }

    public static RpfTocHandler[] createTocHandlers(String[] RpfPaths) {
        RpfTocHandler[] tocs = new RpfTocHandler[RpfPaths != null ? RpfPaths.length : 0];
        if (RpfPaths != null) {
            for (int i = 0; i < tocs.length; ++i) {
                tocs[i] = new RpfTocHandler(RpfPaths[i], i);
            }
        }
        return tocs;
    }

    public Object get(RpfFrameEntry rfe) {
        CacheObject ret = this.searchCache(rfe.framePath);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(rfe);
        if (ret == null) {
            return null;
        }
        if (Debug.debugging("rpfdetail")) {
            System.out.println(rfe);
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    @Override
    public CacheObject load(Object key) {
        if (key instanceof RpfFrameEntry) {
            RpfFrame frame;
            RpfFrameEntry rfe = (RpfFrameEntry)key;
            if (!rfe.exists) {
                if (Debug.debugging("rpf")) {
                    System.out.println("RpfFrameCacheHandler: Frame doesn't exist!: " + rfe.framePath);
                }
                return null;
            }
            if (Debug.debugging("rpf")) {
                Debug.output("RpfFrameCacheHandler: Loading Frame " + rfe.framePath);
            }
            if ((frame = new RpfFrame(rfe)).isValid()) {
                return new CacheObject(rfe.framePath, frame);
            }
            if (Debug.debugging("rpf")) {
                Debug.error("RpfFrameCacheHandler:  Couldn't find frame /" + rfe.framePath + "/ (" + rfe.framePath.length() + " chars)");
            }
            rfe.exists = false;
        }
        return null;
    }

    public void resizeCache(int max_size) {
        this.resetCache(max_size);
    }

    @Override
    public void resetCache() {
        super.resetCache();
        Debug.message("rpf", "RpfFrameCacheHandler: reset frame cache.");
    }

    public static float scaleDifference(Projection proj, RpfCoverageBox box) {
        return Math.abs(proj.getScale() - box.scale);
    }

    public RpfColortable getColortable() {
        return this.colortable;
    }

    public void setColortable(RpfColortable colortable) {
        this.colortable = colortable;
    }
}

