/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpfProductInfo implements RpfConstants
{
    GN("GN", "GNC", "1:5,000,000", 5000000.0f, "Global Navigation Chart", "CADRG"),
    JN("JN", "JNC", "1:2,000,000", 2000000.0f, "Jet Navigation Chart", "CADRG"),
    ON("ON", "ONC", "1:1,000,000", 1000000.0f, "Operational Navigation Chart", "CADRG"),
    TP("TP", "TPC", "1:500,000", 500000.0f, "Tactical Pilotage Chart", "CADRG"),
    LF("LF", "LFC-FR (Day)", "1:500,000", 500000.0f, "Low Flying Chart (Day) - Host Nation", "CADRG"),
    JG("JG", "JOG", "1:250,000", 250000.0f, "Joint Operations Graphic", "CADRG"),
    JA("JA", "JOG-A", "1:250,000", 250000.0f, "Joint Operations Graphic - Air", "CADRG"),
    JR("JR", "JOG-R", "1:250,000", 250000.0f, "Joint Operations Graphic - Radar", "CADRG"),
    TF("TF", "TFC", "1:250,000", 250000.0f, "Transit Flying Chart (UK)", "CADRG"),
    AT("AT", "ATC", "1:200,000", 200000.0f, "Series 200 Air Target Chart", "CADRG"),
    TC("TC", "TLM 100", "1:100,000", 100000.0f, "Topographic Line Map 1:100,000 scale", "CADRG"),
    TL("TL", "TLM 50", "1:50,000", 50000.0f, "Topographic Line Map", "CADRG"),
    TT("TT", "TLM 25", "1:25,000", 25000.0f, "Topographic Line Map 1:25,000 scale", "CADRG"),
    TQ("TQ", "TLM 24", "1:24,000", 24000.0f, "Topographic Line Map 1:24,000 scale", "CADRG"),
    HA("HA", "HA", "Various", -1.0f, "Harbor and Approach Charts", "CADRG"),
    CO("CO", "CO", "Various", -1.0f, "Coastal Charts", "CADRG"),
    OA("OA", "OPEAREA", "Various", -1.0f, "Naval Range Operating Area Chart", "CADRG"),
    CG("CG", "CG", "Various", -1.0f, "City Graphics", "CADRG"),
    C1("C1", "CG", "1:10,000", 10000.0f, "City Graphics", "CADRG"),
    C2("C2", "CG", "1:10,560", 10560.0f, "City Graphics", "CADRG"),
    C3("C3", "CG", "1:11,000", 11000.0f, "City Graphics", "CADRG"),
    C4("C4", "CG", "1:11,800", 11800.0f, "City Graphics", "CADRG"),
    C5("C5", "CG", "1:12,000", 12000.0f, "City Graphics", "CADRG"),
    C6("C6", "CG", "1:12,500", 12500.0f, "City Graphics", "CADRG"),
    C7("C7", "CG", "1:12,800", 12800.0f, "City Graphics", "CADRG"),
    C8("C8", "CG", "1:14,000", 14000.0f, "City Graphics", "CADRG"),
    C9("C9", "CG", "1:14,700", 14700.0f, "City Graphics", "CADRG"),
    CA("CA", "CG", "1:15,000", 15000.0f, "City Graphics", "CADRG"),
    CB("CB", "CG", "1:15,500", 15500.0f, "City Graphics", "CADRG"),
    CC("CC", "CG", "1:16,000", 16000.0f, "City Graphics", "CADRG"),
    CD("CD", "CG", "1:16,666", 16666.0f, "City Graphics", "CADRG"),
    CE("CE", "CG", "1:17,000", 17000.0f, "City Graphics", "CADRG"),
    CF("CF", "CG", "1:17,500", 17500.0f, "City Graphics", "CADRG"),
    CH("CH", "CG", "1:18,000", 18000.0f, "City Graphics", "CADRG"),
    CJ("CJ", "CG", "1:20,000", 20000.0f, "City Graphics", "CADRG"),
    CK("CK", "CG", "1:21,000", 21000.0f, "City Graphics", "CADRG"),
    CL("CL", "CG", "1:21,120", 21120.0f, "City Graphics", "CADRG"),
    CN("CN", "CG", "1:22,000", 22000.0f, "City Graphics", "CADRG"),
    CP("CP", "CG", "1:23,000", 23000.0f, "City Graphics", "CADRG"),
    CQ("CQ", "CG", "1:25,000", 25000.0f, "City Graphics", "CADRG"),
    CR("CR", "CG", "1:26,000", 26000.0f, "City Graphics", "CADRG"),
    CS("CS", "CG", "1:35,000", 35000.0f, "City Graphics", "CADRG"),
    CT("CT", "CG", "1:36,000", 36000.0f, "City Graphics", "CADRG"),
    CM("CM", "CM", "Various", -1.0f, "Combat Charts", "CADRG"),
    A1("A1", "CM", "1:10,000", 10000.0f, "Combat Graphics, 1:10,000 scale", "CADRG"),
    A2("A2", "CM", "1:25,000", 25000.0f, "Combat Graphics, 1:25,000 scale", "CADRG"),
    A3("A3", "CM", "1:50,000", 50000.0f, "Combat Graphics, 1:50,000 scale", "CADRG"),
    A4("A4", "CM", "1:100,000", 100000.0f, "Combat Graphics, 1:100,000 scale", "CADRG"),
    MM("MM", "", "Various", -1.0f, "(Miscellaneous Maps & Charts)", "CADRG"),
    IM("IM", "", "10m", 66666.0f, "Imagery, 10 meter resolution", "CIB"),
    I1("I1", "", "10m", 66666.0f, "Imagery, 10 meter resolution", "CIB"),
    I2("I2", "", "5m", 33333.0f, "Imagery, 5 meter resolution", "CIB"),
    I3("I3", "", "2m", 13333.2f, "Imagery, 2 meter resolution", "CIB"),
    I4("I4", "", "1m", 6666.0f, "Imagery, 1 meter resolution", "CIB"),
    D1("D1", "", "100m", -1.0f, "Elevation Data from DTED level 1", "CDTED"),
    D2("D2", "", "30m", -1.0f, "Elevation Data from DTED level 2", "CDTED"),
    OV("OV", "Overview", "Various", -1.0f, "Overview Image", "CADRG"),
    OI("OI", "Overview", "Various", -1.0f, "Overview Image", "CADRG"),
    LG("LG", "Legend", "Various", -1.0f, "Legend Data", "CADRG"),
    UK("UK", "Unknown", "Various", -1.0f, "Unknown", "CADRG"),
    DT("DT", "CDTED", "100M", 666666.0f, "Compressed DTED", "CDTED"),
    EG("EG", "NARC", "1:11M", 1.1E7f, "North Atlantic Route Chart", "CADRG"),
    ES("ES", "SEC", "1:500,000", 500000.0f, "VFR Sectional", "CADRG"),
    ET("ET", "SEC", "1:250,000", 250000.0f, "VFR Sectional Insets", "CADRG"),
    F1("F1", "TFC-1", "1:250,000", 250000.0f, "Transit Flying Chart (TBD #1)", "CADRG"),
    F2("F2", "TFC-2", "1:250,000", 250000.0f, "Transit Flying Chart (TBD #2)", "CADRG"),
    F3("F3", "TFC-3", "1:250,000", 250000.0f, "Transit Flying Chart (TBD #3)", "CADRG"),
    F4("F4", "TFC-4", "1:250,000", 250000.0f, "Transit Flying Chart (TBD #4)", "CADRG"),
    F5("F5", "TFC-5", "1:250,000", 250000.0f, "Transit Flying Chart (TBD #5)", "CADRG"),
    I5("I5", "", ".5m", 3333.0f, "Imagery, .5 (half) meter resolution", "CIB"),
    IV("IV", "", "Various", -1.0f, "Imagery, > 10 meter resolution", "CIB"),
    JO("JO", "OPG", "1:250,000", 250000.0f, "Operations Planning Graphic", "CADRG"),
    K1("K1", "ICM", "1:8,000", 8000.0f, "Image City Maps", "CADRG"),
    K2("K2", "ICM", "1:10,000", 10000.0f, "Image City Maps", "CADRG"),
    K3("K3", "ICM", "1:10,560", 10560.0f, "Image City Maps", "CADRG"),
    K7("K7", "ICM", "1:12,500", 12500.0f, "Image City Maps", "CADRG"),
    K8("K8", "ICM", "1:12,800", 12000.0f, "Image City Maps", "CADRG"),
    KB("KB", "ICM", "1:15,000", 15000.0f, "Image City Maps", "CADRG"),
    KE("KE", "ICM", "1:16,666", 16666.0f, "Image City Maps", "CADRG"),
    KM("KM", "ICM", "1:21,120", 21120.0f, "Image City Maps", "CADRG"),
    KR("KR", "ICM", "1:25,000", 25000.0f, "Image City Maps", "CADRG"),
    KS("KS", "ICM", "1:26,000", 26000.0f, "Image City Maps", "CADRG"),
    KU("KU", "ICM", "1:36,000", 36000.0f, "Image City Maps", "CADRG"),
    L1("L1", "LFC-1", "1:500,000", 500000.0f, "Low Flying Chart (TBD #1)", "CADRG"),
    L2("L2", "LFC-2", "1:500,000", 500000.0f, "Low Flying Chart (TBD #2)", "CADRG"),
    L3("L3", "LFC-3", "1:500,000", 500000.0f, "Low Flying Chart (TBD #3)", "CADRG"),
    L4("L4", "LFC-4", "1:500,000", 500000.0f, "Low Flying Chart (TBD #4)", "CADRG"),
    L5("L5", "LFC-5", "1:500,000", 500000.0f, "Low Flying Chart (TBD #5)", "CADRG"),
    LN("LN", "LFC (Night)", "1:500,000", 500000.0f, "Low Flying Chart (Night) - Host Nation", "CADRG"),
    M1("M1", "MIM", "Various", -1.0f, "Military Installation Map (TBD #1)", "CADRG"),
    M2("M2", "MIM", "Various", -1.0f, "Military Installation Map (TBD #2)", "CADRG"),
    MH("MH", "MIM", "1:25,000", 25000.0f, "Military Installation Maps", "CADRG"),
    MI("MI", "MIM", "1:50,000", 50000.0f, "Military Installation Maps", "CADRG"),
    MJ("MJ", "MIM", "1:100,000", 100000.0f, "Military Installation Maps", "CADRG"),
    OH("OH", "VHRC", "1:1,000,000", 1000000.0f, "VFR Helicopter Route Chart", "CADRG"),
    OW("OW", "WAC", "1:1,000,000", 1000000.0f, "High Flying Chart - Host Nation", "CADRG"),
    P1("P1", "", "1:25,000", 25000.0f, "Special Military Map - Overlay", "CADRG"),
    P2("P2", "", "1:25,000", 25000.0f, "Special Military Purpose", "CADRG"),
    P3("P3", "", "1:25,000", 25000.0f, "Special Military Purpose", "CADRG"),
    P4("P4", "", "1:25,000", 25000.0f, "Special Military Purpose", "CADRG"),
    P5("P5", "", "1:50,000", 50000.0f, "Special Military Map - Overlay", "CADRG"),
    P6("P6", "", "1:50,000", 50000.0f, "Special Military Purpose", "CADRG"),
    P7("P7", "", "1:50,000", 50000.0f, "Special Military Purpose", "CADRG"),
    P8("P8", "", "1:50,000", 50000.0f, "Special Military Purpose", "CADRG"),
    P9("P9", "", "1:100,000", 100000.0f, "Special Military Map - Overlay", "CADRG"),
    PA("PA", "", "1:100,000", 100000.0f, "Special Military Purpose", "CADRG"),
    PB("PB", "", "1:100,000", 100000.0f, "Special Military Purpose", "CADRG"),
    PC("PC", "", "1:100,000", 100000.0f, "Special Military Purpose", "CADRG"),
    PD("PD", "", "1:250,000", 250000.0f, "Special Military Map - Overlay", "CADRG"),
    PE("PE", "", "1:250,000", 250000.0f, "Special Military Purpose", "CADRG"),
    PF("PF", "", "1:250,000", 250000.0f, "Special Military Purpose", "CADRG"),
    PG("PG", "", "1:250,000", 250000.0f, "Special Military Purpose", "CADRG"),
    PH("PH", "", "1:500,000", 500000.0f, "Special Military Map - Overlay", "CADRG"),
    PI("PI", "", "1:500,000", 500000.0f, "Special Military Purpose", "CADRG"),
    PJ("PJ", "", "1:500,000", 500000.0f, "Special Military Purpose", "CADRG"),
    PK("PK", "", "1:500,000", 500000.0f, "Special Military Purpose", "CADRG"),
    PL("PL", "", "1:1,000,000", 1000000.0f, "Special Military Map - Overlay", "CADRG"),
    PM("PM", "", "1:1,000,000", 1000000.0f, "Special Military Purpose", "CADRG"),
    PN("PN", "", "1:1,000,000", 1000000.0f, "Special Military Purpose", "CADRG"),
    PO("PO", "", "1:1,000,000", 1000000.0f, "Special Military Purpose", "CADRG"),
    PP("PP", "", "1:2,000,000", 2000000.0f, "Special Military Map - Overlay", "CADRG"),
    PQ("PQ", "", "1:2,000,000", 2000000.0f, "Special Military Purpose", "CADRG"),
    PR("PR", "", "1:2,000,000", 2000000.0f, "Special Military Purpose", "CADRG"),
    PS("PS", "", "1:5,000,000", 5000000.0f, "Special Military Map - Overlay", "CADRG"),
    PT("PT", "", "1:5,000,000", 5000000.0f, "Special Military Purpose", "CADRG"),
    PU("PU", "", "1:5,000,000", 5000000.0f, "Special Military Purpose", "CADRG"),
    PV("PV", "", "1:5,000,000", 5000000.0f, "Special Military Purpose", "CADRG"),
    R1("R1", "", "1:50,000", 50000.0f, "Range Charts", "CADRG"),
    R2("R2", "", "1:100,000", 100000.0f, "Range Charts", "CADRG"),
    R3("R3", "", "1:250,000", 250000.0f, "Range Charts", "CADRG"),
    R4("R4", "", "1:500,000", 500000.0f, "Range Charts", "CADRG"),
    R5("R5", "", "1:1,000,000", 1000000.0f, "Range Charts", "CADRG"),
    RC("RC", "RGS-100", "1:10,000", 10000.0f, "Russian General Staff Maps", "CADRG"),
    RL("RL", "RGS-50", "1:50,000", 50000.0f, "Russian General Staff Maps", "CADRG"),
    RR("RR", "RGS-200", "1:200,000", 200000.0f, "Russian General Staff Maps", "CADRG"),
    RV("RV", "Riverine", "1:50,000", 50000.0f, "Riverine Map 1:50,000 scale", "CADRG"),
    TN("TN", "TFC (Night)", "1:250,000", 250000.0f, "Transit Flying Chart (Night) - Host nation", "CADRG"),
    TR("TR", "TLM 100", "1:200,000", 200000.0f, "Topographic Line Map 1:200,000 scale", "CADRG"),
    UL("UL", "TLM50-Other", "1:50,000", 50000.0f, "Topographic Line Map (other 1:50,000 scale)", "CADRG"),
    V1("V1", "HRC Inset", "1:50,000", 50000.0f, "Helicopter Route Chart Inset", "CADRG"),
    V2("V2", "HRC Inset", "1:62,500", 62500.0f, "Helicopter Route Chart Inset", "CADRG"),
    V3("V3", "HRC Inset", "1:90,000", 90000.0f, "Helicopter Route Chart Inset", "CADRG"),
    V4("V4", "HRC Inset", "1:250,000", 250000.0f, "Helicopter Route Chart Inset", "CADRG"),
    VH("VH", "HRC", "1:125,000", 125000.0f, "Helicopter Route Chart", "CADRG"),
    VN("VN", "VNC", "1:500,000", 500000.0f, "Visual Navigation Charts", "CADRG"),
    VT("VT", "VTAC", "1:250,000", 250000.0f, "VFR Terminal Area Chart", "CADRG"),
    WA("WA", "", "1:250,000", 250000.0f, "IFR Enroute Low", "CADRG"),
    WB("WB", "", "1:500,000", 500000.0f, "IFR Enroute Low", "CADRG"),
    WC("WC", "", "1:750,000", 750000.0f, "IFR Enroute Low", "CADRG"),
    WD("WD", "", "1:1,000,000", 1000000.0f, "IFR Enroute Low", "CADRG"),
    WE("WE", "", "1:1,500,000", 1500000.0f, "IFR Enroute Low", "CADRG"),
    WF("WF", "", "1:2,000,000", 2000000.0f, "IFR Enroute Low", "CADRG"),
    WG("WG", "", "1:2,500,000", 2500000.0f, "IFR Enroute Low", "CADRG"),
    WH("WH", "", "1:3,000,000", 3000000.0f, "IFR Enroute Low", "CADRG"),
    WI("WI", "", "1:3,500,000", 3500000.0f, "IFR Enroute Low", "CADRG"),
    WK("WK", "", "1:4,500,000", 4500000.0f, "IFR Enroute Low", "CADRG"),
    XD("XD", "", "1:1,000,000", 1000000.0f, "IFR Enroute High", "CADRG"),
    XE("XE", "", "1:1,500,000", 1500000.0f, "IFR Enroute High", "CADRG"),
    XF("XF", "", "1:2,000,000", 2000000.0f, "IFR Enroute High", "CADRG"),
    XG("XG", "", "1:2,500,000", 2500000.0f, "IFR Enroute High", "CADRG"),
    XH("XH", "", "1:3,000,000", 3000000.0f, "IFR Enroute High", "CADRG"),
    XI("XI", "", "1:3,500,000", 3500000.0f, "IFR Enroute High", "CADRG"),
    XJ("XJ", "", "1:3,000,000", 3000000.0f, "IFR Enroute High", "CADRG"),
    XK("XK", "", "1:4,500,000", 4500000.0f, "IFR Enroute High", "CADRG"),
    Y9("Y9", "", "1:16,500,000", 1.65E7f, "IFR Enroute Area", "CADRG"),
    YA("YA", "", "1:250,000", 250000.0f, "IFR Enroute Area", "CADRG"),
    YB("YB", "", "1:500,000", 500000.0f, "IFR Enroute Area", "CADRG"),
    YC("YC", "", "1:750,000", 750000.0f, "IFR Enroute Area", "CADRG"),
    YD("YD", "", "1:1,000,000", 1000000.0f, "IFR Enroute Area", "CADRG"),
    YE("YE", "", "1:1,500,000", 1500000.0f, "IFR Enroute Area", "CADRG"),
    YF("YF", "", "1:2,000,000", 2000000.0f, "IFR Enroute Area", "CADRG"),
    YI("YI", "", "1:3,500,000", 3500000.0f, "IFR Enroute Area", "CADRG"),
    YJ("YJ", "", "1:4,000,000", 4000000.0f, "IFR Enroute Area", "CADRG"),
    YZ("YZ", "", "1:12,000,000", 1.2E7f, "IFR Enroute Area", "CADRG"),
    Z8("Z8", "", "1:16,000,000", 1.6E7f, "IFR Enroute High/Low", "CADRG"),
    ZA("ZA", "", "1:250,000", 250000.0f, "IFR Enroute High/Low", "CADRG"),
    ZB("ZB", "", "1:500,000", 500000.0f, "IFR Enroute High/Low", "CADRG"),
    ZC("ZC", "", "1:750,000", 750000.0f, "IFR Enroute High/Low", "CADRG"),
    ZD("ZD", "", "1:1,000,000", 1000000.0f, "IFR Enroute High/Low", "CADRG"),
    ZE("ZE", "", "1:1,500,000", 1500000.0f, "IFR Enroute High/Low", "CADRG"),
    ZF("ZF", "", "1:2,000,000", 2000000.0f, "IFR Enroute High/Low", "CADRG"),
    ZG("ZG", "", "1:2,500,000", 2500000.0f, "IFR Enroute High/Low", "CADRG"),
    ZH("ZH", "", "1:3,000,000", 3000000.0f, "IFR Enroute High/Low", "CADRG"),
    ZI("ZI", "", "1:3,500,000", 3500000.0f, "IFR Enroute High/Low", "CADRG"),
    ZJ("ZJ", "", "1:4,000,000", 4000000.0f, "IFR Enroute High/Low", "CADRG"),
    ZK("ZK", "", "1:4,500,000", 4500000.0f, "IFR Enroute High/Low", "CADRG"),
    ZT("ZT", "", "1:9,000,000", 9000000.0f, "IFR Enroute High/Low", "CADRG"),
    ZV("ZV", "", "1:10,000,000", 1.0E7f, "IFR Enroute High/Low", "CADRG"),
    ZZ("ZZ", "", "1:12,000,000", 1.2E7f, "IFR Enroute High/Low", "CADRG");

    public final String seriesCode;
    public final String abbr;
    public final String scaleString;
    public final float scale;
    public final String name;
    public final String dataType;

    private RpfProductInfo(String sc, String a, String ss, float s, String n2, String dt) {
        this.seriesCode = sc;
        this.abbr = a;
        this.scaleString = ss;
        this.scale = s;
        this.name = n2;
        this.dataType = dt;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RPF Product: ").append(this.name).append("\n");
        sb.append("  Series Code: ").append(this.seriesCode).append("\n");
        sb.append("  Abbreviation: ").append(this.abbr).append("\n");
        sb.append("  Scale: ").append(this.scaleString);
        if (this.scale == -1.0f) {
            sb.append(" (Various)\n");
        } else {
            sb.append(" (").append(this.scale).append(")\n");
        }
        sb.append("  Data Type: ").append(this.dataType).append("\n");
        return sb.toString();
    }

    public static RpfProductInfo get(String seriesCode) {
        if (seriesCode == null) {
            return UK;
        }
        for (RpfProductInfo rpi : RpfProductInfo.values()) {
            if (!rpi.seriesCode.equalsIgnoreCase(seriesCode)) continue;
            return rpi;
        }
        return UK;
    }

    public static void main(String[] argv) {
        System.out.println("RPF Catalog:\n\n");
        for (RpfProductInfo rpi : RpfProductInfo.values()) {
            System.out.println("----------------------");
            System.out.println(rpi);
        }
    }
}

