/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.VPFAutoFeatureGraphicWarehouse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoSymAttExpression {
    private static Logger logger = Logger.getLogger("com.bbn.openmap.layer.vpf.GeoSymAttExpr");
    public static final int NO_OP = 0;
    public static final int EQUALS_OP = 1;
    public static final int NOT_EQUALS_OP = 2;
    public static final int LESS_THAN_OP = 3;
    public static final int GREATER_THAN_OP = 4;
    public static final int LT_EQUALS_OP = 5;
    public static final int GT_EQUALS_OP = 6;
    public static final int NONE_CONN = 0;
    public static final int or_CONN = 1;
    public static final int AND_CONN = 2;
    public static final int and_CONN = 3;
    public static final int OR_CONN = 4;
    protected VPFAutoFeatureGraphicWarehouse warehouse;
    protected Expression exp;
    protected static String[] ops = new String[]{"", "=", "<>", "<", ">", "<=", ">="};

    public GeoSymAttExpression(String source, VPFAutoFeatureGraphicWarehouse warehouse) {
        this.warehouse = warehouse;
        this.exp = this.findExpression(source);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Parsing: " + source);
            logger.finer(this.toString());
        }
    }

    protected Connector findOp(String source) {
        int ORIndex;
        int ANDIndex = source.lastIndexOf("AND");
        if (ANDIndex == (ORIndex = source.lastIndexOf("OR"))) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("connector not found in " + source);
            }
            return null;
        }
        if (ANDIndex > ORIndex) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("found AND in " + source);
            }
            return new Connector(2, ANDIndex);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("found OR in " + source);
        }
        return new Connector(4, ORIndex);
    }

    public String toString() {
        if (this.exp != null) {
            return this.exp.toString();
        }
        return "No Expression Defined";
    }

    protected Connector findMiniOp(String source) {
        int ORIndex;
        int ANDIndex = source.lastIndexOf("and");
        if (ANDIndex == (ORIndex = source.lastIndexOf("or"))) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("connector not found in " + source);
            }
            return null;
        }
        if (ANDIndex > ORIndex) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("found and in " + source);
            }
            return new Connector(3, ANDIndex);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("found or in " + source);
        }
        return new Connector(1, ORIndex);
    }

    protected Expression findMathOp(String source) {
        int opIndex = 1;
        int locIndex = -1;
        CompareExpression exp = null;
        while (opIndex < 7) {
            locIndex = source.indexOf(ops[opIndex]);
            if (locIndex >= 0) {
                if (opIndex != 1 && opIndex != 3 && opIndex != 4 || !source.contains("<=") && !source.contains(">=")) break;
                ++opIndex;
                continue;
            }
            ++opIndex;
        }
        if (locIndex != -1) {
            String rightSide = source.substring(locIndex + ops[opIndex].length());
            String leftSide = null;
            if (locIndex > 0) {
                leftSide = source.substring(0, locIndex);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("got left side: " + leftSide + " op: " + ops[opIndex] + " and right side: " + rightSide);
            }
            try {
                Double val = Double.parseDouble(rightSide);
                exp = leftSide != null && leftSide.length() == 4 ? new ECDISExpression(leftSide, val, opIndex, this.warehouse) : new ValueExpression(leftSide, val, opIndex);
            }
            catch (NumberFormatException nfe) {
                double val = this.warehouse.getExternalAttribute(rightSide);
                if (val < 0.0) {
                    exp = rightSide.equalsIgnoreCase("NULL") ? new StringExpression(leftSide, null, opIndex) : new StringExpression(leftSide, rightSide, opIndex);
                }
                exp = new ValueExpression(leftSide, val, opIndex);
            }
        }
        return exp;
    }

    protected Expression findExpression(String source) {
        if (source != null && source.length() > 0) {
            if ((source = source.trim()).length() == 0) {
                return null;
            }
            String leftSide = source;
            String rightSide = null;
            Connector op = this.findOp(leftSide);
            if (op != null) {
                rightSide = op.getRightSide(leftSide);
                leftSide = leftSide.substring(0, op.sourceLoc);
                Expression leftExpression = this.findExpression(leftSide);
                Expression rightExpression = this.findExpression(rightSide);
                if (leftExpression != null) {
                    op.addExpr(leftExpression);
                }
                if (rightExpression != null) {
                    op.addExpr(rightExpression);
                }
                return op;
            }
            op = this.findMiniOp(leftSide);
            if (op != null) {
                rightSide = op.getRightSide(leftSide);
                leftSide = leftSide.substring(0, op.sourceLoc);
                Expression leftExpression = this.findExpression(leftSide);
                Expression rightExpression = this.findExpression(rightSide);
                if (leftExpression != null) {
                    op.addExpr(leftExpression);
                }
                if (rightExpression != null) {
                    op.addExpr(rightExpression);
                }
                return op;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("need to break up: " + source);
            }
            return this.findMathOp(source);
        }
        return null;
    }

    public boolean evaluate(FeatureClassInfo fci, int row) {
        boolean ret = true;
        StringBuffer reasoning = null;
        if (logger.isLoggable(Level.FINE)) {
            reasoning = new StringBuffer();
        }
        if (this.exp != null) {
            ret = this.exp.evaluate(fci, row, reasoning);
        }
        if (reasoning != null) {
            reasoning.append("\n--------");
            logger.fine(reasoning.toString());
        }
        return ret;
    }

    public boolean evaluate(FeatureClassInfo fci, List<Object> row) {
        boolean ret = true;
        StringBuffer reasoning = null;
        if (logger.isLoggable(Level.FINE)) {
            reasoning = new StringBuffer();
            logger.fine(this.toString());
        }
        if (this.exp != null) {
            ret = this.exp.evaluate(fci, row, reasoning);
        }
        if (reasoning != null) {
            reasoning.append("\n--------");
            logger.fine(reasoning.toString());
        }
        return ret;
    }

    public static void main(String[] args) {
        new GeoSymAttExpression("mac=2 AND idsm=0 AND hdp>=msscand<ssdc AND isdm=0", new VPFAutoFeatureGraphicWarehouse());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Expression {
        public boolean evaluate(FeatureClassInfo var1, int var2, StringBuffer var3);

        public boolean evaluate(FeatureClassInfo var1, List<Object> var2, StringBuffer var3);
    }

    public static abstract class CompareExpression
    implements Expression {
        protected int op;
        protected FeatureClassInfo fci = null;
        protected String colName;
        protected int colIndex = -1;

        protected CompareExpression(String colName, int op) {
            this.colName = colName;
            this.op = op;
        }

        protected void setIndexes(FeatureClassInfo fci) {
            this.fci = fci;
            this.colIndex = -1;
            int columnCount = fci.getColumnCount();
            for (int column = 0; column < columnCount; ++column) {
                if (!fci.getColumnName(column).equalsIgnoreCase(this.colName)) continue;
                this.colIndex = column;
                break;
            }
        }

        protected boolean test(double val1, double val2, StringBuffer buf) {
            boolean ret = false;
            switch (this.op) {
                case 1: {
                    ret = val1 == val2;
                    break;
                }
                case 2: {
                    ret = val1 != val2;
                    break;
                }
                case 3: {
                    ret = val1 < val2;
                    break;
                }
                case 4: {
                    ret = val1 > val2;
                    break;
                }
                case 5: {
                    ret = val1 <= val2;
                    break;
                }
                case 6: {
                    boolean bl = ret = val1 >= val2;
                }
            }
            if (buf != null) {
                String operation = null;
                switch (this.op) {
                    case 1: {
                        operation = ret + "=" + val1 + "==" + val2;
                        break;
                    }
                    case 2: {
                        operation = ret + "=" + val1 + "!=" + val2;
                        break;
                    }
                    case 3: {
                        operation = ret + "=" + val1 + "<" + val2;
                        break;
                    }
                    case 4: {
                        operation = ret + "=" + val1 + ">" + val2;
                        break;
                    }
                    case 5: {
                        operation = ret + "=" + val1 + "<=" + val2;
                        break;
                    }
                    case 6: {
                        operation = ret + "=" + val1 + ">=" + val2;
                    }
                }
                buf.append("\n   " + this.toString() + ":" + operation);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnExpression
    extends CompareExpression
    implements Expression {
        protected String otherColName;
        protected int otherColIndex = -1;

        public ColumnExpression(String colName, String otherName, int op) {
            super(colName, op);
            this.otherColName = otherName;
        }

        @Override
        protected void setIndexes(FeatureClassInfo fci) {
            this.fci = fci;
            int columnCount = fci.getColumnCount();
            this.colIndex = -1;
            this.otherColIndex = -1;
            for (int column = 0; column < columnCount; ++column) {
                if (fci.getColumnName(column).equalsIgnoreCase(this.colName)) {
                    this.colIndex = column;
                }
                if (!fci.getColumnName(column).equalsIgnoreCase(this.otherColName)) continue;
                this.otherColIndex = column;
            }
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, int row, StringBuffer reasoning) {
            if (this.colIndex == -1 || this.otherColIndex == -1 || this.fci != fci) {
                this.setIndexes(fci);
            }
            if (this.colIndex == -1 || this.otherColIndex == -1) {
                logger.finer("col " + this.colName + " or " + this.otherColName + " not found in FCI[" + fci.columnNameString() + "]");
                return false;
            }
            ArrayList<Object> fcirow = new ArrayList<Object>();
            try {
                if (fci.getRow(fcirow, row)) {
                    Double realVal1 = Double.parseDouble(fcirow.get(this.colIndex).toString());
                    Double realVal2 = Double.parseDouble(fcirow.get(this.otherColIndex).toString());
                    return this.test(realVal1, realVal2, reasoning);
                }
            }
            catch (FormatException formatException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, List<Object> row, StringBuffer reasoning) {
            if (this.colIndex == -1 || this.otherColIndex == -1 || this.fci != fci) {
                this.setIndexes(fci);
            }
            if (this.colIndex == -1 || this.otherColIndex == -1) {
                logger.finer("col " + this.colName + " or " + this.otherColName + " not found in FCI[" + fci.columnNameString() + "]");
                return false;
            }
            try {
                Double realVal1 = Double.parseDouble(row.get(this.colIndex).toString());
                Double realVal2 = Double.parseDouble(row.get(this.otherColIndex).toString());
                return this.test(realVal1, realVal2, reasoning);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        public String toString() {
            return "ValueExpression[" + this.colName + " " + ops[this.op] + " " + this.otherColName + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueExpression
    extends CompareExpression {
        double val;

        public ValueExpression(String colName, double val, int op) {
            super(colName, op);
            this.val = val;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, int row, StringBuffer reasoning) {
            block9: {
                if (this.colIndex == -1 || this.fci != fci) {
                    this.setIndexes(fci);
                }
                ArrayList<Object> fcirow = new ArrayList<Object>();
                try {
                    if (fci.getRow(fcirow, row)) {
                        if (this.colIndex < 0) {
                            if (reasoning != null) {
                                reasoning.append("\n  col ").append(this.colName).append(" not found in FCI[").append(fci.columnNameString()).append("]");
                            }
                            return false;
                        }
                        Double realVal = Double.parseDouble(fcirow.get(this.colIndex).toString());
                        return this.test(realVal, this.val, reasoning);
                    }
                    if (reasoning != null) {
                        reasoning.append("\n  Can't read row ").append(row);
                    }
                }
                catch (FormatException fe) {
                    if (reasoning != null) {
                        reasoning.append("\n  FormatException reading row ").append(row);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (reasoning == null) break block9;
                    reasoning.append("\n  NumberFormatException reading ").append(fcirow.get(this.colIndex));
                }
            }
            return false;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, List<Object> row, StringBuffer reasoning) {
            if (this.colIndex == -1 || this.fci != fci) {
                this.setIndexes(fci);
            }
            try {
                if (this.colIndex < 0) {
                    if (reasoning != null) {
                        reasoning.append("\n  col ").append(this.colName).append(" not found in FCI[").append(fci.columnNameString()).append("]");
                    }
                    return false;
                }
                Double realVal = Double.parseDouble(row.get(this.colIndex).toString());
                return this.test(realVal, this.val, reasoning);
            }
            catch (NumberFormatException nfe) {
                if (reasoning != null) {
                    reasoning.append("\n  NumberFormatException reading ").append(row.get(this.colIndex));
                }
                return false;
            }
        }

        public String toString() {
            return "ValueExpression[" + this.colName + " " + ops[this.op] + " " + this.val + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ECDISExpression
    extends ValueExpression {
        VPFAutoFeatureGraphicWarehouse warehouse = null;

        public ECDISExpression(String colName, double val, int op, VPFAutoFeatureGraphicWarehouse warehouse) {
            super(colName, val, op);
            this.warehouse = warehouse;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, int row, StringBuffer reasoning) {
            return this.evaluate(reasoning);
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, List<Object> row, StringBuffer reasoning) {
            return this.evaluate(reasoning);
        }

        public boolean evaluate(StringBuffer reasoning) {
            double realVal = this.warehouse.getExternalAttribute(this.colName);
            return this.test(realVal, this.val, reasoning);
        }

        @Override
        public String toString() {
            return "ECDISExpression[" + this.colName + " " + ops[this.op] + " " + this.val + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringExpression
    extends CompareExpression {
        protected String val;

        public StringExpression(String colName, String val, int op) {
            super(colName, op);
            if (val == null) {
                val = "";
            }
            this.val = val;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, int row, StringBuffer reasoning) {
            block7: {
                if (this.colIndex == -1 || this.fci != fci) {
                    this.setIndexes(fci);
                }
                ArrayList<Object> fcirow = new ArrayList<Object>();
                try {
                    if (fci.getRow(fcirow, row)) {
                        if (this.colIndex < 0) {
                            if (reasoning != null) {
                                reasoning.append("\n  col ").append(this.colName).append(" not found in FCI[").append(fci.columnNameString()).append("]");
                            }
                            logger.info("col " + this.colName + " not found in FCI[" + fci.columnNameString() + "]");
                            return false;
                        }
                        String realVal = fcirow.get(this.colIndex).toString().trim();
                        return this.test(realVal, this.val, reasoning);
                    }
                    if (reasoning != null) {
                        reasoning.append("\n  Can't read row ").append(row);
                    }
                }
                catch (FormatException fe) {
                    if (reasoning == null) break block7;
                    reasoning.append("\n  FormatException reading row ").append(row);
                }
            }
            return false;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, List<Object> row, StringBuffer reasoning) {
            if (this.colIndex == -1 || this.fci != fci) {
                this.setIndexes(fci);
            }
            if (this.colIndex == -1) {
                logger.finer("col " + this.colName + " not found in FCI[" + fci.columnNameString() + "]");
                return false;
            }
            Object realVal = row.get(this.colIndex);
            if (realVal == null) {
                realVal = "";
            }
            return this.test(realVal.toString().trim(), this.val, reasoning);
        }

        protected boolean test(String val1, String val2, StringBuffer buf) {
            boolean ret = false;
            switch (this.op) {
                case 1: {
                    ret = val1.equals(val2);
                    break;
                }
                case 2: {
                    boolean bl = ret = !val1.equals(val2);
                }
            }
            if (buf != null) {
                String operation = null;
                switch (this.op) {
                    case 1: {
                        operation = ret + "=" + val1 + "==" + val2;
                        break;
                    }
                    case 2: {
                        operation = ret + "=" + val1 + "!=" + val2;
                    }
                }
                buf.append("\n   " + this.toString() + ":" + operation);
            }
            return ret;
        }

        public String toString() {
            return "StringExpression[" + this.colName + " " + ops[this.op] + " " + this.val + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Connector
    implements Expression {
        List<Expression> exp;
        int op;
        int sourceLoc;

        public Connector(int op, int sLoc) {
            this.op = op;
            this.sourceLoc = sLoc;
        }

        public void addExpr(Expression expr) {
            if (this.exp == null) {
                this.exp = new LinkedList<Expression>();
            }
            if (expr != null) {
                this.exp.add(expr);
                this.updateColumnNamesIfNeeded();
            }
        }

        protected void updateColumnNamesIfNeeded() {
            String colName = null;
            for (Expression e : this.exp) {
                String cName;
                if (!(e instanceof CompareExpression) || (cName = ((CompareExpression)e).colName) == null) continue;
                colName = cName;
                break;
            }
            if (colName != null) {
                for (Expression e : this.exp) {
                    if (!(e instanceof CompareExpression) || ((CompareExpression)e).colName != null) continue;
                    ((CompareExpression)e).colName = colName;
                    break;
                }
            }
        }

        public String getRightSide(String source) {
            switch (this.op) {
                case 0: {
                    break;
                }
                case 2: 
                case 3: {
                    return source.substring(this.sourceLoc + 3).trim();
                }
                case 1: 
                case 4: {
                    return source.substring(this.sourceLoc + 2).trim();
                }
            }
            return null;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, int row, StringBuffer reasoning) {
            boolean ret = false;
            block0 : switch (this.op) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Expression e;
                    ret = true;
                    Iterator<Expression> iterator = this.exp.iterator();
                    while (iterator.hasNext() && (ret = (e = iterator.next()).evaluate(fci, row, reasoning))) {
                    }
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    for (Expression e : this.exp) {
                        if (!(ret = ret || e.evaluate(fci, row, reasoning))) continue;
                        break block0;
                    }
                    break;
                }
            }
            if (reasoning != null) {
                reasoning.append("\n-> " + this.toString() + ": evaluates " + ret);
            }
            return ret;
        }

        @Override
        public boolean evaluate(FeatureClassInfo fci, List<Object> row, StringBuffer reasoning) {
            boolean ret = false;
            switch (this.op) {
                case 0: {
                    break;
                }
                case 2: 
                case 3: {
                    Expression e;
                    ret = true;
                    Iterator<Expression> iterator = this.exp.iterator();
                    while (iterator.hasNext() && (ret = (e = iterator.next()).evaluate(fci, row, reasoning))) {
                    }
                    break;
                }
                case 1: 
                case 4: {
                    Expression e;
                    Iterator<Expression> iterator = this.exp.iterator();
                    while (iterator.hasNext() && !(ret = (e = iterator.next()).evaluate(fci, row, reasoning))) {
                    }
                    break;
                }
            }
            if (reasoning != null) {
                reasoning.append("\n-> " + this.toString() + ": evaluates " + ret);
            }
            return ret;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Connector[");
            boolean addConn = false;
            String conn = " AND ";
            if (this.op == 4) {
                conn = " OR ";
            }
            for (Expression e : this.exp) {
                if (addConn) {
                    sb.append(conn);
                }
                sb.append(e.toString());
                addConn = true;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

