/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.esri;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShpOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShxOutputStream;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.esri.EsriLayer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Tester
extends JFrame
implements ShapeConstants {
    public Tester() {
        JButton cmdPolylineTest = new JButton("Test Polyline");
        cmdPolylineTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    Tester.this.testPolyline();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton cmdPolygonTest = new JButton("Test Polygon");
        cmdPolygonTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    Tester.this.testPolygon();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton cmdPointTest = new JButton("Test Point");
        cmdPointTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    Tester.this.testPoint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel centerPanel = new JPanel();
        JPanel southPanel = new JPanel();
        southPanel.add(cmdPolylineTest);
        southPanel.add(cmdPolygonTest);
        southPanel.add(cmdPointTest);
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public void testPolyline() throws Exception {
        EsriLayer layer = new EsriLayer("Drawable Layer", 3, 2);
        DbfTableModel model = layer.getModel();
        model.setDecimalCount(0, (byte)0);
        model.setLength(0, 20);
        model.setColumnName(0, "Column1");
        model.setType(0, (byte)67);
        model.setDecimalCount(1, (byte)3);
        model.setLength(1, 20);
        model.setColumnName(1, "Column2");
        model.setType(1, (byte)78);
        this.addPolylineRecord1(layer);
        this.addPolylineRecord2(layer);
        this.addPolylineRecord3(layer);
        EsriGraphicList list = layer.getEsriGraphicList();
        ShpOutputStream pos = new ShpOutputStream(new FileOutputStream("polylinetest0.shp"));
        int[][] indexData = pos.writeGeometry(list);
        ShxOutputStream xos = new ShxOutputStream(new FileOutputStream("polylinetest0.shx"));
        xos.writeIndex(indexData, list.getType(), list.getExtents());
        DbfOutputStream dos = new DbfOutputStream(new FileOutputStream("polylinetest0.dbf"));
        dos.writeModel(model);
    }

    public void testPolygon() throws Exception {
        EsriLayer layer = new EsriLayer("Polygon Layer", 5, 2);
        DbfTableModel model = layer.getModel();
        model.setDecimalCount(0, (byte)0);
        model.setLength(0, 20);
        model.setColumnName(0, "Column1");
        model.setType(0, (byte)67);
        model.setDecimalCount(1, (byte)3);
        model.setLength(1, 20);
        model.setColumnName(1, "Column2");
        model.setType(1, (byte)78);
        this.addPolygonRecord1(layer);
        EsriGraphicList list = layer.getEsriGraphicList();
        ShpOutputStream pos = new ShpOutputStream(new FileOutputStream("polygontest5.shp"));
        int[][] indexData = pos.writeGeometry(list);
        ShxOutputStream xos = new ShxOutputStream(new FileOutputStream("polygontest5.shx"));
        xos.writeIndex(indexData, list.getType(), list.getExtents());
        DbfOutputStream dos = new DbfOutputStream(new FileOutputStream("polygontest5.dbf"));
        dos.writeModel(model);
    }

    public void testPoint() throws Exception {
        EsriLayer layer = new EsriLayer("Point Layer", 1, 2);
        DbfTableModel model = layer.getModel();
        model.setDecimalCount(0, (byte)0);
        model.setLength(0, 20);
        model.setColumnName(0, "Column1");
        model.setType(0, (byte)67);
        model.setDecimalCount(1, (byte)3);
        model.setLength(1, 20);
        model.setColumnName(1, "Column2");
        model.setType(1, (byte)78);
        this.addPoints(layer);
        EsriGraphicList list = layer.getEsriGraphicList();
        ShpOutputStream pos = new ShpOutputStream(new FileOutputStream("pointtest0.shp"));
        int[][] indexData = pos.writeGeometry(list);
        ShxOutputStream xos = new ShxOutputStream(new FileOutputStream("pointtest0.shx"));
        xos.writeIndex(indexData, list.getType(), list.getExtents());
        DbfOutputStream dos = new DbfOutputStream(new FileOutputStream("pointtest0.dbf"));
        dos.writeModel(model);
    }

    public void addPolylineRecord1(EsriLayer layer) {
        EsriPolylineList shapeData = new EsriPolylineList();
        double[] part0 = new double[]{35.0, -120.0, -25.0, -95.0, 56.0, -30.0};
        double[] part1 = new double[]{-15.0, -110.0, 13.0, -80.0, -25.0, 10.0};
        EsriPolyline poly0 = new EsriPolyline(part0, 0, 2);
        EsriPolyline poly1 = new EsriPolyline(part1, 0, 2);
        ((OMGraphicList)shapeData).add(poly0);
        ((OMGraphicList)shapeData).add(poly1);
        ArrayList<Object> tabularData = new ArrayList<Object>();
        tabularData.add(0, "first value");
        tabularData.add(1, new Double(12.54));
        layer.addRecord(shapeData, tabularData);
    }

    public void addPolylineRecord2(EsriLayer layer) {
        EsriPolylineList shapeData = new EsriPolylineList();
        double[] part0 = new double[]{12.0, -175.0, -30.0, 85.0, 25.0, 15.0};
        EsriPolyline poly0 = new EsriPolyline(part0, 0, 2);
        ((OMGraphicList)shapeData).add(poly0);
        ArrayList<Object> tabularData = new ArrayList<Object>();
        tabularData.add(0, "second value");
        tabularData.add(1, new Double(30.215));
        layer.addRecord(shapeData, tabularData);
    }

    public void addPolylineRecord3(EsriLayer layer) {
        EsriPolylineList shapeData = new EsriPolylineList();
        double[] part0 = new double[]{-25.0, -140.0, -50.0, -95.0, 65.0, 51.0};
        double[] part1 = new double[]{-10.0, -130.0, -47.0, -101.0, 71.0, 59.0};
        double[] part2 = new double[]{-15.0, -151.0, -49.0, -100.0, 76.0, 41.0};
        EsriPolyline poly0 = new EsriPolyline(part0, 0, 2);
        EsriPolyline poly1 = new EsriPolyline(part1, 0, 2);
        EsriPolyline poly2 = new EsriPolyline(part2, 0, 2);
        ((OMGraphicList)shapeData).add(poly0);
        ((OMGraphicList)shapeData).add(poly1);
        ((OMGraphicList)shapeData).add(poly2);
        ArrayList<Object> tabularData = new ArrayList<Object>();
        tabularData.add(0, "third value");
        tabularData.add(1, new Double(20.1578));
        layer.addRecord(shapeData, tabularData);
    }

    public void addPolygonRecord1(EsriLayer layer) {
        EsriPolygonList shapeData = new EsriPolygonList();
        double[] part0 = new double[]{45.0, -70.0, 30.0, -30.0, 10.0, -80.0, 30.0, -120.0, 45.0, -70.0};
        EsriPolygon poly0 = new EsriPolygon(part0, 0, 1);
        ((OMGraphicList)shapeData).add(poly0);
        ArrayList<Object> tabularData = new ArrayList<Object>();
        tabularData.add(0, "first value");
        tabularData.add(1, new Double(12.54));
        layer.addRecord(shapeData, tabularData);
    }

    public void addPoints(EsriLayer layer) {
        ArrayList<Object> tabularData0 = new ArrayList<Object>();
        tabularData0.add(0, "first value");
        tabularData0.add(1, new Double(10.54));
        layer.addRecord(new EsriPoint(30.0, -90.0), tabularData0);
        ArrayList<Object> tabularData1 = new ArrayList<Object>();
        tabularData1.add(0, "second value");
        tabularData1.add(1, new Double(20.54));
        layer.addRecord(new EsriPoint(45.0, -70.0), tabularData1);
        ArrayList<Object> tabularData2 = new ArrayList<Object>();
        tabularData2.add(0, "third value");
        tabularData2.add(1, new Double(30.54));
        layer.addRecord(new EsriPoint(35.0, -120.0), tabularData2);
    }

    public static void main(String[] args) {
        new Tester();
    }
}

