/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

public class Ellipsoid {
    public static final Ellipsoid AIRY = new Ellipsoid("Airy", 6377563.0, 0.00667054);
    public static final Ellipsoid AUSTRALIAN_NATIONAL = new Ellipsoid("Australian National", 6378160.0, 0.006694542);
    public static final Ellipsoid BESSEL_1841 = new Ellipsoid("Bessel 1841", 6377397.0, 0.006674372);
    public static final Ellipsoid BESSEL_1841_NAMIBIA = new Ellipsoid("Bessel 1841 Namibia", 6377484.0, 0.006674372);
    public static final Ellipsoid CLARKE_1866 = new Ellipsoid("Clarke 1866", 6378206.0, 0.006768658);
    public static final Ellipsoid CLARKE_1880 = new Ellipsoid("Clarke 1880", 6378249.0, 0.006803511);
    public static final Ellipsoid EVEREST = new Ellipsoid("Everest", 6377276.0, 0.006637847);
    public static final Ellipsoid FISHER_1960_MERCURY = new Ellipsoid("Fisher 1960 Mercury", 6378166.0, 0.006693422);
    public static final Ellipsoid FISHER_1968 = new Ellipsoid("Fisher 1968", 6378150.0, 0.006693422);
    public static final Ellipsoid GRS_1967 = new Ellipsoid("GRS 1967", 6378160.0, 0.006694605);
    public static final Ellipsoid GRS_1980 = new Ellipsoid("GRS 1980", 6378137.0, 0.081819191, 0.00669438, 6356752.3141);
    public static final Ellipsoid HELMERT_1906 = new Ellipsoid("Helmert 1906", 6378200.0, 0.006693422);
    public static final Ellipsoid HOUGH = new Ellipsoid("Hough", 6378270.0, 0.00672267);
    public static final Ellipsoid INTERNATIONAL = new Ellipsoid("International", 6378388.0, 0.08199189, 0.00672267, 6356911.946);
    public static final Ellipsoid KRASSOVSKY = new Ellipsoid("Krassovsky", 6378245.0, 0.006693422);
    public static final Ellipsoid MODIFIED_AIRY = new Ellipsoid("Modified Airy", 6377340.0, 0.00667054);
    public static final Ellipsoid MODIFIED_EVEREST = new Ellipsoid("Modified Everest", 6377304.0, 0.006637847);
    public static final Ellipsoid MODIFIED_FISCHER_1960 = new Ellipsoid("Modified Fischer", 6378155.0, 0.006693422);
    public static final Ellipsoid SOUTH_AMERICAN_1969 = new Ellipsoid("South American 1969", 6378160.0, 0.006694542);
    public static final Ellipsoid WGS_60 = new Ellipsoid("WSG 60", 6378165.0, 0.006693422);
    public static final Ellipsoid WGS_66 = new Ellipsoid("WGS 66", 6378145.0, 0.006694542);
    public static final Ellipsoid WGS_72 = new Ellipsoid("WGS 72", 6378135.0, 0.006694318);
    public static final Ellipsoid WGS_84 = new Ellipsoid("WGS 84", 6378137.0, 0.081819191, 0.00669438, 6356752.3142);
    public final String name;
    public final double radius;
    public final double polarRadius;
    public final double ecc;
    public final double eccsq;

    public Ellipsoid(String name, double radius, double eccsq) {
        this(name, radius, eccsq, Double.NaN, Double.NaN);
    }

    public Ellipsoid(String name, double equitorialRadius, double ecc, double eccsq, double polarRadius) {
        this.name = name;
        this.radius = equitorialRadius;
        this.ecc = ecc;
        this.eccsq = eccsq;
        this.polarRadius = polarRadius;
    }

    public static Ellipsoid[] getAllEllipsoids() {
        Ellipsoid[] all = new Ellipsoid[]{AIRY, AUSTRALIAN_NATIONAL, BESSEL_1841, BESSEL_1841_NAMIBIA, CLARKE_1866, CLARKE_1880, EVEREST, FISHER_1960_MERCURY, FISHER_1968, GRS_1967, GRS_1980, HELMERT_1906, HOUGH, INTERNATIONAL, KRASSOVSKY, MODIFIED_AIRY, MODIFIED_EVEREST, MODIFIED_FISCHER_1960, SOUTH_AMERICAN_1969, WGS_60, WGS_66, WGS_72, WGS_84};
        return all;
    }

    public static Ellipsoid getByName(String name) {
        Ellipsoid[] all = Ellipsoid.getAllEllipsoids();
        if (name != null && name.length() > 0) {
            name = name.replace('_', ' ');
            for (int i = 0; i < all.length; ++i) {
                if (!name.equalsIgnoreCase(all[i].name)) continue;
                return all[i];
            }
        }
        return null;
    }

    public String toString() {
        return "Ellipsoid[name=" + this.name + ", radius=" + this.radius + ", eccsq=" + this.eccsq + "]";
    }
}

