/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.RhumbCalculator;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineCoordinateGenerator {
    public static final double DEFAULT_SEGS_PER_DEG = 10.0;
    double segsPerDeg = 10.0;
    final double[] llpts;
    private boolean returnDegrees = false;

    private LineCoordinateGenerator(double[] radians) {
        this.llpts = radians;
    }

    public static LineCoordinateGenerator fromRadians(double[] radians) {
        return new LineCoordinateGenerator(radians);
    }

    public static LineCoordinateGenerator fromDegrees(double[] degrees) {
        double[] radians = new double[degrees.length];
        System.arraycopy(degrees, 0, radians, 0, degrees.length);
        ProjMath.arrayDegToRad(radians);
        return new LineCoordinateGenerator(radians).fromDegrees();
    }

    private LineCoordinateGenerator fromDegrees() {
        this.returnDegrees = true;
        return this;
    }

    public LineCoordinateGenerator withSegmentsPerDegrees(double spd) {
        this.segsPerDeg = spd;
        return this;
    }

    public double[] greatCircleLineDoubles() {
        return LineCoordinateGenerator.toDoubles(this.greatCircleLineShape()).get(0);
    }

    public Shape greatCircleLineShape() {
        GeneralPath path = null;
        if (this.llpts != null && this.llpts.length >= 4 && this.llpts.length % 2 == 0) {
            double y1 = this.llpts[0];
            double x1 = this.llpts[1];
            path = new GeneralPath(0, this.llpts.length / 2);
            boolean firstCoords = true;
            for (int i = 2; i < this.llpts.length; i += 2) {
                double y2 = this.llpts[i];
                double x2 = this.llpts[i + 1];
                double radDist = GreatCircle.sphericalDistance(y1, x1, y2, x2);
                int nsegs = (int)(ProjMath.radToDeg(radDist) * this.segsPerDeg);
                if (nsegs == 0) {
                    nsegs = 1;
                }
                double[] coords = GreatCircle.greatCircle(y1, x1, y2, x2, nsegs, false);
                if (this.returnDegrees) {
                    ProjMath.arrayRadToDeg(coords);
                }
                for (int j = 0; j <= coords.length - 1; j += 2) {
                    if (firstCoords) {
                        path.moveTo(coords[j + 1], coords[j]);
                        firstCoords = false;
                        continue;
                    }
                    path.lineTo(coords[j + 1], coords[j]);
                }
                x1 = x2;
                y1 = y2;
            }
            if (this.returnDegrees) {
                path.lineTo(ProjMath.radToDeg(x1), ProjMath.radToDeg(y1));
            } else {
                path.lineTo(x1, y1);
            }
        }
        return path;
    }

    public double[] rhumbLineDoubles() {
        return LineCoordinateGenerator.toDoubles(this.rhumbLineShape()).get(0);
    }

    public Shape rhumbLineShape() {
        GeneralPath path = null;
        if (this.llpts != null && this.llpts.length >= 4 && this.llpts.length % 2 == 0) {
            LatLonPoint.Double ll1 = new LatLonPoint.Double(this.llpts[0], this.llpts[1], true);
            path = new GeneralPath(0, this.llpts.length / 2);
            boolean firstCoords = true;
            for (int i = 2; i < this.llpts.length - 1; i += 2) {
                double segDistIncrease;
                LatLonPoint.Double ll2 = new LatLonPoint.Double(this.llpts[i], this.llpts[i + 1], true);
                if (firstCoords) {
                    this.moveTo(path, ll1);
                    firstCoords = false;
                } else {
                    this.lineTo(path, ll1);
                }
                double radDist = RhumbCalculator.getDistanceBetweenPoints(ll1, ll2);
                double angle = RhumbCalculator.getAzimuthBetweenPoints(ll1, ll2);
                for (double segDist = segDistIncrease = radDist / ProjMath.degToRad(ProjMath.radToDeg(radDist) * this.segsPerDeg); segDist < radDist; segDist += segDistIncrease) {
                    LatLonPoint llp = RhumbCalculator.calculatePointOnRhumbLine(ll1, angle, segDist);
                    this.lineTo(path, llp);
                }
                ll1 = ll2;
            }
            this.lineTo(path, ll1);
        }
        return path;
    }

    private void moveTo(GeneralPath path, LatLonPoint llp) {
        if (this.returnDegrees) {
            path.moveTo(llp.getX(), llp.getY());
        } else {
            path.moveTo(llp.getRadLon(), llp.getRadLat());
        }
    }

    private void lineTo(GeneralPath path, LatLonPoint llp) {
        if (this.returnDegrees) {
            path.lineTo(llp.getX(), llp.getY());
        } else {
            path.lineTo(llp.getRadLon(), llp.getRadLat());
        }
    }

    public Shape straightLineShape() {
        GeneralPath path = null;
        if (this.llpts != null && this.llpts.length >= 4 && this.llpts.length % 2 == 0) {
            double y1 = this.llpts[0];
            double x1 = this.llpts[1];
            path = new GeneralPath(0, this.llpts.length / 2);
            if (this.returnDegrees) {
                path.moveTo(ProjMath.radToDeg(x1), ProjMath.radToDeg(y1));
            } else {
                path.moveTo(x1, y1);
            }
            for (int i = 2; i < this.llpts.length - 1; i += 2) {
                x1 = this.llpts[i + 1];
                y1 = this.llpts[i];
                if (this.returnDegrees) {
                    path.lineTo(ProjMath.radToDeg(x1), ProjMath.radToDeg(y1));
                    continue;
                }
                path.lineTo(x1, y1);
            }
        }
        return path;
    }

    public static List<double[]> toDoubles(Shape s) {
        ArrayList<double[]> coordLists = new ArrayList<double[]>();
        PathIterator pi2 = s.getPathIterator(null);
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, 0.25);
        double[] coords = new double[6];
        double lastMovedToPntX = Double.NaN;
        double lastMovedToPntY = Double.NaN;
        List<Double> curCoord = null;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 1) {
                curCoord = LineCoordinateGenerator.assertList(curCoord);
                curCoord.add(coords[1]);
                curCoord.add(coords[0]);
            } else if (type == 0) {
                if (curCoord != null && !curCoord.isEmpty()) {
                    coordLists.add(LineCoordinateGenerator.toArray(curCoord));
                    curCoord = null;
                }
                lastMovedToPntX = coords[0];
                lastMovedToPntY = coords[1];
                curCoord = LineCoordinateGenerator.assertList(curCoord);
                curCoord.add(lastMovedToPntY);
                curCoord.add(lastMovedToPntX);
            } else if (type == 4) {
                double x = coords[0];
                double y = coords[1];
                if (x != lastMovedToPntX && y != lastMovedToPntY) {
                    curCoord = LineCoordinateGenerator.assertList(curCoord);
                    curCoord.add(y);
                    curCoord.add(x);
                }
                if (curCoord != null && !curCoord.isEmpty()) {
                    coordLists.add(LineCoordinateGenerator.toArray(curCoord));
                    curCoord = null;
                }
            }
            pi.next();
        }
        if (curCoord != null && !curCoord.isEmpty()) {
            coordLists.add(LineCoordinateGenerator.toArray(curCoord));
        }
        return coordLists;
    }

    private static List<Double> assertList(List<Double> list) {
        if (list != null) {
            return list;
        }
        return new ArrayList<Double>();
    }

    private static double[] toArray(List<Double> coords) {
        double[] ret = new double[coords.size()];
        int i = 0;
        for (double d : coords) {
            ret[i++] = d;
        }
        return ret;
    }
}

