/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPart;
import com.bbn.openmap.tools.icon.IconPartCollection;
import com.bbn.openmap.tools.icon.IconPartCollectionEntry;
import com.bbn.openmap.tools.icon.IconPartList;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class OpenMapAppPartCollection
extends IconPartCollection {
    static OpenMapAppPartCollection omparts;
    public static final OpenMapAppPart BIG_BOX;
    public static final OpenMapAppPart SMALL_BOX;
    public static final OpenMapAppPart FILL_BOX;
    public static final OpenMapAppPart UL_TRI;
    public static final OpenMapAppPart LR_TRI;
    public static final OpenMapAppPart LL_UR_LINE;
    public static final OpenMapAppPart UL_LR_LINE;
    public static final OpenMapAppPart BIG_ARROW;
    public static final OpenMapAppPart MED_ARROW;
    public static final OpenMapAppPart SMALL_ARROW;
    public static final OpenMapAppPart CORNER_TRI;
    public static final OpenMapAppPart OPP_CORNER_TRI;
    public static final OpenMapAppPart CIRCLE;
    public static final OpenMapAppPart DOT;
    public static final OpenMapAppPart PLUS;
    public static final OpenMapAppPart ADD_PLUS;
    public static final OpenMapAppPart MINUS;
    public static final OpenMapAppPart MAP_PIN_HEAD;
    public static final OpenMapAppPart MAP_PIN_BOTTOM;

    protected OpenMapAppPartCollection() {
        super("OpenMap", "Common parts used in OpenMap Application Icons");
        this.init();
    }

    public static synchronized OpenMapAppPartCollection getInstance() {
        if (omparts == null) {
            omparts = new OpenMapAppPartCollection();
        }
        return omparts;
    }

    protected void init() {
        this.add(BIG_BOX);
        this.add(SMALL_BOX);
        this.add(FILL_BOX);
        this.add(UL_TRI);
        this.add(LR_TRI);
        this.add(LL_UR_LINE);
        this.add(UL_LR_LINE);
        this.add(BIG_ARROW);
        this.add(MED_ARROW);
        this.add(SMALL_ARROW);
        this.add(CORNER_TRI);
        this.add(OPP_CORNER_TRI);
        this.add(CIRCLE);
    }

    public static IconPart getReloadSymbol() {
        IconPartList ipList = new IconPartList();
        ipList.add(new OpenMapAppPart.Arc("RELOAD_ARC", "RELOAD_ARC", 50.0, 50.0, 30.0, 90.0, 270.0, 0).getIconPart());
        ipList.add(new OpenMapAppPart.Poly("RELOAD_POINT", "RELOAD_POINT", new int[]{43, 65, 49}, new int[]{15, 20, 37}).getIconPart());
        return ipList;
    }

    public static IconPart getSettingsSymbol() {
        IconPartList ipList = new IconPartList();
        ipList.add(new OpenMapAppPart.Circle("SETTINGS_CIRCLE", "SETTINGS_CIRCLE", 50.0, 50.0, 30.0).getIconPart());
        for (int i = 0; i < 360; i += 30) {
            double angle = Math.toRadians(i);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x1 = 30.0 * cos + 50.0;
            double y1 = 30.0 * sin + 50.0;
            double x2 = 40.0 * cos + 50.0;
            double y2 = 40.0 * sin + 50.0;
            Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            ipList.add(new OpenMapAppPart("RELOAD_POINT", "RELOAD_POINT", line).getIconPart());
        }
        return ipList;
    }

    static {
        BIG_BOX = new OpenMapAppPart.Poly("BIG_BOX", "BIG_BOX", new int[]{10, 10, 90, 90, 10}, new int[]{10, 90, 90, 10, 10});
        SMALL_BOX = new OpenMapAppPart.Poly("SMALL_BOX", "SMALL_BOX", new int[]{30, 30, 70, 70, 30}, new int[]{30, 70, 70, 30, 30});
        FILL_BOX = new OpenMapAppPart.Poly("FILL_BOX", "FILL_BOX", new int[]{10, 10, 50, 50, 30, 30, 70, 70, 50, 50, 90, 90, 10}, new int[]{10, 90, 90, 70, 70, 30, 30, 70, 70, 90, 90, 10, 10});
        UL_TRI = new OpenMapAppPart.Poly("UL_TRI", "UL_TRI", new int[]{10, 10, 75, 10}, new int[]{10, 75, 10, 10});
        LR_TRI = new OpenMapAppPart.Poly("LR_TRI", "LR_TRI", new int[]{25, 90, 90, 25}, new int[]{90, 90, 25, 90});
        LL_UR_LINE = new OpenMapAppPart.Poly("LL_UR_LINE", "LL_UR_LINE", new int[]{10, 90}, new int[]{90, 10});
        UL_LR_LINE = new OpenMapAppPart.Poly("UL_LR_LINE", "UL_LR_LINE", new int[]{10, 90}, new int[]{10, 90});
        BIG_ARROW = new OpenMapAppPart.Poly("BIG_ARROW", "BIG_ARROW", new int[]{50, 90, 80, 80, 20, 20, 10, 50}, new int[]{10, 40, 40, 90, 90, 40, 40, 10});
        MED_ARROW = new OpenMapAppPart.Poly("MED_ARROW", "MED_ARROW", new int[]{50, 90, 70, 70, 30, 30, 10, 50}, new int[]{10, 50, 50, 90, 90, 50, 50, 10});
        SMALL_ARROW = new OpenMapAppPart.Poly("SMALL_ARROW", "SMALL_ARROW", new int[]{50, 80, 60, 60, 40, 40, 20, 50}, new int[]{10, 50, 50, 90, 90, 50, 50, 10});
        CORNER_TRI = new OpenMapAppPart.Poly("CORNER_TRI", "CORNER_TRI", new int[]{10, 50, 10}, new int[]{10, 10, 50});
        OPP_CORNER_TRI = new OpenMapAppPart.Poly("OPP_CORNER_TRI", "OPP_CORNER_TRI", new int[]{50, 90, 50}, new int[]{50, 50, 90});
        CIRCLE = new OpenMapAppPart.Circle("CIRCLE", "CIRCLE", 50.0, 50.0, 46.0);
        DOT = new OpenMapAppPart.Circle("DOT", "DOT", 50.0, 50.0, 6.0);
        PLUS = new OpenMapAppPart.Poly("PLUS", "PLUS", new int[]{25, 50, 50, 50, 50, 75, 75, 50, 50, 50, 50, 25, 25}, new int[]{50, 50, 25, 25, 50, 50, 50, 50, 75, 75, 50, 50, 50});
        ADD_PLUS = new OpenMapAppPart.Poly("ADD_PLUS", "ADD_PLUS", new int[]{70, 80, 80, 80, 80, 90}, new int[]{20, 20, 10, 30, 20, 20});
        MINUS = new OpenMapAppPart.Poly("MINUS", "MINUS", new int[]{25, 75}, new int[]{50, 50});
        MAP_PIN_HEAD = new OpenMapAppPart.Circle("MAP_PIN_HEAD", "MAP_PIN_HEAD", 50.0, 33.0, 30.0);
        MAP_PIN_BOTTOM = new OpenMapAppPart.Poly("MAP_PIN_BOTTOM", "MAP_PIN_BOTTOM", new int[]{50, 30, 70, 50}, new int[]{90, 50, 50, 90});
    }

    public static class OpenMapAppPart
    extends IconPartCollectionEntry {
        public OpenMapAppPart(String n, String d, Shape shape) {
            this(n, d, shape, null);
        }

        public OpenMapAppPart(String n, String d, Shape shape, AffineTransform affTrans) {
            super(n, d, new BasicIconPart(shape, affTrans));
        }

        public static class Arc
        extends OpenMapAppPart {
            public Arc(String n, String d, double x, double y, double radius, double start, double end, int type) {
                this(n, d, x, y, radius, start, end, type, null);
            }

            public Arc(String n, String d, double x, double y, double radius, double start, double end, int type, AffineTransform af) {
                super(n, d, new Arc2D.Double(type), af);
                Arc2D arc = (Arc2D)super.getIconPart().getGeometry();
                arc.setArcByCenter(x, y, radius, start, end, type);
            }
        }

        public static class Circle
        extends OpenMapAppPart {
            public Circle(String n, String d, double x, double y, double radius) {
                this(n, d, x, y, radius, null);
            }

            public Circle(String n, String d, double x, double y, double radius, AffineTransform af) {
                super(n, d, new Ellipse2D.Double(x - radius, y - radius, radius * 2.0, radius * 2.0), af);
            }
        }

        public static class Poly
        extends OpenMapAppPart {
            public Poly(String n, String d, int[] xp, int[] yp) {
                this(n, d, xp, yp, null);
            }

            public Poly(String n, String d, int[] xp, int[] yp, AffineTransform af) {
                super(n, d, new Polygon(xp, yp, xp.length), af);
            }
        }
    }
}

