/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGFormatter
extends AbstractImageFormatter {
    SVGGraphics2D svgGenerator = null;

    public void setProperties(String prefix, Properties props) {
    }

    public ImageFormatter makeClone() {
        return new SVGFormatter();
    }

    public byte[] formatImage(BufferedImage bi) {
        return null;
    }

    public byte[] getImageFromMapBean(MapBean map) {
        Proj proj = (Proj)map.getProjection();
        Graphics graphics = this.getGraphics(proj.getWidth(), proj.getHeight());
        map.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        proj.drawBackground((Graphics2D)graphics, map.getBckgrnd());
        if (this.layers != null) {
            for (int i = this.layers.length - 1; i >= 0; --i) {
                this.layers[i].renderDataForProjection((Projection)proj, graphics);
            }
        } else {
            Debug.error((String)"SVGFormatter can't get layers from map!");
        }
        map.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        this.layers = null;
        return this.getImageBytes();
    }

    public Graphics getGraphics(int width, int height) {
        if (this.svgGenerator == null) {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            this.svgGenerator = new SVGGraphics2D(document);
            this.svgGenerator.setClip(0, 0, width, height);
        }
        return this.svgGenerator;
    }

    public BufferedImage getBufferedImage() {
        return null;
    }

    public void setBufferedImage(BufferedImage bi) {
    }

    public BufferedImage getScaledBufferedImage(int scaledWidth, int scaledHeight) {
        return null;
    }

    public byte[] getImageBytes() {
        if (this.svgGenerator != null) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "ISO-8859-1");
                this.svgGenerator.stream((Writer)writer, false);
                return stream.toByteArray();
            }
            catch (IOException ioe) {
                Debug.error((String)"SVGFormatter caught IOException formatting svg!");
            }
        }
        return new byte[0];
    }

    public byte[] getScaledImageBytes(int scaledWidth, int scaledHeight) {
        return this.getImageBytes();
    }

    public String getFormatLabel() {
        return "SVG";
    }

    public String getContentType() {
        return "image/svg+xml";
    }

    protected boolean imageFormatSupportAlphaChannel() {
        return false;
    }

    protected boolean imageFormatSupportTransparentPixel() {
        return false;
    }
}

