/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.tokenizer;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ITokenizerFactory;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class OracleQueryTokenizer
extends QueryTokenizer
implements IQueryTokenizer {
    private static final ILogger s_log = LoggerController.createLogger(OracleQueryTokenizer.class);
    private static final String PROCEDURE_PATTERN = "^\\s*CREATE\\s+PROCEDURE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PROCEDURE\\s+.*";
    private static final String FUNCTION_PATTERN = "^\\s*CREATE\\s+FUNCTION.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+FUNCTION\\s+.*";
    private static final String TRIGGER_PATTERN = "^\\s*CREATE\\s+TRIGGER.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+TRIGGER\\s+.*";
    private static final String PACKAGE_PATTERN = "^\\s*CREATE\\s+PACKAGE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PACKAGE\\s+.*";
    private static final String DECLARE_PATTERN = "^\\s*DECLARE\\s*.*";
    private static final String BEGIN_PATTERN = "^\\s*BEGIN\\s*.*";
    private static final String SLASH_PATTERN = ".*\\n/\\n.*";
    private static final String SLASH_SPLIT_PATTERN = "\\n/\\n";
    private final String SET_COMMAND_PATTERN = "^\\s*SET\\s+\\w+\\s+\\w+\\s*$";
    private Pattern procPattern = Pattern.compile("^\\s*CREATE\\s+PROCEDURE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PROCEDURE\\s+.*", 32);
    private Pattern funcPattern = Pattern.compile("^\\s*CREATE\\s+FUNCTION.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+FUNCTION\\s+.*", 32);
    private Pattern triggerPattern = Pattern.compile("^\\s*CREATE\\s+TRIGGER.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+TRIGGER\\s+.*", 32);
    private Pattern packagePattern = Pattern.compile("^\\s*CREATE\\s+PACKAGE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PACKAGE\\s+.*", 32);
    private Pattern declPattern = Pattern.compile("^\\s*DECLARE\\s*.*", 32);
    private Pattern beginPattern = Pattern.compile("^\\s*BEGIN\\s*.*", 32);
    private Pattern slashPattern = Pattern.compile(".*\\n/\\n.*", 32);
    private Pattern setPattern = Pattern.compile("^\\s*SET\\s+\\w+\\s+\\w+\\s*$", 32);
    private static final String ORACLE_SCRIPT_INCLUDE_PREFIX = "@";
    private IQueryTokenizerPreferenceBean _prefs = null;

    public OracleQueryTokenizer(IQueryTokenizerPreferenceBean prefs) {
        super(prefs.getStatementSeparator(), prefs.getLineComment(), prefs.isRemoveMultiLineComments());
        this._prefs = prefs;
    }

    public void setScriptToTokenize(String script) {
        super.setScriptToTokenize(script);
        this.removeSqlPlusSetCommands();
        this.breakApartNewLines();
        this.joinFragments(this.procPattern, false);
        this.joinFragments(this.funcPattern, false);
        this.joinFragments(this.triggerPattern, false);
        this.joinFragments(this.packagePattern, false);
        this.joinFragments(this.declPattern, false);
        this.joinFragments(this.beginPattern, true);
        this.expandFileIncludes(ORACLE_SCRIPT_INCLUDE_PREFIX);
        this.removeRemainingSlashes();
        this._queryIterator = this._queries.iterator();
    }

    private void removeSqlPlusSetCommands() {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String next : this._queries) {
            String[] parts = next.split("\\n");
            StringBuilder noCommandStr = new StringBuilder();
            for (String part : parts) {
                if (this.setPattern.matcher(part.toUpperCase()).matches()) continue;
                noCommandStr.append(part).append("\n");
            }
            tmp.add(noCommandStr.toString());
        }
        this._queries = tmp;
    }

    protected void setFactory() {
        this._tokenizerFactory = new ITokenizerFactory(){

            public IQueryTokenizer getTokenizer() {
                return new OracleQueryTokenizer(OracleQueryTokenizer.this._prefs);
            }
        };
    }

    private void removeRemainingSlashes() {
        ArrayList<String> tmp = new ArrayList<String>();
        boolean foundEOLSlash = false;
        for (String next : this._queries) {
            if (this.slashPattern.matcher(next).matches()) {
                foundEOLSlash = true;
                String[] parts = next.split(SLASH_SPLIT_PATTERN);
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    if (this.slashPattern.matcher(part).matches()) {
                        int lastIndex = part.lastIndexOf("/");
                        tmp.add(part.substring(0, lastIndex));
                        continue;
                    }
                    if (part.endsWith("/")) {
                        part = part.substring(0, part.lastIndexOf("/"));
                    }
                    tmp.add(part);
                }
                continue;
            }
            if (next.endsWith("/")) {
                foundEOLSlash = true;
                int lastIndex = next.lastIndexOf("/");
                tmp.add(next.substring(0, lastIndex));
                continue;
            }
            tmp.add(next);
        }
        if (foundEOLSlash) {
            this._queries = tmp;
        }
    }

    private void breakApartNewLines() {
        ArrayList<String> tmp = new ArrayList<String>();
        String sep = this._prefs.getProcedureSeparator();
        for (String next : this._queries) {
            if (next.startsWith(sep)) {
                tmp.add(sep);
                String[] parts = next.split(sep + "\\n+");
                for (int i = 0; i < parts.length; ++i) {
                    if ("".equals(parts[i]) || sep.equals(parts[i])) continue;
                    tmp.add(parts[i]);
                }
                continue;
            }
            tmp.add(next);
        }
        this._queries = tmp;
    }

    private void joinFragments(Pattern pattern, boolean skipStraySlash) {
        boolean inMultiSQLStatement = false;
        StringBuffer collector = null;
        ArrayList<String> tmp = new ArrayList<String>();
        String sep = this._prefs.getProcedureSeparator();
        for (String next : this._queries) {
            if (pattern.matcher(next.toUpperCase()).matches()) {
                inMultiSQLStatement = true;
                collector = new StringBuffer(next);
                collector.append(";");
                continue;
            }
            if (next.startsWith(sep) && !next.startsWith("/*")) {
                inMultiSQLStatement = false;
                if (collector != null) {
                    tmp.add(collector.toString());
                    collector = null;
                    continue;
                }
                if (skipStraySlash) {
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("Detected stray proc separator(" + sep + "). Skipping"));
                    continue;
                }
                tmp.add(next);
                continue;
            }
            if (inMultiSQLStatement) {
                collector.append(next);
                collector.append(";");
                continue;
            }
            tmp.add(next);
        }
        this._queries = tmp;
    }

    public TokenizerSessPropsInteractions getTokenizerSessPropsInteractions() {
        if (this._prefs.isInstallCustomQueryTokenizer()) {
            TokenizerSessPropsInteractions ret = new TokenizerSessPropsInteractions();
            ret.setTokenizerDefinesRemoveMultiLineComment(true);
            ret.setTokenizerDefinesStartOfLineComment(true);
            ret.setTokenizerDefinesStatementSeparator(true);
            return ret;
        }
        return super.getTokenizerSessPropsInteractions();
    }
}

